//	Vamos - a driving simulator
//  Copyright (C) 2001 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _TWO_POINT_H_
#define _TWO_POINT_H_

#include <iostream>

namespace Vamos_Geometry
{
  class Two_Point
  {
	  public:
		  
	double x;
	double y;
	
	Two_Point (double x_in, double y_in) : x (x_in), y (y_in) {};
	Two_Point () : x (0.0), y (0.0) {};
  };

  // Arithmetic operators
  Two_Point operator + (Two_Point p1, Two_Point p2);
  Two_Point operator + (Two_Point p, double scalar);
  Two_Point operator + (double scalar, Two_Point p);
  Two_Point operator - (Two_Point p1, Two_Point p2);
  Two_Point operator - (Two_Point p, double scalar);
  Two_Point operator - (double scalar, Two_Point p);
  Two_Point operator * (Two_Point p1, Two_Point p2);
  Two_Point operator * (Two_Point p, double scalar);
  Two_Point operator * (double scalar, Two_Point p);
  Two_Point operator / (Two_Point p1, Two_Point p2);
  Two_Point operator / (Two_Point p, double scalar);
  Two_Point operator / (double scalar, Two_Point p);

  // Stream operators.
  std::istream& operator >> (std::istream& is, Two_Point& point);
  std::ostream& operator << (std::ostream& os, const Two_Point& point);
}

#endif
