#include "gui/gui.h"
#include "gui/label.h"
using namespace VGUI;


Label::Label( Widget* w )
{
	center = w->GetCenter();
	name = w->GetName();
	text = w->GetText();
	type = w->GetType();
	tip = w->GetTip();
	rel_width = w->GetRelWidth();
	rel_height = w->GetRelHeight();
	enabled = w->GetEnabled();
	selected = w->GetSelected();
	is_default = w->GetDefault();
	is_cancel = w->GetCancel();
	has_icon = w->GetHasIcon();
	width_auto = w->GetWidthAuto();
	height_auto = w->GetHeightAuto();
	font_size = w->GetFontSize();
	color_r = w->GetColorR();
	color_g = w->GetColorG();
	color_b = w->GetColorB();
}

Label::~Label()
{
}

void Label::Draw()
{
	Draw( 1.0 );
}

void Label::Draw( float opacity )
{
	// draw text
	font.Print( center.GetXPercent() - ( font.Width( text.c_str(), 1, font_size ) / 2.0f ), center.GetYPercent() - ( font.Height( text.c_str(), 1, font_size ) / 2.0f ), text.c_str(), 1, font_size, color_r, color_g, color_b, 0.9 * opacity );
}
