"""Probe a Volume (voxel dataset) with lines"""
from vedo import *

vol = load(datadir+"embryo.slc")

lines = []
for i in range(60):  # probe scalars on 60 parallel lines
    step = (i - 30) * 2
    p1 = vol.center() + vector(-100, step, step)
    p2 = vol.center() + vector( 100, step, step)
    pl = probeLine(vol, p1, p2)#.pointColors(cmap='hot')
    pl.alpha(0.5).lineWidth(4)
    lines.append(pl)
    #print(pl.getPointArray()) # numpy scalars can be accessed here
    #print(pl.getPointArray('vtkValidPointMask')) # the mask of valid points

show(lines, __doc__)
