#!/usr/bin/perl -w
#
# This script generates the list of all Verbiste infinitives into a file
# called "all-verbiste-infinitives.lst" and prints to STDOUT the list of
# all conjugated forms known to Verbiste.
# Some forms can appear twice.  Piping the output of this script to the
# 'sort -uf' command eliminates the duplicates while sorting the result.
# The french-conjugator command must be in the PATH.

use strict;
use XML::Parser;
use IPC::Open2;

my @stack = ();
my $acc;
my $tempFile;

sub Start
{
    my ($expat, $el, %att) = @_;

    push @stack, $el;
    $acc = "";
}

sub Char
{
    my ($expat, $str) = @_;

    $acc .= $str if defined $acc;
}

sub End
{
    my ($expat, $el) = @_;

    die unless $el eq pop @stack;

    if ($el eq "i")
    {
	die unless defined $acc;
	die unless length($acc) > 0;

	print $tempFile "$acc\n";
    }

    $acc = undef;
}


my $tempFilename = "all-verbiste-infinitives.lst";
open($tempFile, "> $tempFilename") or die;

my $parser = new XML::Parser(Handlers => {
	Start => \&Start,
	Char => \&Char,
	End => \&End,
	});

$parser->parsefile("../data/verbs-fr.xml");

close($tempFile) or die;

open(VERBISTE, "french-conjugator < $tempFilename |") or die;

while (<VERBISTE>)
{
    next if /^$/ || /^-/;
    chomp;
    my @words = split /, /, $_;
    print "$_\n" foreach (@words);
}

close(VERBISTE);
