.TH vvp 1 "$Date: 2003/12/07 20:05:56 $" Version "$Date: 2003/12/07 20:05:56 $"
.SH NAME
vvp - Icarus Verilog vvp runtime engine

.SH SYNOPSIS
.B vvp
[-dv] [-Mpath] [-mmodule] [-llogfile] inputfile [extended-args...]

.SH DESCRIPTION
.PP
\fIvvp\fP is the run time engine that executes the default compiled
form generated by Icarus Verilog. The output from the \fIiverilog\fP
command is not by itself executable on any platform. Instead, the
\fIvvp\fP program is invoked to execute the generated output file.

.SH OPTIONS
.l
\fIvvp\fP accepts the following options:
.TP 8
.B -l\fIlogfile\fP
This flag specifies a logfile where all MCI <stdlog> output goes.
Specify logfile as '-' to send log output to <stderr>.  $display and
friends send their output both to <stdout> and <stdlog>.
.TP 8
.B -M\fIpath\fP
This flag adds a directory to the path list used to locate VPI
modules. The default path includes only the install directory for the
system.vpi module, but this flag can add other directories. Multiple
paths are allowed, and modules will be searched in order.
.TP 8
.B -m\fImodule\fP
Tell the vvp run time to load the named module before executing the
simulation. The \fBsystem.vpi\fP module is loaded by default, but
additional modules, including modules that you compiled locally, can
be specified with this flag. Any number of modules can be loaded, and
they will be linked in the order they are listed on the command line.

Normally, you only need to specify the name of the module, without any
directory path or .vpi suffix and the search path is scanned to find
the module. However, if the name includes at least one directory
character, then the search path is not scanned and the name is assumed
to be a complete file name.
.TP 8
.B -v
Turn on verbose messages. This will cause information about run time
progress to be printed to standard out.

.SH EXTENDED ARGUMENTS
.PP
The vvp options described above must come before the design file name.
After the design file name, however, there may be any number of
unspecified arguments. These arguments are not interpreted by vvp but
are instead passed on to the executed design, and are available via
the \fI$test$plusargs\fP and \fI$value$plusargs\fP system functions.
.PP
Arguments that do not start with the plus(+) character are not
available to the \fI$plusargs\fP system tasks, but can still be
accessed via PLI code via the \fIvpi_get_vlog_info\fP function. This
means that vpi modules may use arguments that do not start with + and
be assured that they do not interfere with user defined plus-args.
.PP
There are a few extended arguments that are interpreted by the
standard system.vpi module, which implements the standard system tasks
and so is always included. These arguments are described here.
.TP 8
.B -vcd\fR|\fP-vcd-none
This extended argument sets the wave dump format to VCD. This is the
default in the absence of any \fBIVERILOG_DUMPER\fP environment
variable. The VCD dump files are large and ponderous, but are also
maximally compatible with third party tools that read waveform dumps.
.PP
The \fB-vcd-none\fP variant actually suppresses all waveform
output. This can make long simulations run faster.

.TP 8
.B -lxt\fR|\fP-lxt-speed\fR|\fP-lxt-space\fR|\fP-lxt-none
These extended arguments set the wave dump format to lxt, possibly with
format optimizations. The \fB-lxt-space\fP flag sets the output
format to lxt with full compression enabled. The resulting files are
quite small. The \fB-lxt-speed\fP chooses the lxt compression mode
that leads to the best execution time and the fastest read time, at
the expense of some file size.
.PP
The \fB-lxt-none\fP variant actually suppresses all waveform
output. This can make long simulations run faster.

.TP 8
.B -lxt2
The LXT2 format is slower then LXT (faster then VCD) but takes less
space, and is written out incrementally. Thus, you can view lxt2 files
while a simulation is still running (or paused) or if your simulation
crashes or is killed, you still have a useful dump.

.SH ENVIRONMENT
.PP
The vvp command also accepts some environment variables that control
its behavior. These can be used to make semi-permanent changes.

.TP 8
.B IVERILOG_DUMPER=\fIlxt|lxt2|vcd|none\fP
This selects the output format for the waveform output. Normally,
waveforms are dumped in vcd format, but this variable can be used to
select lxt format, which is far more compact, though limited to
gtkwave or compatible viewers. It can also be used to suppress VCD
output, a time-saver for regression tests.

.SH INTERACTIVE MODE
.PP
The simulation engine supports an interactive mode. The user may
interrupt the simulation (typically by typing Ctrl-C) to get to the
interactive prompt. From that prompt, the \fIhelp\fP command prints a
brief summary of the available commands.
.PP
The interactive mode may also be entered by a call to the \fI$stop\fP
system task from within the simulation, or by a call to the
\fIvpi_control\fP VPI function with the \fIvpiStop\fP control
argument. These means of entering interactive mode are equivalent.

.SH "AUTHOR"
.nf
Steve Williams (steve@icarus.com)

.SH SEE ALSO
iverilog(1),
iverilog-vpi(1),
.BR "<http://www.icarus.com/eda/verilog/>"

.SH COPYRIGHT
.nf
Copyright \(co  2001-2003 Stephen Williams

This document can be freely redistributed according to the terms of the 
GNU General Public License version 2.0
