#!/usr/bin/env python
# -*- coding: UTF8 -*-

###
# This file is part of VideoManager.
#
# ErrorManager is the legal property of Erwan Briand <xbright2005@gmail.com>
# Copyright (c) 2006 Erwan Briand
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk.glade,gtk,sys,smtplib,os
from email.MIMEText import MIMEText
from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email.MIMEText import MIMEText
from email.Utils import COMMASPACE, formatdate
from email import Encoders

class Manage:

    def __init__(self):
	global setupmail
	global setupfile
	global setupsmtp
	global setuplocale

    def SetLocale (self,locale):
	global setuplocale
	setuplocale = locale

    def SetServeur(self,adresse):
	global setupsmtp
	setupsmtp = adresse

    def SetMail(self,adresse):
	global setupmail
	setupmail = adresse

    def SetNomFichier(self,fichier):
	global setupfile
	setupfile = fichier

    def Alerte(self,importance,texte,ida):
	global setupmail
	global setupfile
	
	if importance == 0:	setuppriority = "Banale"
	if importance == 1:	setuppriority = "Importante"
	if importance == 2:	setuppriority = "Critique"

	Fenetre(setupfile,setuppriority,texte,ida,setuplocale)

class Fenetre:

    def on_button2_clicked(self,args):
	subject = "["+self.stc+"] Erreur dans "+self.stb
	text = self.sta+"\n\n--------------------------------------------\nCe rapport vous a été fourni par l'outil de gestion d'erreurs que vous utilisez dans la source "+self.stb+" !\nPour plus d'informations : http://www.codingteam.net"
	to = setupmail
	fro = "Outil de suivi des erreurs <info@codingteam.net>"
	msg = MIMEMultipart()
	msg['From'] = fro
	msg['To'] = to
	msg['Date'] = formatdate(localtime=True)
	msg['Subject'] = subject
	msg.attach( MIMEText(text, 'plain', 'UTF-8') )
	smtp = smtplib.SMTP(setupsmtp)
	smtp.sendmail(fro, to, msg.as_string() )
	smtp.close()

    def on_button3_clicked(self,args):
	gtk.main_quit()
	return False

    def __init__(self,setupfile,setuppriority,setuptexte,ida,setuplocale):
	self.sta = setuptexte
	self.stb = setupfile
	self.stc = setuppriority
	self.stl = setuplocale

	ui = gtk.glade.XML(os.path.dirname(os.path.realpath(__file__))+"/erreurs.glade")

	WIND = ui.get_widget("window1")
	WIND.connect("destroy", gtk.main_quit)

	WIND1 = ui.get_widget("button2")
	WIND1.connect("clicked", self.on_button2_clicked)

	WIND2 = ui.get_widget("button3")
	WIND2.connect("clicked", self.on_button3_clicked)

	if ida == 0:
		WIND1.hide()

	textview = ui.get_widget("textview1")
	textview.set_wrap_mode(gtk.WRAP_WORD)
	buffertexte = textview.get_buffer()
	buffertexte.set_text(setuptexte)

	label1 = ui.get_widget("label6")
	label1.set_markup("<i>"+setupfile+"</i>")

	label2 = ui.get_widget("label5")
	label2.set_markup("<i>"+setuppriority+"</i>")

	if setuplocale != "fr":
		WIND2.set_label("Close")
		ui.get_widget("label1").set_markup("<big><b>An error has occurred !</b></big>")
		ui.get_widget("label2").set_markup("<b>More information...</b>")

	gtk.main()
