/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                  R A Y . C                                   *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, October 2003                    *
*                                                                              *
********************************************************************************
*
* $Id: ray.c,v 1.6 2003/11/07 11:09:36 jrh Exp $
* $Log: ray.c,v $
* Revision 1.6  2003/11/07 11:09:36  jrh
* Release 2.4
*
* Revision 1.5  2000/12/10 15:14:33  jrh
* Release 2.3
*
* Revision 1.4  1999/05/24 01:27:03  jrh
* Release 2.2.1
*
* Revision 1.3  1999/02/07 21:55:11  jrh
* Release 2.2
*
* Revision 1.2  1998/01/26 00:49:07  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:43:24  jrh
* Initial revision
*
*/
#include<math.h>
#include<stdio.h>
#include<unistd.h>
#include<GL/gl.h>
#include<GL/glu.h>
#include "viewmol.h"
#include "dialog.h"

extern void transformCoordinates(int, float input[4], float output[4]);
extern void *getmem(size_t, size_t);
extern void fremem(void **);

extern struct WINDOW windows[];
extern struct MOLECULE *molecules;
extern struct ELEMENT *elements;
extern double tmat[4][4];
extern GLfloat light0p[], light1p[];
extern float *transObject;
extern int ne, iwavef, lights, projectionMode;

static struct ELEMENT *material;
static double n[3], nSave[3][3], vSave[3][3];
static int printNormal=FALSE, nCorners, povray=TRUE;
static FILE *f;

FILE *raytraceInit(char *filename, Dimension width, Dimension height)
{
  struct MOLECULE *mol;
  struct ELEMENT *element=(struct ELEMENT *)NULL;
  FILE *file;
  double todeg=45.0/atan(1.0), box;
  GLfloat xview, zview, light[4], lookat[4]={0.0, 0.0, -1.0, 1.0}, up[4]={0.0, 1.0, 0.0, 1.0};
  int *done, hbond;
  register int i, j;

  if ((file=fopen(filename, "w")) == NULL) return(NULL);
  if (!povray)
    fprintf(file, "screen %d %d\n", width, height);
  if (2.0*windows[VIEWER].far > transObject[3*VIEWPOINT+2])
    zview=2.0*windows[VIEWER].far-transObject[3*VIEWPOINT+2];
  else
    zview=0.1;
  xview=-0.75*windows[VIEWER].near*windows[VIEWER].top*(GLfloat)(width)/(windows[VIEWER].far
       *(GLfloat)(height));
  up[1]=(GLfloat)(zview/(2.0*xview));
  if (povray)
  {
    if (projectionMode == ORTHO)
      fprintf(file, "camera {\n  orthographic\n");
    else
      fprintf(file, "camera {\n  perspective\n");
    fprintf(file, "  location <%.7f, %.7f, %.7f>\n", (-transObject[3*VIEWPOINT]),
            (-transObject[3*VIEWPOINT+1]), zview);
  }
  else
    fprintf(file, "eyep %12.7f %12.7f %12.7f\n", (-transObject[3*VIEWPOINT]),
            (-transObject[3*VIEWPOINT+1]), zview+windows[VIEWER].far);
  transformCoordinates(VIEWPOINT, up, light);
  if (povray)
  {
    if (projectionMode == ORTHO)
    {
     fprintf(file, "  up <%.7f, %.7f, %.7f>\n", light[0]*zview, light[1]*zview, light[2]*zview);
     fprintf(file, "  right <%.7f, 0.0, 0.0>\n", -zview*zview/(2.0*xview));
    }
    else
    {
     fprintf(file, "  up <%.7f, %.7f, %.7f>\n", light[0], light[1], light[2]);
/*  fprintf(file, "  right <%.7f, 0.0, 0.0>\n", -(double)width/(double)height);*/
     fprintf(file, "  right <%.7f, 0.0, 0.0>\n", -zview/(2.0*xview));
    }
  }
  else
  {
    fprintf(file, "up %12.7f %12.7f %12.7f\n", light[0], light[1], light[2]);
    fprintf(file, "background %6.3f %6.3f %6.3f\n", windows[VIEWER].background_rgb[0],
            windows[VIEWER].background_rgb[1], windows[VIEWER].background_rgb[2]);
  }
  transformCoordinates(VIEWPOINT, lookat, light);
  light[0]*=(float)(10.0*windows[VIEWER].far-transObject[3*VIEWPOINT+2]);
  light[1]*=(float)(10.0*windows[VIEWER].far-transObject[3*VIEWPOINT+2]);
  light[2]*=(float)(10.0*windows[VIEWER].far-transObject[3*VIEWPOINT+2]);
  if (povray)
  {
    fprintf(file, "  look_at <%.7f, %.7f, %.7f>}\n", light[0]-transObject[3*VIEWPOINT],
            light[1]-transObject[3*VIEWPOINT+1], light[2]-transObject[3*VIEWPOINT+2]);
    fprintf(file, "background { color rgb <%.3f, %.3f, %.3f>}\n", windows[VIEWER].background_rgb[0],
            windows[VIEWER].background_rgb[1], windows[VIEWER].background_rgb[2]);
  }
  else
  {
    fprintf(file, "lookp %12.7f %12.7f %12.7f\n", light[0]-transObject[3*VIEWPOINT],
            light[1]-transObject[3*VIEWPOINT+1], light[2]-transObject[3*VIEWPOINT+2]);
    fprintf(file, "fov %f\n", 2.0*todeg*atan((double)(xview/zview)));
  }
  box=2.0*windows[VIEWER].far;
  if (lights & 0x1)
  {
    transformCoordinates(LIGHTNO0, light0p, light);
    if (povray)
      fprintf(file, "light_source { <%.7f, %.7f, %.7f>\n  color <1.0, 1.0, 1.0>\n  shadowless\n}\n",
              box*light[0], box*light[1], box*light[2]);
    else
      fprintf(file, "light 1.0 directional %10.5f %10.5f %10.5f noshadow\n",
              light[0], light[1], light[2]);
  }
  if (lights & 0x2)
  {
    transformCoordinates(LIGHTNO1, light1p, light);
    if (povray)
      fprintf(file, "light_source { <%.7f, %.7f, %.7f>\n  color <1.0, 1.0, 1.0>\n}\n",
              box*light[0], box*light[1], box*light[2]);
    else
      fprintf(file, "light 0.5 directional %10.5f %10.5f %10.5f\n", light[0],
              light[1], light[2]);
  }
  if (windows[VIEWER].set >= 0)
    mol=&molecules[windows[VIEWER].set];
  else
    mol=&molecules[0];
  hbond=FALSE;
  for (i=0; i<mol->nb; i++)
  {
    if (mol->bonds[i].order == (-1))
    {
      hbond=TRUE;
      break;
    }
  }
  done=(int *)getmem(mol->na, sizeof(int));
  for (i=0; i<mol->na; i++)
  {
    if (!done[i])
    {
      element=mol->atoms[i].element;
      if (povray)
      {
        fprintf(file, "#declare %s = texture {\n", element->symbol);
        fprintf(file, "  pigment {color rgbf <%.3f, %.3f, %.3f, %.3f>}\n",
                (element->dark[0]+element->light[0])*0.5,
                (element->dark[1]+element->light[1])*0.5,
                (element->dark[2]+element->light[2])*0.5,
                1.0-element->alpha);
        fprintf(file, "  finish {ambient rgb <%.3f, %.3f, %.3f>\n  phong 0.9\n",
                element->ambient[0], element->ambient[1], element->ambient[2]);
        fprintf(file, "  specular %.3f}}\n", element->shininess/128.0);
      }
      else
      {
        fprintf(file, "surface %s\n", element->symbol);
        fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n",
                (element->dark[0]+element->light[0])*0.5,
                (element->dark[1]+element->light[1])*0.5,
                (element->dark[2]+element->light[2])*0.5);
        /* Use only 1/10 of the ambient color since rayshade looses contrast
           otherwise */
        fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", 0.1*element->ambient[0],
                0.1*element->ambient[1], 0.1*element->ambient[2]);
        fprintf(file, "  specular %5.3f %5.3f %5.3f\n", element->specular[0],
                element->specular[1], element->specular[2]);
        fprintf(file, "  specpow %7.3f\n", element->shininess);
        fprintf(file, "  transp  %7.3f\n", 1.0-element->alpha);
      }
      for (j=i; j<mol->na; j++)
      {
        if (mol->atoms[j].element == element) done[j]=TRUE;
      }
    }
  }
  if (hbond)
  {
    element=mol->bondStyle;
    if (povray)
    {
      fprintf(file, "#declare %s = texture {\n", element->symbol);
      fprintf(file, "  pigment {color rgbf <%.3f, %.3f, %.3f, %.3f>}\n",
              (element->dark[0]+element->light[0])*0.5,
              (element->dark[1]+element->light[1])*0.5,
              (element->dark[2]+element->light[2])*0.5,
              1.0-element->alpha);
      fprintf(file, "  finish {ambient rgb <%.3f, %.3f, %.3f>\n  phong 0.9\n",
              element->ambient[0], element->ambient[1], element->ambient[2]);
      fprintf(file, "  specular %.3f}}\n", element->shininess/128.0);
    }
    else
    {
      fprintf(file, "surface %s\n", element->symbol);
      fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n",
              (element->dark[0]+element->light[0])*0.5,
              (element->dark[1]+element->light[1])*0.5,
              (element->dark[2]+element->light[2])*0.5);
      fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", 0.1*element->ambient[0],
              0.1*element->ambient[1], 0.1*element->ambient[2]);
      fprintf(file, "  specular %5.3f %5.3f %5.3f\n", element->specular[0],
              element->specular[1], element->specular[2]);
      fprintf(file, "  specpow %7.3f\n", element->shininess);
      fprintf(file, "  transp  %7.3f\n", 1.0-element->alpha);
    }
  }
  if (mol->unitcell)
  {
    element=mol->unitcell->corners[0].element;
    if (povray)
    {
      fprintf(file, "#declare %s = texture {\n", element->symbol);
      fprintf(file, "  pigment {color rgbf <%.3f, %.3f, %.3f, %.3f>}\n",
              (element->dark[0]+element->light[0])*0.5,
              (element->dark[1]+element->light[1])*0.5,
              (element->dark[2]+element->light[2])*0.5,
              1.0-element->alpha);
      fprintf(file, "  finish {ambient rgb <%.3f, %.3f, %.3f>\n  phong 0.9\n",
              element->ambient[0], element->ambient[1], element->ambient[2]);
      fprintf(file, "  specular %.3f}}\n", element->shininess/128.0);
    }
    else
    {
      fprintf(file, "surface %s\n", element->symbol);
      fprintf(file, "  diffuse %.3f %.3f %.3f\n",
              (element->dark[0]+element->light[0])*0.5,
              (element->dark[1]+element->light[1])*0.5,
              (element->dark[2]+element->light[2])*0.5);
      fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", 0.1*element->ambient[0],
              0.1*element->ambient[1], 0.1*element->ambient[2]);
      fprintf(file, "  specular %5.3f %5.3f %5.3f\n", element->specular[0],
              element->specular[1], element->specular[2]);
      fprintf(file, "  specpow %7.3f\n", element->shininess);
      fprintf(file, "  transp  %7.3f\n", 1.0-element->alpha);
    }
  }
  if (iwavef != ALL_OFF)
  {
    for (i=0; i<ne; i++)
    {
      if (!strcmp(elements[i].symbol, "Ps") || !strcmp(elements[i].symbol, "Ms"))
      {
        if (povray)
        {
          fprintf(file, "#declare %s = texture {\n", elements[i].symbol);
          fprintf(file, "  pigment {color rgbf <%.3f, %.3f, %.3f, %.3f>}\n",
                  (elements[i].dark[0]+elements[i].light[0])*0.5,
                  (elements[i].dark[1]+elements[i].light[1])*0.5,
                  (elements[i].dark[2]+elements[i].light[2])*0.5,
                  1.0-elements[i].alpha);
          fprintf(file, "  finish {ambient rgb <%.3f, %.3f, %.3f>\n  phong 0.9\n",
                  element->ambient[0], element->ambient[1], element->ambient[2]);
          fprintf(file, "  specular %.3f}}\n", element->shininess/128.0);
        }
        else
        {
          fprintf(file, "surface %s\n", elements[i].symbol);
          fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n",
                  (elements[i].dark[0]+elements[i].light[0])*0.5,
                  (elements[i].dark[1]+elements[i].light[1])*0.5,
                  (elements[i].dark[2]+elements[i].light[2])*0.5);
          fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", 0.1*elements[i].ambient[0],
                  0.1*elements[i].ambient[1], 0.1*elements[i].ambient[2]);
          fprintf(file, "  specular %5.3f %5.3f %5.3f\n", elements[i].specular[0],
                  elements[i].specular[1], elements[i].specular[2]);
          fprintf(file, "  specpow %7.3f\n", elements[i].shininess);
          fprintf(file, "  transp  %7.3f\n", 1.0-elements[i].alpha);
        }
      }
    }
  }
  fremem((void **)&done);
  if (projectionMode == PERSPECTIVE)
  {
    if (povray)
    {
      fprintf(file, "#declare ground = texture {\n");
      fprintf(file, "  pigment {color rgb <%.3f, %.3f, %.3f>}}\n",
              windows[VIEWER].foreground_rgb[0], windows[VIEWER].foreground_rgb[1],
              windows[VIEWER].foreground_rgb[2]);
      fprintf(file, "plane { <0.0, 1.0, 0.0>, %10.5f\n  texture {ground}}\n", windows[VIEWER].bottom);
    }
    else
    {
      fprintf(file, "surface ground\n");
      fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n", windows[VIEWER].foreground_rgb[0],
              windows[VIEWER].foreground_rgb[1], windows[VIEWER].foreground_rgb[2]);
      fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", 0.5*windows[VIEWER].foreground_rgb[0],
              0.5*windows[VIEWER].foreground_rgb[1], 0.5*windows[VIEWER].foreground_rgb[2]);
      fprintf(file, "plane ground 0.0 %10.5f 0.0 0.0 1.0 0.0\n", windows[VIEWER].bottom);
    }
  }
  if (!povray)
    fprintf(file, "name molecule list\n");
  f=file;
  return(file);
}

void raytraceClose(FILE *file)
{
  if (!povray)
  {
    fprintf(file, "end\n");
    fprintf(file, "object molecule\n");
  }
  fclose(file);
}

void raytracerBegin(GLenum what)
{
  if (povray)
    fprintf(f, "smooth_triangle {\n");
  else
    fprintf(f, "triangle %s ", material->symbol);
  glGetDoublev(GL_MODELVIEW_MATRIX, &tmat[0][0]);
  nCorners=0;
}

void raytracerEnd()
{
}

void raytracerVertex3d(double vx, double vy, double vz)
{
  double t[3];
  register int i;

  if (nCorners > 2)
  {
    if (povray)
      fprintf(f, "smooth_triangle {\n  <%.6f, %.6f, %.6f>, ", vSave[0][1], vSave[1][1],
              vSave[2][1]);
    else
      fprintf(f, "%10.6f %10.6f %10.6f ", vSave[0][1], vSave[1][1], vSave[2][1]);
    if (printNormal)
    {
      if (povray)
        fprintf(f, "<%.6f, %.6f, %.6f>,\n", nSave[0][1], nSave[1][1], nSave[2][1]);
      else
        fprintf(f, "%10.6f %10.6f %10.6f ", nSave[0][1], nSave[1][1], nSave[2][1]);
    }
    if (povray)
      fprintf(f, "<%.6f, %.6f, %.6f>, ", vSave[0][2], vSave[1][2], vSave[2][2]);
    else
      fprintf(f, "%10.6f %10.6f %10.6f ", vSave[0][2], vSave[1][2], vSave[2][2]);
    if (printNormal)
    {
      if (povray)
        fprintf(f, "<%.6f, %.6f, %.6f>,\n", nSave[0][2], nSave[1][2], nSave[2][2]);
      else
        fprintf(f, "%10.6f %10.6f %10.6f ", nSave[0][2], nSave[1][2], nSave[2][2]);
    }
  }
  t[0]=vx*tmat[0][0]+vy*tmat[1][0]+vz*tmat[2][0]+tmat[3][0];
  t[1]=vx*tmat[0][1]+vy*tmat[1][1]+vz*tmat[2][1]+tmat[3][1];
  t[2]=vx*tmat[0][2]+vy*tmat[1][2]+vz*tmat[2][2]+tmat[3][2];
  if (povray)
    fprintf(f, "<%.6f, %.6f, %.6f>, ", t[0], t[1], t[2]);
  else
    fprintf(f, "%10.6f %10.6f %10.6f ", t[0], t[1], t[2]);
  nCorners++;

  for (i=0; i<3; i++)
  {
    vSave[i][0]=vSave[i][1];
    vSave[i][1]=vSave[i][2];
    vSave[i][2]=t[i];
  }
  if (printNormal)
  {
    t[0]=n[0]*tmat[0][0]+n[1]*tmat[1][0]+n[2]*tmat[2][0]+tmat[3][0];
    t[1]=n[0]*tmat[0][1]+n[1]*tmat[1][1]+n[2]*tmat[2][1]+tmat[3][1];
    t[2]=n[0]*tmat[0][2]+n[1]*tmat[1][2]+n[2]*tmat[2][2]+tmat[3][2];
    if (povray)
      fprintf(f, "<%.6f, %.6f, %.6f>\n", t[0], t[1], t[2]);
    else
      fprintf(f, "%10.6f %10.6f %10.6f ", t[0], t[1], t[2]);
    printNormal=FALSE;
    for (i=0; i<3; i++)
    {
      nSave[i][0]=nSave[i][1];
      nSave[i][1]=nSave[i][2];
      nSave[i][2]=t[i];
    }
    if (nCorners > 2)
    {
      if (povray)
        fprintf(f, " texture {%s}}\n", material->symbol);
      else
        fprintf(f, "\n");
    }
  }
}

void raytracerNormal3d(double vx, double vy, double vz)
{
  n[0]=vx;
  n[1]=vy;
  n[2]=vz;
  printNormal=TRUE;
}

void raytracerSphere(GLUquadricObj *object, GLdouble radius, GLint dummy1,
                     GLint dummy2)
{
  double matrix[4][4];

  glGetDoublev(GL_MODELVIEW_MATRIX, &matrix[0][0]);
  if (povray)
    fprintf(f, "sphere { <%10.6f, %10.6f, %10.6f>, %f\n  texture {%s}}\n",
            matrix[3][0], matrix[3][1], matrix[3][2], radius, material->symbol);
  else
    fprintf(f, "sphere %s %f %10.6f %10.6f %10.6f\n", material->symbol, radius,
            matrix[3][0], matrix[3][1], matrix[3][2]);
}

void raytracerCylinder(GLUquadricObj *object, GLdouble top, GLdouble bottom,
                       GLdouble height, GLint dummy1, GLint dummy2)
{
  double matrix[4][4];

  glGetDoublev(GL_MODELVIEW_MATRIX, &matrix[0][0]);
  if (povray)
    fprintf(f, "cylinder {<%10.6f, %10.6f, %10.6f>,\n  <%10.6f, %10.6f, %10.6f>,\n  %f open\n texture {%s}}\n",
            matrix[3][0], matrix[3][1], matrix[3][2],
            height*matrix[2][0]+matrix[3][0], height*matrix[2][1]+matrix[3][1],
            height*matrix[2][2]+matrix[3][2], bottom, material->symbol);
  else
    fprintf(f, "cylinder %s %f %10.6f %10.6f %10.6f %10.6f %10.6f %10.6f\n",
            material->symbol, bottom, matrix[3][0], matrix[3][1], matrix[3][2],
            height*matrix[2][0]+matrix[3][0], height*matrix[2][1]+matrix[3][1],
            height*matrix[2][2]+matrix[3][2]);
}

void raytracerCone(GLUquadricObj *object, GLdouble top, GLdouble bottom,
                   GLdouble height, GLint dummy1, GLint dummy2)
{
  double matrix[4][4];

  glGetDoublev(GL_MODELVIEW_MATRIX, &matrix[0][0]);
  if (povray)
    fprintf(f, "cone {<%.6f, %.6f, %.6f>, %.6f\n  <%.6f, %.6f, %.6f>, %.6f\n open\n texture {%s}}\n",
            matrix[3][0], matrix[3][1], matrix[3][2], top,
            height*matrix[2][0]+matrix[3][0], height*matrix[2][1]+matrix[3][1],
            height*matrix[2][2]+matrix[3][2], bottom, material->symbol);
}

void raytracerColor4fv(const GLfloat *color)
{
}

void raytracerClearColor(GLclampf red, GLclampf green , GLclampf blue, GLclampf alpha)
{
}

void raytracerMaterial(struct ELEMENT *e)
{
  material=e;
}
