
// created 11.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL


#include "Match.h"


/*
 * Non-Public methods.
 */
@interface Match(Private)
@end


/*
 * Holds the informations about a match of a particular
 * search.
 */
@implementation Match

/*
 * Desginated initializer.
 */
- (id) initWithPosition: (DocumentPosition*)_position
                context: (NSString*)_context
             searchText: (NSString*)_searchText
{
   if ((self = [super init]))
   {
      position   = nil;
      context    = nil;
      searchText = nil;
      [self setPosition: _position];
      [self setContext: _context];
      [self setSearchText: _searchText];
   }
   return self;
}


/*
 * Initialize with empty properties.
 */
- (id) init
{
   return [self initWithPosition: nil context: nil searchText: nil];
}


- (void) dealloc
{
   [self setPosition: nil];
   [self setContext: nil];
   [self setSearchText: nil];

   [super dealloc];
}


/*
 * Create an (autoreleased) match with the specified
 * properties.
 */
+ (Match*) matchAt: (DocumentPosition*)_position
           context: (NSString*)_context
        searchText: (NSString*)_searchText
{
   Match* match;

   match = [[Match alloc] initWithPosition: _position
                          context: _context
                          searchText: _searchText];

   return [match autorelease];
}


/*
 * Returns the position in the document where this match
 * occured.
 */
- (DocumentPosition*) position
{
   return position;
}


/*
 * Set the position in the document where this match
 * occured.
 */
- (void) setPosition: (DocumentPosition*)_position
{
   [position release];
   position = _position;
   [position retain];
}


/*
 * Return the context of this match. This is some text
 * around the position where this match occured.
 */
- (NSString*) context
{
   return context;
}


/*
 * Set the context of this match. See context message for
 * more information.
 */
- (void) setContext: (NSString*)_context;
{
   [context release];
   context = [_context copy];
}


/*
 * Get the text that has been searched for when this
 * match occcured.
 */
- (NSString*) searchText
{
   return searchText;
}


/*
 * Set the text that has been searched for when this
 * match occcured.
 */
- (void) setSearchText: (NSString*)_searchText
{
   [searchText release];
   searchText = [_searchText copy];
}

@end
