/* vifm Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<stdlib.h> 
#include<string.h>
#include<sys/types.h>
#include<sys/wait.h> /* waitpid */
#include<unistd.h>

#include"background.h" 
#include"utils.h"

struct Jobs_List *jobs = NULL;

static void 
add_background_job(pid_t pid, char *cmd) 
{
	Jobs_List *new;

	new = (Jobs_List *)malloc(sizeof(Jobs_List)); 
	new->pid = pid;
	new->cmd = strdup(cmd);
	new->next = jobs;
//	new->fd = fd; 
	jobs = new;
}

void
remove_background_job(pid_t pid)
{
	Jobs_List *p = jobs;
	Jobs_List *prev = 0;

	while (p)
	{
		if (p->pid == pid)
		{
			if (prev)
				prev->next = p->next;
			else jobs = p->next;
			
			my_free(p->cmd);
			my_free(p);
			break;
		}
		prev = p;
		p = p->next;
	}
}

int 
start_background_job(char *cmd)
{ 
	pid_t pid;
	char *args[4];


	if ((pid = fork()) == -1)
		return -1;
	if (pid == 0)
	{
		args[0] = "sh";
		args[1] = "-c";
		args[2] = cmd;
		args[3] = NULL;

		execvp(args[0], args);
		exit(127);
	}
	else
		add_background_job(pid, cmd);

	return 0;
}
