/* Start up the world of vips.
 *
 * 7/1/04 JC
 *	- 1st version
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

int
im_init_world( const char *argv0 )
{
	static gboolean done = FALSE;
	const char *prefix;
	char name[256];

	if( done )
		return( 0 );

#ifdef G_THREADS_ENABLED
	if( !g_thread_supported() ) 
		g_thread_init( NULL );
#endif /*G_THREADS_ENABLED*/

	/* Try to discover our prefix. 
	 */
	if( !(prefix = im_guess_prefix( argv0, "VIPSHOME" )) ) 
		return( -1 );

	/* Get i18n .mo files from $VIPSHOME/share/locale/.
	 */
	im_snprintf( name, 256,
		"%s" IM_DIR_SEP_STR "share" IM_DIR_SEP_STR "locale",
		prefix );
	bindtextdomain( GETTEXT_PACKAGE, name );
	bind_textdomain_codeset( GETTEXT_PACKAGE, "UTF-8" );

	done = TRUE;

	return( 0 );
}

const char *
im__gettext( const char *msgid )
{
	/* Pass in a nonsense name for argv0 ... this init path is only here
	 * for old programs which are missing an im_init_world() call. We need
	 * i18n set up before we can translate.
	 */
	if( im_init_world( "giant_banana" ) )
		im_error_clear();

	return( dgettext( GETTEXT_PACKAGE, msgid ) );
}

const char *
im__ngettext( const char *msgid, const char *plural, unsigned long int n )
{
	if( im_init_world( "giant_banana" ) )
		im_error_clear();

	return( dngettext( GETTEXT_PACKAGE, msgid, plural, n ) );
}

