# Copyright 2003-2004 Ruven Pillay
# Distributed under the terms of the GNU General Public License v2
# $Header: $
 
DESCRIPTION="VIPS Image Processing Library"
SRC_URI="http://www.vips.ecs.soton.ac.uk/vips-7.9/${P}.tar.gz"
HOMEPAGE="http://vips.sourceforge.net"
 
SLOT="1"
LICENSE="GPL-2"
 
KEYWORDS="x86 ~ppc ~sparc ~alpha ~arm ~hppa"

IUSE="tiff png zlib fftw lcms jpeg imagemagick threads"
 
RDEPEND="virtual/glibc
	>=dev-libs/glib-2*
	lcms? ( >=media-libs/lcms-1.0.8 )
        imagemagick? ( >=media-gfx/imagemagick-5.0.0 )
        fftw? ( =dev-libs/fftw-2* )
        png? ( media-libs/libpng )
        zlib? ( sys-libs/zlib )
        jpeg? ( media-libs/jpeg )
        tiff? ( media-libs/tiff )"

DEPEND="${RDEPEND}"


src_compile() {
        local myconf
 
        use tiff    || myconf="--without-tiff"
	use jpeg    || myconf="${myconf} --without-jpeg"
        use fftw    || myconf="${myconf} --without-fftw"
        use zlib    || myconf="${myconf} --without-zip"
        use lcms    || myconf="${myconf} --without-lcms"
        use png     || myconf="${myconf} --without-png"
        use threads || myconf="${myconf} --without-threads"
 
        econf ${myconf} || die
 
        emake || die
}
 
 
src_install() {
        einstall || die
}

