dnl ACX_PTHREAD[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ---------------------------------------------------
dnl
dnl Find pthread libraries and headers
dnl
dnl Put compile stuff in PTHREAD_CFLAGS
dnl Put link stuff in PTHREAD_LIBS
dnl Set PTHREAD_CC to special C compiler
dnl
dnl Default ACTION-IF-FOUND defines HAVE_PTHREAD
AC_DEFUN([ACX_PTHREAD], [
AC_REQUIRE([AC_CANONICAL_HOST])
acx_pthread_ok=no

# First, check if the POSIX threads header, pthread.h, is available.
# If it isn't, don't bother looking for the threads libraries.
AC_CHECK_HEADER(pthread.h, , acx_pthread_ok=noheader)

# We must check for the threads library under a number of different
# names; the ordering is very important because some systems
# (e.g. DEC) have both -lpthread and -lpthreads, where one of the
# libraries is broken (non-POSIX).

# First of all, check if the user has set any of the PTHREAD_LIBS,
# etcetera environment variables, and if threads linking works using
# them:
if test x"$PTHREAD_LIBS$PTHREAD_CFLAGS" != x; then
        save_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        AC_MSG_CHECKING([for pthread_join in LIBS=$PTHREAD_LIBS with CFLAGS=$PTHREAD_CFLAGS])
        AC_TRY_LINK_FUNC(pthread_join, acx_pthread_ok=yes)
        AC_MSG_RESULT($acx_pthread_ok)
        if test x"$acx_pthread_ok" = xno; then
                PTHREAD_LIBS=""
                PTHREAD_CFLAGS=""
        fi
        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"
fi

# Create a list of thread flags to try.  Items starting with a "-" are
# C compiler flags, and other items are library names, except for "none"
# which indicates that we try without any flags at all.

acx_pthread_flags="pthreads none -Kthread -kthread lthread -pthread -pthreads
-mthreads pthread --thread-safe -mt"

# The ordering *is* (sometimes) important.  Some notes on the
# individual items follow:

# pthreads: AIX (must check this before -lpthread)
# none: in case threads are in libc; should be tried before -Kthread and
#       other compiler flags to prevent continual compiler warnings
# -Kthread: Sequent (threads in libc, but -Kthread needed for pthread.h)
# -kthread: FreeBSD kernel threads (preferred to -pthread since SMP-able)
# lthread: LinuxThreads port on FreeBSD (also preferred to -pthread)
# -pthread: Linux/gcc (kernel threads), BSD/gcc (userland threads)
# -pthreads: Solaris/gcc
# -mthreads: Mingw32/gcc, Lynx/gcc
# -mt: Sun Workshop C (may only link SunOS threads [-lthread], but it
#      doesn't hurt to check since this sometimes defines pthreads too;
#      also defines -D_REENTRANT)
# pthread: Linux, etcetera
# --thread-safe: KAI C++

case "${host_cpu}-${host_os}" in
        *solaris*)

        # On Solaris (at least, for some versions), libc contains stubbed
        # (non-functional) versions of the pthreads routines, so link-based
        # tests will erroneously succeed.  (We need to link with -pthread or
        # -lpthread.)  (The stubs are missing pthread_cleanup_push, or rather
        # a function called by this macro, so we could check for that, but
        # who knows whether they'll stub that too in a future libc.)  So,
        # we'll just look for -pthreads and -lpthread first:

        acx_pthread_flags="-pthread -pthreads pthread -mt $acx_pthread_flags"
        ;;
esac

if test x"$acx_pthread_ok" = xno; then
for flag in $acx_pthread_flags; do

        case $flag in
                none)
                AC_MSG_CHECKING([whether pthreads work without any flags])
                ;;

                -*)
                AC_MSG_CHECKING([whether pthreads work with $flag])
                PTHREAD_CFLAGS="$flag"
                ;;

                *)
                AC_MSG_CHECKING([for the pthreads library -l$flag])
                PTHREAD_LIBS="-l$flag"
                ;;
        esac

        save_LIBS="$LIBS"
        save_CFLAGS="$CFLAGS"
        LIBS="$PTHREAD_LIBS $LIBS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"

        # Check for various functions.  We must include pthread.h,
        # since some functions may be macros.  (On the Sequent, we
        # need a special flag -Kthread to make this header compile.)
        # We check for pthread_join because it is in -lpthread on IRIX
        # while pthread_create is in libc.  We check for pthread_attr_init
        # due to DEC craziness with -lpthreads.  We check for
        # pthread_cleanup_push because it is one of the few pthread
        # functions on Solaris that doesn't have a non-functional libc stub.
        # We try pthread_create on general principles.
        AC_TRY_LINK([#include <pthread.h>],
                    [pthread_t th; pthread_join(th, 0);
                     pthread_attr_init(0); pthread_cleanup_push(0, 0);
                     pthread_create(0,0,0,0); pthread_cleanup_pop(0); ],
                    [acx_pthread_ok=yes])

        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"

        AC_MSG_RESULT($acx_pthread_ok)
        if test "x$acx_pthread_ok" = xyes; then
                break;
        fi

        PTHREAD_LIBS=""
        PTHREAD_CFLAGS=""
done
fi

# Various other checks:
if test "x$acx_pthread_ok" = xyes; then
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        save_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"

        # Detect AIX lossage: threads are created detached by default
        # and the JOINABLE attribute has a nonstandard name (UNDETACHED).
        AC_MSG_CHECKING([for joinable pthread attribute])
        AC_TRY_LINK([#include <pthread.h>],
                    [int attr=PTHREAD_CREATE_JOINABLE;],
                    ok=PTHREAD_CREATE_JOINABLE, ok=unknown)
        if test x"$ok" = xunknown; then
                AC_TRY_LINK([#include <pthread.h>],
                            [int attr=PTHREAD_CREATE_UNDETACHED;],
                            ok=PTHREAD_CREATE_UNDETACHED, ok=unknown)
        fi
        if test x"$ok" != xPTHREAD_CREATE_JOINABLE; then
                AC_DEFINE(PTHREAD_CREATE_JOINABLE, $ok,
                          [Define to the necessary symbol if this constant
                           uses a non-standard name on your system.])
        fi
        AC_MSG_RESULT(${ok})
        if test x"$ok" = xunknown; then
                AC_MSG_WARN([we do not know how to create joinable pthreads])
        fi

        AC_MSG_CHECKING([if more special flags are required for pthreads])
        flag=no
        case "${host_cpu}-${host_os}" in
                *-aix* | *-freebsd*)     flag="-D_THREAD_SAFE";;
                *solaris* | alpha*-osf*) flag="-D_REENTRANT";;
        esac
        AC_MSG_RESULT(${flag})
        if test "x$flag" != xno; then
                PTHREAD_CFLAGS="$flag $PTHREAD_CFLAGS"
        fi

        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"

        # More AIX lossage: must compile with cc_r
        AC_CHECK_PROG(PTHREAD_CC, cc_r, cc_r, ${CC})
else
        PTHREAD_CC="$CC"
fi

AC_SUBST(PTHREAD_LIBS)
AC_SUBST(PTHREAD_CFLAGS)
AC_SUBST(PTHREAD_CC)

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$acx_pthread_ok" = xyes; then
        ifelse([$1],,AC_DEFINE(HAVE_PTHREAD,1,[Define if you have POSIX threads libraries and header files.]),[$1])
        :
else
        acx_pthread_ok=no
        $2
fi

])dnl ACX_PTHREAD

dnl From FIND_MOTIF and ACX_PTHREAD, without much understanding
dnl
dnl FIND_ZIP[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ------------------------------------------------
dnl
dnl Find ZIP libraries and headers
dnl
dnl Put includes stuff in ZIP_INCLUDES
dnl Put link stuff in ZIP_LIBS
dnl
dnl Default ACTION-IF-FOUND defines HAVE_ZIP
dnl
AC_DEFUN([FIND_ZIP], [
AC_REQUIRE([AC_PATH_XTRA])

ZIP_INCLUDES=""
ZIP_LIBS=""

AC_ARG_WITH(zip, 
[  --without-zip			do not use libz])
# Treat --without-zip like --without-zip-includes --without-zip-libraries.
if test "$with_zip" = "no"; then
	ZIP_INCLUDES=no
	ZIP_LIBS=no
fi

AC_ARG_WITH(zip-includes,
[  --with-zip-includes=DIR	ZIP include files are in DIR],
ZIP_INCLUDES="-I$withval")
AC_ARG_WITH(zip-libraries,
[  --with-zip-libraries=DIR	ZIP libraries are in DIR],
ZIP_LIBS="-L$withval -lz")

AC_MSG_CHECKING(for ZIP)

# Look for zlib.h 
if test "$ZIP_INCLUDES" = ""; then
	zip_save_LIBS="$LIBS"

	LIBS="-lz $LIBS"

	# Check the standard search path
	AC_TRY_COMPILE([#include <zlib.h>],[int a;],[
		ZIP_INCLUDES=""
	], [
		# zlib.h is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/include /usr/*/include \
			/usr/local/*/include \
			"${prefix}"/include/* \
			/usr/include/* /usr/local/include/* /*/include; do
			if test -f "$dir/zlib.h"; then
				ZIP_INCLUDES="-I$dir"
				break
			fi
		done

		if test "$ZIP_INCLUDES" = ""; then
			ZIP_INCLUDES=no
		fi
	])

	LIBS="$zip_save_LIBS"
fi

# Now for the libraries
if test "$ZIP_LIBS" = ""; then
	zip_save_LIBS="$LIBS"
	zip_save_INCLUDES="$INCLUDES"

	LIBS="-lz $LIBS"
	INCLUDES="$ZIP_INCLUDES $INCLUDES"

	# Try the standard search path first
	AC_TRY_LINK([#include <zlib.h>],[zlibVersion()], [
		ZIP_LIBS="-lz"
	], [
		# libz is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
			"${prefix}"/lib/* /usr/lib/* \
			/usr/local/lib/* /*/lib; do
			if test -d "$dir" && test "`ls $dir/libz.* 2> /dev/null`" != ""; then
				ZIP_LIBS="-L$dir -lz"
				break
			fi
		done

		if test "$ZIP_LIBS" = ""; then
			ZIP_LIBS=no
		fi
	])

	LIBS="$zip_save_LIBS"
	INCLUDES="$zip_save_INCLUDES"
fi

AC_SUBST(ZIP_LIBS)
AC_SUBST(ZIP_INCLUDES)

# Print a helpful message
zip_libraries_result="$ZIP_LIBS"
zip_includes_result="$ZIP_INCLUDES"

if test x"$zip_libraries_result" = x""; then
	zip_libraries_result="in default path"
fi
if test x"$zip_includes_result" = x""; then
	zip_includes_result="in default path"
fi

if test "$zip_libraries_result" = "no"; then
	zip_libraries_result="(none)"
fi
if test "$zip_includes_result" = "no"; then
	zip_includes_result="(none)"
fi

AC_MSG_RESULT(
  [libraries $zip_libraries_result, headers $zip_includes_result])

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test "$ZIP_INCLUDES" != "no" && test "$ZIP_LIBS" != "no"; then
        ifelse([$1],,AC_DEFINE(HAVE_ZIP,1,[Define if you have libz libraries and header files.]),[$1])
        :
else
	ZIP_LIBS=""
	ZIP_INCLUDES=""
        $2
fi

])dnl

dnl From FIND_MOTIF and ACX_PTHREAD, without much understanding
dnl
dnl FIND_TIFF[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ------------------------------------------------
dnl
dnl Find TIFF libraries and headers
dnl
dnl Put compile stuff in TIFF_INCLUDES
dnl Put link stuff in TIFF_LIBS
dnl
dnl Default ACTION-IF-FOUND defines HAVE_TIFF
dnl
AC_DEFUN([FIND_TIFF], [
AC_REQUIRE([AC_PATH_XTRA])

TIFF_INCLUDES=""
TIFF_LIBS=""

AC_ARG_WITH(tiff, 
[  --without-tiff		do not use libtiff])
# Treat --without-tiff like --without-tiff-includes --without-tiff-libraries.
if test "$with_tiff" = "no"; then
	TIFF_INCLUDES=no
	TIFF_LIBS=no
fi

AC_ARG_WITH(tiff-includes,
[  --with-tiff-includes=DIR	TIFF include files are in DIR],
TIFF_INCLUDES="-I$withval")
AC_ARG_WITH(tiff-libraries,
[  --with-tiff-libraries=DIR	TIFF libraries are in DIR],
TIFF_LIBS="-L$withval -ltiff")

AC_MSG_CHECKING(for TIFF)

# Look for tiff.h 
if test "$TIFF_INCLUDES" = ""; then
	# Check the standard search path
	AC_TRY_COMPILE([#include <tiff.h>],[int a;],[
		TIFF_INCLUDES=""
	], [
		# tiff.h is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/include /usr/*/include \
			/usr/local/*/include "${prefix}"/include/* \
			/usr/include/* /usr/local/include/* /*/include; do
			if test -f "$dir/tiff.h"; then
				TIFF_INCLUDES="-I$dir"
				break
			fi
		done

		if test "$TIFF_INCLUDES" = ""; then
			TIFF_INCLUDES=no
		fi
	])
fi

# Now for the libraries
if test "$TIFF_LIBS" = ""; then
	tiff_save_LIBS="$LIBS"
	tiff_save_INCLUDES="$INCLUDES"

	LIBS="-ltiff -lm $LIBS"
	INCLUDES="$TIFF_INCLUDES $INCLUDES"

	# Try the standard search path first
	AC_TRY_LINK([#include <tiff.h>],[TIFFGetVersion();], [
		TIFF_LIBS="-ltiff"
	], [
		# libtiff is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
			"${prefix}"/lib/* /usr/lib/* \
			/usr/local/lib/* /*/lib; do
			if test -d "$dir" && test "`ls $dir/libtiff.* 2> /dev/null`" != ""; then
				TIFF_LIBS="-L$dir -ltiff"
				break
			fi
		done

		if test "$TIFF_LIBS" = ""; then
			TIFF_LIBS=no
		fi
	])

	LIBS="$tiff_save_LIBS"
	INCLUDES="$tiff_save_INCLUDES"
fi

AC_SUBST(TIFF_LIBS)
AC_SUBST(TIFF_INCLUDES)

# Print a helpful message
tiff_libraries_result="$TIFF_LIBS"
tiff_includes_result="$TIFF_INCLUDES"

if test x"$tiff_libraries_result" = x""; then
	tiff_libraries_result="in default path"
fi
if test x"$tiff_includes_result" = x""; then
	tiff_includes_result="in default path"
fi

if test "$tiff_libraries_result" = "no"; then
	tiff_libraries_result="(none)"
fi
if test "$tiff_includes_result" = "no"; then
	tiff_includes_result="(none)"
fi

AC_MSG_RESULT(
  [libraries $tiff_libraries_result, headers $tiff_includes_result])

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test "$TIFF_INCLUDES" != "no" && test "$TIFF_LIBS" != "no"; then
        ifelse([$1],,AC_DEFINE(HAVE_TIFF,1,[Define if you have tiff libraries and header files.]),[$1])
        :
else
	TIFF_INCLUDES=""
	TIFF_LIBS=""
        $2
fi

])dnl

dnl From FIND_MOTIF and ACX_PTHREAD, without much understanding
dnl
dnl FIND_JPEG[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ------------------------------------------------
dnl
dnl Find JPEG libraries and headers
dnl
dnl Put compile stuff in JPEG_INCLUDES
dnl Put link stuff in JPEG_LIBS
dnl
dnl Default ACTION-IF-FOUND defines HAVE_JPEG
dnl
AC_DEFUN([FIND_JPEG], [
AC_REQUIRE([AC_PATH_XTRA])

JPEG_INCLUDES=""
JPEG_LIBS=""

AC_ARG_WITH(jpeg, 
[  --without-jpeg		do not use libjpeg])
# Treat --without-jpeg like --without-jpeg-includes --without-jpeg-libraries.
if test "$with_jpeg" = "no"; then
	JPEG_INCLUDES=no
	JPEG_LIBS=no
fi

AC_ARG_WITH(jpeg-includes,
[  --with-jpeg-includes=DIR	JPEG include files are in DIR],
JPEG_INCLUDES="-I$withval")
AC_ARG_WITH(jpeg-libraries,
[  --with-jpeg-libraries=DIR	JPEG libraries are in DIR],
JPEG_LIBS="-L$withval -ljpeg")

AC_MSG_CHECKING(for JPEG)

# Look for jpeg.h 
if test "$JPEG_INCLUDES" = ""; then
	jpeg_save_LIBS="$LIBS"

	LIBS="-ljpeg $LIBS"

	# Check the standard search path
	AC_TRY_COMPILE([
		#include <stdio.h>
		#include <jpeglib.h>],[int a],[
		JPEG_INCLUDES=""
	], [
		# jpeg.h is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/include \
			/usr/local/include \
			/usr/*/include \
			/usr/local/*/include /usr/*/include \
			"${prefix}"/include/* \
			/usr/include/* /usr/local/include/* /*/include; do
			if test -f "$dir/jpeglib.h"; then
				JPEG_INCLUDES="-I$dir"
				break
			fi
		done

		if test "$JPEG_INCLUDES" = ""; then
			JPEG_INCLUDES=no
		fi
	])

	LIBS="$jpeg_save_LIBS"
fi

# Now for the libraries
if test "$JPEG_LIBS" = ""; then
	jpeg_save_LIBS="$LIBS"
	jpeg_save_INCLUDES="$INCLUDES"

	LIBS="-ljpeg $LIBS"
	INCLUDES="$JPEG_INCLUDES $INCLUDES"

	# Try the standard search path first
	AC_TRY_LINK([
		#include <stdio.h>
		#include <jpeglib.h>],[jpeg_abort((void*)0)], [
		JPEG_LIBS="-ljpeg"
	], [
		# libjpeg is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/lib \
			/usr/local/lib \
			/usr/*/lib \
			"${prefix}"/lib/* /usr/lib/* \
			/usr/local/lib/* /*/lib; do
			if test -d "$dir" && test "`ls $dir/libjpeg.* 2> /dev/null`" != ""; then
				JPEG_LIBS="-L$dir -ljpeg"
				break
			fi
		done

		if test "$JPEG_LIBS" = ""; then
			JPEG_LIBS=no
		fi
	])

	LIBS="$jpeg_save_LIBS"
	INCLUDES="$jpeg_save_INCLUDES"
fi

AC_SUBST(JPEG_LIBS)
AC_SUBST(JPEG_INCLUDES)

# Print a helpful message
jpeg_libraries_result="$JPEG_LIBS"
jpeg_includes_result="$JPEG_INCLUDES"

if test x"$jpeg_libraries_result" = x""; then
	jpeg_libraries_result="in default path"
fi
if test x"$jpeg_includes_result" = x""; then
	jpeg_includes_result="in default path"
fi

if test "$jpeg_libraries_result" = "no"; then
	jpeg_libraries_result="(none)"
fi
if test "$jpeg_includes_result" = "no"; then
	jpeg_includes_result="(none)"
fi

AC_MSG_RESULT(
  [libraries $jpeg_libraries_result, headers $jpeg_includes_result])

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test "$JPEG_INCLUDES" != "no" && test "$JPEG_LIBS" != "no"; then
        ifelse([$1],,AC_DEFINE(HAVE_JPEG,1,[Define if you have jpeg libraries and header files.]),[$1])
        :
else
	JPEG_INCLUDES=""
	JPEG_LIBS=""
        $2
fi

])dnl

dnl From FIND_MOTIF and ACX_PTHREAD, without much understanding
dnl
dnl FIND_XIL[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ------------------------------------------------
dnl
dnl Find XIL libraries and headers
dnl
dnl Put compile stuff in XIL_INCLUDES
dnl Put link stuff in XIL_LIBS
dnl
dnl Default ACTION-IF-FOUND defines HAVE_XIL
dnl
AC_DEFUN([FIND_XIL], [
AC_REQUIRE([AC_PATH_XTRA])

XIL_INCLUDES=""
XIL_LIBS=""

AC_ARG_WITH(xil, 
[  --without-xil			do not use libxil])
# Treat --without-xil like --without-xil-includes --without-xil-libraries.
if test "$with_xil" = "no"; then
	XIL_INCLUDES=no
	XIL_LIBS=no
fi

AC_ARG_WITH(xil-includes,
[  --with-xil-includes=DIR	XIL include files are in DIR],
XIL_INCLUDES="-I$withval")
AC_ARG_WITH(xil-libraries,
[  --with-xil-libraries=DIR	XIL libraries are in DIR],
XIL_LIBS="-L$withval -lxil")

AC_MSG_CHECKING(for XIL)

# Look for xil.h 
if test "$XIL_INCLUDES" = ""; then
	xil_save_LIBS="$LIBS"

	LIBS="-lxil $LIBS"

	# Check the standard search path
	AC_TRY_COMPILE([#include <xil/xil.h>],[int a;],[
		XIL_INCLUDES=""
	], [
		# xil.h is not in the standard search path.

		# Just two locations (I hope)
		for dir in \
			/usr/openwin/include \
			/opt/SUNWits/Graphics-sw/xil/include; do
			if test -f "$dir/xil/xil.h"; then
				XIL_INCLUDES="-I$dir"
				break
			fi
		done

		if test "$XIL_INCLUDES" = ""; then
			XIL_INCLUDES=no
		fi
	])

	LIBS="$xil_save_LIBS"
fi

# Now for the libraries
if test "$XIL_LIBS" = ""; then
	xil_save_LIBS="$LIBS"
	xil_save_INCLUDES="$INCLUDES"

	LIBS="-lxil $LIBS"
	INCLUDES="$XIL_INCLUDES $INCLUDES"

	# Try the standard search path first
	AC_TRY_LINK([#include <xil/xil.h>],[xil_open();], [
		XIL_LIBS="-lxil"
	], [
		# libxil is not in the standard search path.

		# Just two locations
		for dir in \
			/usr/openwin/lib \
			/opt/SUNWits/Graphics-sw/xil/lib; do
			if test -d "$dir" && test "`ls $dir/libxil.* 2> /dev/null`" != ""; then
				XIL_LIBS="-L$dir -lxil"
				break
			fi
		done

		if test "$XIL_LIBS" = ""; then
			XIL_LIBS=no
		fi
	])

	LIBS="$xil_save_LIBS"
	INCLUDES="$xil_save_INCLUDES"
fi

AC_SUBST(XIL_LIBS)
AC_SUBST(XIL_INCLUDES)

# Print a helpful message
xil_libraries_result="$XIL_LIBS"
xil_includes_result="$XIL_INCLUDES"

if test x"$xil_libraries_result" = x""; then
	xil_libraries_result="in default path"
fi
if test x"$xil_includes_result" = x""; then
	xil_includes_result="in default path"
fi

if test "$xil_libraries_result" = "no"; then
	xil_libraries_result="(none)"
fi
if test "$xil_includes_result" = "no"; then
	xil_includes_result="(none)"
fi

AC_MSG_RESULT(
  [libraries $xil_libraries_result, headers $xil_includes_result])

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test "$XIL_INCLUDES" != "no" && test "$XIL_LIBS" != "no"; then
        ifelse([$1],,AC_DEFINE(HAVE_XIL,1,[Define if you have xil libraries and header files.]),[$1])
        :
else
	XIL_INCLUDES=""
	XIL_LIBS=""
        $2
fi

])dnl

dnl From FIND_MOTIF and ACX_PTHREAD, without much understanding
dnl
dnl FIND_FFTW[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ------------------------------------------------
dnl
dnl Find FFTW libraries and headers
dnl
dnl Put compile stuff in FFTW_INCLUDES
dnl Put link stuff in FFTW_LIBS
dnl
dnl Default ACTION-IF-FOUND defines HAVE_FFTW
dnl
AC_DEFUN([FIND_FFTW], [
AC_REQUIRE([AC_PATH_XTRA])

FFTW_INCLUDES=""
FFTW_LIBS=""

AC_ARG_WITH(fftw, 
[  --without-fftw		do not use libfftw])
# Treat --without-fftw like --without-fftw-includes --without-fftw-libraries.
if test "$with_fftw" = "no"; then
	FFTW_INCLUDES=no
	FFTW_LIBS=no
fi

AC_ARG_WITH(fftw-includes,
[  --with-fftw-includes=DIR	FFTW include files are in DIR],
FFTW_INCLUDES="-I$withval")
AC_ARG_WITH(fftw-libraries,
[  --with-fftw-libraries=DIR	FFTW libraries are in DIR],
# we lose the "d" library prefix here :-( but I think that might only be suse
# anyway, so don't worry too much ... fix this properly when we move to the
# new fftw version
FFTW_LIBS="-L$withval -lrfftw -lfftw")

AC_MSG_CHECKING(for FFTW)

# Look for fftw.h 
if test x"$FFTW_INCLUDES" = x""; then
	# Check the standard search path
	AC_TRY_COMPILE([
		#include <fftw.h>],[int a],[
		FFTW_INCLUDES=""
	], [
		# fftw.h is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/include \
			/usr/local/include \
			/usr/*/include \
			/usr/local/*/include /usr/*/include \
			"${prefix}"/include/* \
			/usr/include/* /usr/local/include/* /*/include; do
			if test -f "$dir/fftw.h"; then
				FFTW_INCLUDES="-I$dir"
				break
			fi
		done

		if test "$FFTW_INCLUDES" = ""; then
			FFTW_INCLUDES=no
		fi
	])
fi

# Now for the libraries
if test x"$FFTW_LIBS" = x""; then
	fftw_save_LIBS="$LIBS"
	fftw_save_INCLUDES="$INCLUDES"

	INCLUDES="$FFTW_INCLUDES $INCLUDES"

	# could be called fftw or dfftw ... depends on the distribution
	# we prefer the "d" version (means we're sure it's been built for
	# double precision)

	# Try the standard search path first
	LIBS="-ldrfftw -ldfftw -lm $fftw_save_LIBS"
	AC_TRY_LINK([
		#include <math.h>
		#include <fftw.h>],[fftw_die("")], [
		FFTW_LIBS="-ldrfftw -ldfftw -lm"
	], [
		# not in the standard search path.
		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/lib \
			/usr/local/lib \
			/usr/*/lib \
			"${prefix}"/lib/* /usr/lib/* \
			/usr/local/lib/* /*/lib; do
			if test -d "$dir" && test "`ls $dir/libdfftw.* 2> /dev/null`" != ""; then
				FFTW_LIBS="-L$dir -ldrfftw -ldfftw -lm"
				break
			fi
		done

		if test x"$FFTW_LIBS" = x""; then
			FFTW_LIBS=no
		fi
	])

	if test "$FFTW_LIBS" = "no"; then
		# Try the standard search path first
		LIBS="-lrfftw -lfftw -lm $fftw_save_LIBS"
		AC_TRY_LINK([
			#include <math.h>
			#include <fftw.h>],[fftw_die("")], [
			FFTW_LIBS="-lrfftw -lfftw -lm"
		], [
			# not in the standard search path.
			# A whole bunch of guesses
			for dir in \
				"${prefix}"/*/lib \
				/usr/local/lib \
				/usr/*/lib \
				"${prefix}"/lib/* /usr/lib/* \
				/usr/local/lib/* /*/lib; do
				if test -d "$dir" && test "`ls $dir/libfftw.* 2> /dev/null`" != ""; then
					FFTW_LIBS="-L$dir -lrfftw -lfftw -lm"
					break
				fi
			done

			if test x"$FFTW_LIBS" = x""; then
				FFTW_LIBS=no
			fi
		])
	fi

	LIBS="$fftw_save_LIBS"
	INCLUDES="$fftw_save_INCLUDES"
fi

# Print a helpful message
fftw_libraries_result="$FFTW_LIBS"
fftw_includes_result="$FFTW_INCLUDES"

if test x"$fftw_libraries_result" = x""; then
	fftw_libraries_result="in default path"
fi
if test x"$fftw_includes_result" = x""; then
	fftw_includes_result="in default path"
fi

if test "$fftw_libraries_result" = "no"; then
	fftw_libraries_result="(none)"
fi
if test "$fftw_includes_result" = "no"; then
	fftw_includes_result="(none)"
fi

AC_SUBST(FFTW_LIBS)
AC_SUBST(FFTW_INCLUDES)

AC_MSG_RESULT(
  [libraries $fftw_libraries_result, headers $fftw_includes_result])

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test "$FFTW_INCLUDES" != "no" && test "$FFTW_LIBS" != "no"; then
        ifelse([$1],,AC_DEFINE(HAVE_FFTW,1,[Define if you have fftw libraries and header files.]),[$1])
        :
else
	FFTW_INCLUDES=""
	FFTW_LIBS=""
        $2
fi

])dnl


dnl From FIND_MOTIF and ACX_PTHREAD, without much understanding
dnl
dnl FIND_LCMS[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ------------------------------------------------
dnl
dnl Find littlecms libraries and headers
dnl
dnl Put compile stuff in LCMS_INCLUDES
dnl Put link stuff in LCMS_LIBS
dnl
dnl Default ACTION-IF-FOUND defines HAVE_LCMS
dnl
AC_DEFUN([FIND_LCMS], [
AC_REQUIRE([AC_PATH_XTRA])

LCMS_INCLUDES=""
LCMS_LIBS=""

AC_ARG_WITH(lcms, 
[  --without-lcms		do not use liblcms])
# Treat --without-lcms like --without-lcms-includes --without-lcms-libraries.
if test "$with_lcms" = "no"; then
	LCMS_INCLUDES=no
	LCMS_LIBS=no
fi

AC_ARG_WITH(lcms-includes,
[  --with-lcms-includes=DIR	LCMS include files are in DIR],
LCMS_INCLUDES="-I$withval")
AC_ARG_WITH(lcms-libraries,
[  --with-lcms-libraries=DIR	LCMS libraries are in DIR],
LCMS_LIBS="-L$withval -llcms")

AC_MSG_CHECKING(for LCMS version >= 1.0.8)

# Look for lcms.h 
if test "$LCMS_INCLUDES" = ""; then
	# Check the standard search path
	AC_TRY_COMPILE([
		#include <lcms.h>],[int a],[
		LCMS_INCLUDES=""
	], [
		# lcms.h is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/include \
			/usr/local/include \
			/usr/*/include \
			/usr/local/*/include /usr/*/include \
			"${prefix}"/include/* \
			/usr/include/* /usr/local/include/* /*/include; do
			if test -f "$dir/lcms.h"; then
				LCMS_INCLUDES="-I$dir"
				break
			fi
		done

		if test "$LCMS_INCLUDES" = ""; then
			LCMS_INCLUDES=no
		fi
	])
fi

# Now for the libraries
if test "$LCMS_LIBS" = ""; then
	lcms_save_LIBS="$LIBS"
	lcms_save_INCLUDES="$INCLUDES"

	LIBS="-llcms -lm $LIBS"
	INCLUDES="$LCMS_INCLUDES $INCLUDES"

	# Try the standard search path first
	AC_TRY_LINK([
		#include <lcms.h>],[(void)cmsAllocLUT()], [
		LCMS_LIBS="-llcms -lm"
	], [
		# liblcms is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/lib \
			/usr/local/lib \
			/usr/*/lib \
			"${prefix}"/lib/* /usr/lib/* \
			/usr/local/lib/* /*/lib; do
			if test -d "$dir" && test "`ls $dir/liblcms.* 2> /dev/null`" != ""; then
				LCMS_LIBS="-L$dir -llcms -lm"
				break
			fi
		done

		if test "$LCMS_LIBS" = ""; then
			LCMS_LIBS=no
		fi
	])

        if test x"$LCMS_LIBS" != x"no"; then
                # Make sure we can link to cmsCreateLabProfile ... ver 1.0.8
                # and later
                lcms_save_CFLAGS="$CFLAGS"
                CFLAGS="$CFLAGS $LCMS_INCLUDES $lcms_save_INCLUDES"
                LIBS="$LCMS_LIBS $lcms_save_LIBS"

                AC_TRY_LINK([
                        #include <lcms.h>
                ], [
                        cmsCIExyY poop;
                        (void)cmsCreateLabProfile(&poop)
                ], [
                        # success! nop
                        echo -n
                ], [
                        LCMS_INCLUDES=no
                        LCMS_LIBS=no
                ])

                CFLAGS="$lcms_save_CFLAGS"
        fi

	LIBS="$lcms_save_LIBS"
	INCLUDES="$lcms_save_INCLUDES"
fi

AC_SUBST(LCMS_LIBS)
AC_SUBST(LCMS_INCLUDES)

# Print a helpful message
lcms_libraries_result="$LCMS_LIBS"
lcms_includes_result="$LCMS_INCLUDES"

if test x"$lcms_libraries_result" = x""; then
	lcms_libraries_result="in default path"
fi
if test x"$lcms_includes_result" = x""; then
	lcms_includes_result="in default path"
fi

if test "$lcms_libraries_result" = "no"; then
	lcms_libraries_result="(none)"
fi
if test "$lcms_includes_result" = "no"; then
	lcms_includes_result="(none)"
fi

AC_MSG_RESULT(
  [libraries $lcms_libraries_result, headers $lcms_includes_result])

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test "$LCMS_INCLUDES" != "no" && test "$LCMS_LIBS" != "no"; then
        ifelse([$1],,AC_DEFINE(HAVE_LCMS,1,[Define if you have lcms libraries and header files.]),[$1])
        :
else
	LCMS_INCLUDES=""
	LCMS_LIBS=""
        $2
fi

])dnl

dnl From FIND_MOTIF and ACX_PTHREAD, without much understanding
dnl
dnl FIND_PNG[ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]]
dnl ------------------------------------------------
dnl
dnl Find PNG libraries and headers
dnl
dnl Put compile stuff in PNG_INCLUDES
dnl Put link stuff in PNG_LIBS
dnl
dnl Default ACTION-IF-FOUND defines HAVE_PNG
dnl
AC_DEFUN([FIND_PNG], [
AC_REQUIRE([AC_PATH_XTRA])

PNG_INCLUDES=""
PNG_LIBS=""

AC_ARG_WITH(png, 
[  --without-png        		do not use libpng])
# Treat --without-png like --without-png-includes --without-png-libraries.
if test "$with_png" = "no"; then
	PNG_INCLUDES=no
	PNG_LIBS=no
fi

AC_ARG_WITH(png-includes,
[  --with-png-includes=DIR	PNG include files are in DIR],
PNG_INCLUDES="-I$withval")
AC_ARG_WITH(png-libraries,
[  --with-png-libraries=DIR	PNG libraries are in DIR],
PNG_LIBS="-L$withval -lpng")

AC_MSG_CHECKING(for PNG)

# Look for png.h 
if test "$PNG_INCLUDES" = ""; then
	png_save_LIBS="$LIBS"

	LIBS="-lpng $LIBS"

	# Check the standard search path
	AC_TRY_COMPILE([
		#include <png.h>],[int a],[
		PNG_INCLUDES=""
	], [
		# png.h is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/include \
			/usr/local/include \
			/usr/*/include \
			/usr/local/*/include /usr/*/include \
			"${prefix}"/include/* \
			/usr/include/* /usr/local/include/* /*/include; do
			if test -f "$dir/png.h"; then
				PNG_INCLUDES="-I$dir"
				break
			fi
		done

		if test "$PNG_INCLUDES" = ""; then
			PNG_INCLUDES=no
		fi
	])

	LIBS="$png_save_LIBS"
fi

# Now for the libraries
if test "$PNG_LIBS" = ""; then
	png_save_LIBS="$LIBS"
	png_save_INCLUDES="$INCLUDES"

	LIBS="-lpng $LIBS"
	INCLUDES="$PNG_INCLUDES $INCLUDES"

	# Try the standard search path first
	AC_TRY_LINK([
		#include <png.h>],[png_access_version_number()], [
		PNG_LIBS="-lpng"
	], [
		# libpng is not in the standard search path.

		# A whole bunch of guesses
		for dir in \
			"${prefix}"/*/lib \
			/usr/local/lib \
			/usr/*/lib \
			"${prefix}"/lib/* /usr/lib/* \
			/usr/local/lib/* /*/lib; do
			if test -d "$dir" && test "`ls $dir/libpng.* 2> /dev/null`" != ""; then
				PNG_LIBS="-L$dir -lpng"
				break
			fi
		done

		if test "$PNG_LIBS" = ""; then
			PNG_LIBS=no
		fi
	])

	LIBS="$png_save_LIBS"
	INCLUDES="$png_save_INCLUDES"
fi

AC_SUBST(PNG_LIBS)
AC_SUBST(PNG_INCLUDES)

# Print a helpful message
png_libraries_result="$PNG_LIBS"
png_includes_result="$PNG_INCLUDES"

if test x"$png_libraries_result" = x""; then
	png_libraries_result="in default path"
fi
if test x"$png_includes_result" = x""; then
	png_includes_result="in default path"
fi

if test "$png_libraries_result" = "no"; then
	png_libraries_result="(none)"
fi
if test "$png_includes_result" = "no"; then
	png_includes_result="(none)"
fi

AC_MSG_RESULT(
  [libraries $png_libraries_result, headers $png_includes_result])

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test "$PNG_INCLUDES" != "no" && test "$PNG_LIBS" != "no"; then
        ifelse([$1],,AC_DEFINE(HAVE_PNG,1,[Define if you have png libraries and header files.]),[$1])
        :
else
	PNG_INCLUDES=""
	PNG_LIBS=""
        $2
fi

])dnl

# Configure paths for libMagick
# from vips configure, JC 20/9/01
# Owen Taylor     97-11-3

dnl AM_PATH_MAGICK([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for libMagick, and define MAGICK_CFLAGS and MAGICK_LIBS
dnl
AC_DEFUN(AM_PATH_MAGICK,
[dnl 
dnl Get the cflags and libraries from the Magick-config script
dnl
AC_ARG_WITH(magick, 
[  --without-magick		do not use libmagick])
AC_ARG_WITH(magick-prefix,[  --with-magick-prefix=PFX      prefix where libMagick is installed],
            magick_config_prefix="$withval", magick_config_prefix="")
AC_ARG_WITH(magick-exec-prefix,[  --with-magick-exec-prefix=PFX exec prefix where libMagick is installed],
            magick_config_exec_prefix="$withval", magick_config_exec_prefix="")
AC_ARG_ENABLE(magicktest, [  --disable-magicktest    do not try to compile and run a test libMagick program],
		    , enable_magicktest=yes)

  if test x$magick_config_exec_prefix != x ; then
     if test x${MAGICK_CONFIG+set} != xset ; then
        MAGICK_CONFIG=$magick_config_exec_prefix/bin/Magick-config
     fi
  fi
  if test x$magick_config_prefix != x ; then
     if test x${MAGICK_CONFIG+set} != xset ; then
        MAGICK_CONFIG=$magick_config_prefix/bin/Magick-config
     fi
  fi

  AC_PATH_PROG(MAGICK_CONFIG, Magick-config, no)
  min_magick_version=ifelse([$1], ,0.99.7,$1)
  AC_MSG_CHECKING(for libMagick - version >= $min_magick_version)
  no_magick=""
  if test "$MAGICK_CONFIG" = "no" ; then
    no_magick=yes
  elif test "$with_magick" = "no" ; then
    no_magick=yes
  else
    MAGICK_CFLAGS=`$MAGICK_CONFIG --cppflags`
    MAGICK_LIBS=`$MAGICK_CONFIG --ldflags`
    MAGICK_LIBS="$MAGICK_LIBS `$MAGICK_CONFIG --libs`"
    magick_config_major_version=`$MAGICK_CONFIG --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    magick_config_minor_version=`$MAGICK_CONFIG --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    magick_config_micro_version=`$MAGICK_CONFIG --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_magicktest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $MAGICK_CFLAGS"
      LIBS="$MAGICK_LIBS $LIBS"
dnl
dnl Now check if the installed libMagick is sufficiently new. (Also sanity
dnl checks the results of Magick-config to some extent
dnl
      rm -f conf.magicktest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include <magick/api.h>

int 
main()
{
	int major, minor, micro;

	int magick_major_version;
	int magick_minor_version;
	int magick_micro_version;

	char *tmp_version;

	system( "touch conf.magicktest" );

	sscanf( MagickLibVersionText, "%d.%d.%d", 
		&magick_major_version,
		&magick_minor_version,
		&magick_micro_version );

	/* HP/UX 9 (%@@#!) writes to sscanf strings */
	tmp_version = strdup( "$min_magick_version" );
	if( sscanf( tmp_version, "%d.%d.%d", &major, &minor, &micro ) != 3 ) {
		printf( "%s, bad version string\n", "$min_magick_version" );
		exit( 1 );
	}

  if ((magick_major_version != $magick_config_major_version) ||
      (magick_minor_version != $magick_config_minor_version) ||
      (magick_micro_version != $magick_config_micro_version))
    {
      printf("\n*** 'Magick-config --version' returned %d.%d.%d, but libMagick (%d.%d.%d)\n", 
             $magick_config_major_version, $magick_config_minor_version,
	     $magick_config_micro_version,
             magick_major_version, magick_minor_version, magick_micro_version);
      printf ("*** was found! If Magick-config was correct, then it is best\n");
      printf ("*** to remove the old version of libMagick. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If Magick-config was wrong, set the environment variable MAGICK_CONFIG\n");
      printf("*** to point to the correct copy of Magick-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
  else
    {
      if ((magick_major_version > major) ||
        ((magick_major_version == major) && (magick_minor_version > minor)) ||
        ((magick_major_version == major) && (magick_minor_version == minor) &&
	(magick_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of libMagick (%d.%d.%d) was found.\n",
               magick_major_version, magick_minor_version, magick_micro_version);
        printf("*** You need a version of libMagick newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** libMagick is always available from http://www.imagemagick.org/\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the Magick-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of libMagick, but you can also set the MAGICK_CONFIG environment to point to the\n");
        printf("*** correct copy of Magick-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_magick=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_magick" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  elif test "$with_magick" = "no" ; then
     AC_MSG_RESULT(no)
     MAGICK_CFLAGS=""
     MAGICK_LIBS=""
     ifelse([$3], , :, [$3])
  else
     AC_MSG_RESULT(no)
     if test "$MAGICK_CONFIG" = "no" ; then
       echo "*** The Magick-config script installed by libMagick could not be found"
       echo "*** If libMagick was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the MAGICK_CONFIG environment variable to the"
       echo "*** full path to Magick-config."
     else
       if test -f conf.magicktest ; then
        :
       else
          echo "*** Could not run libMagick test program, checking why..."
          CFLAGS="$CFLAGS $MAGICK_CFLAGS"
          LIBS="$LIBS $MAGICK_LIBS"
          AC_TRY_LINK([
#include <magick/api.h>
],      [ InitializeMagick("."); return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding libMagick or finding the wrong"
          echo "*** version of libMagick. If it is not finding libMagick, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means libMagick was incorrectly installed"
          echo "*** or that you have moved libMagick since it was installed. In the latter case, you"
          echo "*** may want to edit the Magick-config script: $MAGICK_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     MAGICK_CFLAGS=""
     MAGICK_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(MAGICK_CFLAGS)
  AC_SUBST(MAGICK_LIBS)
  rm -f conf.magicktest
])
