# Configure paths for VIPS
# from vips configure, JC 20/9/01
# Owen Taylor     97-11-3

dnl AM_PATH_VIPS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for VIPS, and define VIPS_CFLAGS and VIPS_LIBS
dnl
AC_DEFUN(AM_PATH_VIPS,
[dnl 
dnl Get the cflags and libraries from the vips-config script
dnl
AC_ARG_WITH(vips-prefix,[  --with-vips-prefix=PFX  prefix where VIPS is installed (optional)],
            vips_config_prefix="$withval", vips_config_prefix="")
AC_ARG_WITH(vips-exec-prefix,[  --with-vips-exec-prefix=PFX exec prefix where VIPS is installed (optional)],
            vips_config_exec_prefix="$withval", vips_config_exec_prefix="")
AC_ARG_ENABLE(vipstest, [  --disable-vipstest      do not try to compile and run a test VIPS program],
		    , enable_vipstest=yes)

  if test x$vips_config_exec_prefix != x ; then
     vips_config_args="$vips_config_args --exec-prefix=$vips_config_exec_prefix"
     if test x${VIPS_CONFIG+set} != xset ; then
        VIPS_CONFIG=$vips_config_exec_prefix/bin/vips-config
     fi
  fi
  if test x$vips_config_prefix != x ; then
     vips_config_args="$vips_config_args --prefix=$vips_config_prefix"
     if test x${VIPS_CONFIG+set} != xset ; then
        VIPS_CONFIG=$vips_config_prefix/bin/vips-config
     fi
  fi

  AC_PATH_PROG(VIPS_CONFIG, vips-config, no)
  min_vips_version=ifelse([$1], ,0.99.7,$1)
  AC_MSG_CHECKING(for VIPS - version >= $min_vips_version)
  no_vips=""
  if test "$VIPS_CONFIG" = "no" ; then
    no_vips=yes
  else
    VIPS_CFLAGS=`$VIPS_CONFIG $vips_config_args --cflags`
    VIPS_LIBS=`$VIPS_CONFIG $vips_config_args --libs`
    vips_config_major_version=`$VIPS_CONFIG $vips_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    vips_config_minor_version=`$VIPS_CONFIG $vips_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    vips_config_micro_version=`$VIPS_CONFIG $vips_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_vipstest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $VIPS_CFLAGS"
      LIBS="$VIPS_LIBS $LIBS"
dnl
dnl Now check if the installed VIPS is sufficiently new. (Also sanity
dnl checks the results of vips-config to some extent
dnl
      rm -f conf.vipstest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <vips/vips.h>

int 
main()
{
	int major, minor, micro;

	int vips_major_version;
	int vips_minor_version;
	int vips_micro_version;

	char *tmp_version;

	system( "touch conf.vipstest" );

	vips_major_version = im_version( 0 );
	vips_minor_version = im_version( 1 );
	vips_micro_version = im_version( 2 );

	/* HP/UX 9 (%@#!) writes to sscanf strings */
	tmp_version = strdup( "$min_vips_version" );
	if( sscanf( tmp_version, "%d.%d.%d", &major, &minor, &micro ) != 3 ) {
		printf( "%s, bad version string\n", "$min_gtk_version" );
		exit( 1 );
	}

  if ((vips_major_version != $vips_config_major_version) ||
      (vips_minor_version != $vips_config_minor_version) ||
      (vips_micro_version != $vips_config_micro_version))
    {
      printf("\n*** 'vips-config --version' returned %d.%d.%d, but VIPS (%d.%d.%d)\n", 
             $vips_config_major_version, $vips_config_minor_version, $vips_config_micro_version,
             vips_major_version, vips_minor_version, vips_micro_version);
      printf ("*** was found! If vips-config was correct, then it is best\n");
      printf ("*** to remove the old version of VIPS. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If vips-config was wrong, set the environment variable VIPS_CONFIG\n");
      printf("*** to point to the correct copy of vips-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
#if defined (VIPS_MAJOR_VERSION) && defined (VIPS_MINOR_VERSION) && defined (VIPS_MICRO_VERSION)
  else if ((vips_major_version != VIPS_MAJOR_VERSION) ||
	   (vips_minor_version != VIPS_MINOR_VERSION) ||
           (vips_micro_version != VIPS_MICRO_VERSION))
    {
      printf("*** VIPS header files (version %d.%d.%d) do not match\n",
	     VIPS_MAJOR_VERSION, VIPS_MINOR_VERSION, VIPS_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     vips_major_version, vips_minor_version, vips_micro_version);
    }
#endif /* defined (VIPS_MAJOR_VERSION) ... */
  else
    {
      if ((vips_major_version > major) ||
        ((vips_major_version == major) && (vips_minor_version > minor)) ||
        ((vips_major_version == major) && (vips_minor_version == minor) && (vips_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of VIPS (%d.%d.%d) was found.\n",
               vips_major_version, vips_minor_version, vips_micro_version);
        printf("*** You need a version of VIPS newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** VIPS is always available from http://www.vips.ecs.soton.ac.uk\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the vips-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of VIPS, but you can also set the VIPS_CONFIG environment to point to the\n");
        printf("*** correct copy of vips-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_vips=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_vips" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$VIPS_CONFIG" = "no" ; then
       echo "*** The vips-config script installed by VIPS could not be found"
       echo "*** If VIPS was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the VIPS_CONFIG environment variable to the"
       echo "*** full path to vips-config."
     else
       if test -f conf.vipstest ; then
        :
       else
          echo "*** Could not run VIPS test program, checking why..."
          CFLAGS="$CFLAGS $VIPS_CFLAGS"
          LIBS="$LIBS $VIPS_LIBS"
          AC_TRY_LINK([
#include <vips/vips.h>
#include <stdio.h>
],      [ return (im_version(0)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding VIPS or finding the wrong"
          echo "*** version of VIPS. If it is not finding VIPS, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means VIPS was incorrectly installed"
          echo "*** or that you have moved VIPS since it was installed. In the latter case, you"
          echo "*** may want to edit the vips-config script: $VIPS_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     VIPS_CFLAGS=""
     VIPS_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(VIPS_CFLAGS)
  AC_SUBST(VIPS_LIBS)
  rm -f conf.vipstest
])
