/* @(#) Header file for Birkbeck/VIPS Image Processing Library
 * Authors: N. Dessipris, K. Martinez, Birkbeck College, London.
 * and J. Cupitt The National Gallery, London.
 *
 * Sept 94
 *
 * 15/7/96 JC
 * 	- now does C++ extern stuff
 *	- many more protos
 * 15/4/97 JC
 *	- protos split out here, more of them
 *	- still not complete tho' ...
 * 8/4/99 JC
 *	- lots of consts added to please C++
 *	- and more protos added
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifndef IM_PROTO_H
#define IM_PROTO_H

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/

/* Need these for some protos.
 */
#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include "rect.h"

typedef int (*im_callback_fn)( void *, void * );
typedef void *(*im_construct_fn)( void *, void *, void * );

/* iofuncs
 */
const char *im_errorstring( void );
int im_debugim( IMAGE * );
int im_printlines( IMAGE * );

int im_header_int( IMAGE *im, const char *field, int *out );
int im_header_double( IMAGE *im, const char *field, double *out );
int im_header_string( IMAGE *im, const char *field, char **out );
const char *im_version_string( void );
int im_version( int flag );
const char *im_guess_prefix( const char *, const char * );
IMAGE *im_init( const char * );
IMAGE *im_openout( const char * );
int im__read_header( IMAGE *image );
int im_openin( IMAGE *image );
int im_openinrw( IMAGE *image );
IMAGE *im_setbuf( const char * );
IMAGE *im_partial( const char * );
IMAGE *im_binfile( const char *, int, int, int );
IMAGE *im_image( void *, int, int, int, int );

void *im__mmap( int fd, int writeable, size_t length, off_t offset );
int im__munmap( void *start, size_t length );
PEL *im_mapfile( int fd );
PEL *im_mapfilerw( int fd );
int im_remapfilerw( IMAGE *image );

IMAGE *im_open( const char *, const char * );
IMAGE *im_open_header( const char * );
void *im_local( IMAGE *, 
	im_construct_fn cons, im_callback_fn dest, void *a, void *b, void *c );
int im_local_array( IMAGE *im, void **out, int n,
	im_construct_fn cons, im_callback_fn dest, void *a, void *b, void *c );
#define im_open_local( IM, NAME, MODE ) \
	((IMAGE *) im_local( (IM), \
		(im_construct_fn) im_open, (im_callback_fn) im_close, \
		(void *) (NAME), (void *) (MODE), NULL ))
#define im_open_local_array( IM, OUT, N, NAME, MODE ) \
	(im_local_array( (IM), (void **)(OUT), (N),\
		(im_construct_fn) im_open, (im_callback_fn) im_close, \
		(void *) (NAME), (void *) (MODE), NULL ))
int im_image_sanity( IMAGE * );

void *im_malloc( IMAGE *im, int sz );
int im_free( void * );
char *im_strdup( IMAGE *im, const char *str );
char *im_strncpy( char *dest, const char *src, int n );
int im_vsnprintf( char *str, size_t size, const char *format, va_list ap );
int im_snprintf( char *str, size_t size, const char *format, ... );
char *im_strrstr( const char *haystack, const char *needle );

int im_close( IMAGE * );
int im_rwcheck( IMAGE * );
int im_iocheck( IMAGE *, IMAGE * );
int im_incheck( IMAGE * );
int im_outcheck( IMAGE * );
int im_piocheck( IMAGE *, IMAGE * );
int im_pincheck( IMAGE * );
int im_poutcheck( IMAGE * );
int im_cp_desc( IMAGE *, IMAGE * );
int im_cp_Hist( IMAGE *, IMAGE * );
int im_append_Hist( IMAGE *, IMAGE * );
int im_setupout( IMAGE * );
int im__write( int, const void *, size_t );
int im__open_image_file( const char *filename );
void im__change_suffix( const char *name, char *out, int mx,
        const char *new_suff, const char **olds, int nolds );
int im_writeline( int, IMAGE *, PEL * );

int im_isuint( IMAGE * );
int im_isint( IMAGE * );
int im_isfloat( IMAGE * );
int im_iscomplex( IMAGE * );
int im_isfile( IMAGE * );
int im_ispartial( IMAGE * );
int im_isMSBfirst( IMAGE * );
int im_amiMSBfirst( void );

int im_ispoweroftwo( int );

int im_path_is_absolute( const char *file );

int im_existsf( const char *name, ... );
int im_istiff( const char * );
int im_istifftiled( const char * );
int im_istiffpyramid( const char * );
int im_isjpeg( const char * );
int im_isvips( const char * );
int im_isppm( const char * );
int im_ispng( const char * );
int im_ismagick( const char * );

int im_add_close_callback( IMAGE *, im_callback_fn, void *, void * );
int im_add_eval_callback( IMAGE *, im_callback_fn, void *, void * );
int im_add_evalend_callback( IMAGE *, im_callback_fn, void *, void * );

void error_exit( const char *, ... );
void im_clear_error_string( void );
void im_verrormsg( const char *fmt, va_list ap );
void im_errormsg( const char *fmt, ... );
void im_errormsg_system( int err, const char *fmt, ... );
void im_warning( const char *fmt, ... );
void im_diagnostics( const char *fmt, ... );

void im_printhd( VAS_HD * );
const char *im_Type2char( int );
const char *im_BandFmt2char( int );
const char *im_Coding2char( int );
const char *im_Compression2char( int );
const char *im_dhint2char( im_demand_type );
const char *im_dtype2char( im_desc_type );
int im_char2Type( const char * );
int im_char2BandFmt( const char * );
int im_char2Coding( const char * );
int im_char2Compression( const char * );

void im__print_all( void );
void im__print_one( int );
int im__trigger_callbacks();
int im_unmapfile( int fd, PEL *baseaddress );
void im_printdesc( IMAGE * );
void im_initdesc( IMAGE *, 
	int, int, int, int, int, int, int, float, float,
	int, int );
void im_inithd( VAS_HD *hd, int bnd, int bndbits, int bndfmt,
	int xsize, int ysize,
	int imtype, int codfmt, double xres, double yres,
	int Length, int Compression, int Level,
	int Xoffset, int Yoffset );
int im__close( IMAGE * );
int im__handle_eval( IMAGE *im, int w, int h );
int im_desc_hd( IMAGE *image, VAS_HD *header );
int im_readhist( IMAGE *image );
int im_crwrhd( IMAGE *image );
int im_histlin( IMAGE *image, const char *fmt, ... );
int im_updatehist( IMAGE *out, int argc, char *argv[] );

void im__filename_split( const char *, char *, char * );
void im__filename_suffix( const char *, char * );
int im__filename_suffix_match( const char *, const char *[] );
int im__isprefix( const char *, const char * );
int im__ispostfix( const char *, const char * );
char *im__getnextoption( char ** );
char *im__getsuboption( const char * );
const char *im__skip_dir( const char *filename );
extern int im__read_test;

/* morphology
 */
int im_dilate( IMAGE *in, IMAGE *out, INTMASK *m );
int im_dilate_raw( IMAGE *in, IMAGE *out, INTMASK *m );
int im_erode( IMAGE *in, IMAGE *out, INTMASK *m );
int im_erode_raw( IMAGE *in, IMAGE *out, INTMASK *m );
int im_cntlines( IMAGE *im, double *nolines, int flag );
int im_profile( IMAGE *in, IMAGE *out, int dir );

/* convolution
 */
void im_copy_dmask_matrix( DOUBLEMASK *mask, double **matrix );
void im_copy_matrix_dmask( double **matrix, DOUBLEMASK *mask );
INTMASK *im_create_imask( const char *, int, int );
INTMASK *im_create_imaskv( const char *, int, int, ... );
DOUBLEMASK *im_create_dmask( const char *, int, int );
DOUBLEMASK *im_create_dmaskv( const char *, int, int, ... );
INTMASK *im_dup_imask( INTMASK *, const char * );
DOUBLEMASK *im_dup_dmask( DOUBLEMASK *, const char * );
int im_free_imask( INTMASK * );
int im_free_dmask( DOUBLEMASK * );
INTMASK *im_read_imask( const char * );
DOUBLEMASK *im_read_dmask( const char * );
void im_print_imask( INTMASK * );
void im_print_dmask( DOUBLEMASK * );
int im_write_imask( INTMASK * );
int im_write_dmask( DOUBLEMASK * );
int im_write_imask_name( INTMASK *, const char * );
int im_write_dmask_name( DOUBLEMASK *, const char * );
INTMASK *im_scale_dmask( DOUBLEMASK *, const char * );
int *im_offsets45( int );
int *im_offsets90( int );
INTMASK *im_rotate_imask90( INTMASK *, const char * );
INTMASK *im_rotate_imask45( INTMASK *, const char * );
DOUBLEMASK *im_rotate_dmask90( DOUBLEMASK *, const char * );
DOUBLEMASK *im_rotate_dmask45( DOUBLEMASK *, const char * );
INTMASK *im_log_imask( const char *, double, double );
DOUBLEMASK *im_log_dmask( const char *, double, double );
INTMASK *im_gauss_imask( const char *, double, double );
DOUBLEMASK *im_gauss_dmask( const char *, double, double );

int im_rank( IMAGE *, IMAGE *, int, int, int );
int im_sharpen( IMAGE *, IMAGE *, int, double, double, double, double, double );
int im_addgnoise( IMAGE *, IMAGE *, double );
int im_gaussnoise( IMAGE *, int, int, double, double );

int im_zerox( IMAGE *, IMAGE *, int );

int im_maxvalue( IMAGE **in, IMAGE *out, int n );
int im_compass( IMAGE *, IMAGE *, INTMASK * );
int im_compass_old( IMAGE *, IMAGE *, INTMASK * );
int im_gradient( IMAGE *, IMAGE *, INTMASK * );
int im_gradient_old( IMAGE *, IMAGE *, INTMASK * );
int im_lindetect( IMAGE *, IMAGE *, INTMASK * );
int im_lindetect_old( IMAGE *, IMAGE *, INTMASK * );
int im_conv( IMAGE *, IMAGE *, INTMASK * );
int im_conv_raw( IMAGE *, IMAGE *, INTMASK * );
int im_convf( IMAGE *, IMAGE *, DOUBLEMASK * );
int im_convf_raw( IMAGE *, IMAGE *, DOUBLEMASK * );
int im_convsep( IMAGE *, IMAGE *, INTMASK * );
int im_convsep_raw( IMAGE *, IMAGE *, INTMASK * );
int im_convsepf( IMAGE *, IMAGE *, DOUBLEMASK * );
int im_convsepf_raw( IMAGE *, IMAGE *, DOUBLEMASK * );
int im_convsub( IMAGE *, IMAGE *, INTMASK *, int, int );

int im_fastcor( IMAGE *, IMAGE *, IMAGE * );
int im_fastcor_raw( IMAGE *, IMAGE *, IMAGE * );
int im_spcor( IMAGE *, IMAGE *, IMAGE * );
int im_spcor_raw( IMAGE *, IMAGE *, IMAGE * );

int im_resize_linear( IMAGE *, IMAGE *, int, int );
int im_mpercent( IMAGE *, double, int * );
int im_shrink( IMAGE *, IMAGE *, double, double );
int im_embed( IMAGE *, IMAGE *, int, int, int, int, int );

int im__create_int_luts( int *, int, int **, int **, int * );
int im__create_double_luts( double *, int, double **, double **, int * );

int im_stretch3( IMAGE *in, IMAGE *out, double dx, double dy );
int im_rank_raw( IMAGE *in, IMAGE *out, int xsize, int ysize, int n );

/* freq_filt
 */
int im_fractsurf( IMAGE *out, int size, double frd );
int im_freqflt( IMAGE *, IMAGE *, IMAGE * );
int im_disp_ps( IMAGE *, IMAGE * );
int im_rotquad( IMAGE *, IMAGE * );
int im_fwfft( IMAGE *, IMAGE * );
int im_invfft( IMAGE *, IMAGE * );
int im_invfftr( IMAGE *, IMAGE * );
int im__fft_sp( float *rvec, float *ivec, int logrows, int logcols );
typedef int (*im__fftproc_fn)( IMAGE *, IMAGE *, IMAGE * );
int im__fftproc( IMAGE *dummy, IMAGE *in, IMAGE *out, im__fftproc_fn fn );

/* arithmetic
 */
DOUBLEMASK *im_measure( IMAGE *, IMAGE_BOX *, 
	int, int, int *, int, const char * );
DOUBLEMASK *im_stats( IMAGE * );
int im_abs( IMAGE *in, IMAGE *out );
int im_max( IMAGE *in, double *out );
int im_min( IMAGE *in, double *out );
int im_avg( IMAGE *in, double *out );
int im_deviate( IMAGE *in, double *out );
int im_maxpos( IMAGE *in, int *xpos, int *ypos, double *out );
int im_minpos( IMAGE *in, int *xpos, int *ypos, double *out );
int im_add( IMAGE *, IMAGE *, IMAGE * );
int im_subtract( IMAGE *, IMAGE *, IMAGE * );
int im_invert( IMAGE *, IMAGE * );
int im_lintra( double, IMAGE *, double, IMAGE * );
int im_lintra_vec( int n, double *a, IMAGE *in, double *b, IMAGE *out );
int im_multiply( IMAGE *, IMAGE *, IMAGE * );
int im_divide( IMAGE *, IMAGE *, IMAGE * );
int im_powtra( IMAGE *, IMAGE *, double );
int im_powtra_vec( IMAGE *in, IMAGE *out, int n, double *e );
int im_exptra( IMAGE *, IMAGE * );
int im_exp10tra( IMAGE *, IMAGE * );
int im_expntra( IMAGE *, IMAGE *, double );
int im_expntra_vec( IMAGE *in, IMAGE *out, int n, double *e );
int im_logtra( IMAGE *, IMAGE * );
int im_log10tra( IMAGE *, IMAGE * );
int im_remainder( IMAGE *, IMAGE *, IMAGE * );
int im_remainderconst( IMAGE *, IMAGE *, double );
int im_remainderconst_vec( IMAGE *, IMAGE *, int, double * );
int im_floor( IMAGE *, IMAGE * );
int im_ceil( IMAGE *, IMAGE * );
int im_sintra( IMAGE *, IMAGE * );
int im_sign( IMAGE *in, IMAGE *out );
int im_costra( IMAGE *, IMAGE * );
int im_tantra( IMAGE *, IMAGE * );
int im_asintra( IMAGE *, IMAGE * );
int im_acostra( IMAGE *, IMAGE * );
int im_atantra( IMAGE *, IMAGE * );
int im_cmulnorm( IMAGE *, IMAGE *, IMAGE * );
int im_fav4( IMAGE **, IMAGE * );
int im_gadd( double, IMAGE *, double, IMAGE *, double, IMAGE *);
int im_litecor( IMAGE *, IMAGE *, IMAGE *, int, double );

/* boolean
 */
int im_andimage( IMAGE *, IMAGE *, IMAGE * );
int im_andconst( IMAGE *, IMAGE *, double );
int im_and_vec( IMAGE *, IMAGE *, int, double * );
int im_orimage( IMAGE *, IMAGE *, IMAGE * );
int im_orconst( IMAGE *, IMAGE *, double );
int im_or_vec( IMAGE *, IMAGE *, int, double * );
int im_eorimage( IMAGE *, IMAGE *, IMAGE * );
int im_eorconst( IMAGE *, IMAGE *, double );
int im_eor_vec( IMAGE *, IMAGE *, int, double * );
int im_shiftleft( IMAGE *, IMAGE *, int );
int im_shiftright( IMAGE *, IMAGE *, int );

/* histogram
 */
int im_maplut( IMAGE *, IMAGE *, IMAGE * );
int im_gammacorrect( IMAGE *, IMAGE *, double );
int im_heq( IMAGE *in, IMAGE *out, int bandno );
int im_hist( IMAGE *in, IMAGE *out, int bandno );
int im_histeq( IMAGE *in, IMAGE *out );
int im_histnorm( IMAGE *in, IMAGE *out );
int im_histcum( IMAGE *in, IMAGE *out );
int im_histgr( IMAGE *in, IMAGE *out, int bandno );
int im_histnD( IMAGE *in, IMAGE *out, int bins );
int im_histplot( IMAGE *hist, IMAGE *histplot );
int im_histspec( IMAGE *hin, IMAGE *href, IMAGE *lut );
int im_hsp( IMAGE *in, IMAGE *ref, IMAGE *out );
int im_identity( IMAGE *lut, int bands );
int im_identity_ushort( IMAGE *lut, int bands, int sz );
int im_lhisteq( IMAGE *in, IMAGE *out, int xwin, int ywin );
int im_lhisteq_raw( IMAGE *in, IMAGE *out, int xwin, int ywin );
int im_invertlut( DOUBLEMASK *input, IMAGE *output, int lut_size );
int im_stdif( IMAGE *in, IMAGE *out,
	double a, double m0, double b, double s0, int xwin, int ywin );
int im_stdif_raw( IMAGE *in, IMAGE *out,
	double a, double m0, double b, double s0, int xwin, int ywin );
int im_tone_build( IMAGE *out,
	double Lb, double Lw, double Ps, double Pm, double Ph,
	double S, double M, double H );
int im_tone_analyse( IMAGE *in, IMAGE *lut,
	double Ps, double Pm, double Ph, double S, double M, double H );
int im_ismonotonic( IMAGE *lut, int *out );
int im_tone_map( IMAGE *in, IMAGE *out, IMAGE *lut );

/* conversion
 */
DOUBLEMASK *im_vips2mask( IMAGE *, const char * );
int im_mask2vips( DOUBLEMASK *, IMAGE * );
int im_copy( IMAGE *, IMAGE * );
int im_copy_set( IMAGE *, IMAGE *, int, float, float, int, int );
int im_extract( IMAGE *, IMAGE *, IMAGE_BOX * );
int im_extract_band( IMAGE *in, IMAGE *out, int band );
int im_extract_area( IMAGE *in, IMAGE *out, int x, int y, int w, int h );
int im_subsample( IMAGE *, IMAGE *, int, int );
int im_zoom( IMAGE *, IMAGE *, int, int );
int im_bandjoin( IMAGE *, IMAGE *, IMAGE * );
int im_gbandjoin( IMAGE **, IMAGE *, int );
int im_black( IMAGE *, int, int, int );
int im_c2amph( IMAGE *, IMAGE * );
int im_c2rect( IMAGE *, IMAGE * );
int im_clip2fmt( IMAGE *in, IMAGE *out, int ofmt );
int im_clip2dcm( IMAGE *, IMAGE * );
int im_clip2cm( IMAGE *, IMAGE * );
int im_clip2us( IMAGE *, IMAGE * );
int im_clip2ui( IMAGE *, IMAGE * );
int im_clip2s( IMAGE *, IMAGE * );
int im_clip2i( IMAGE *, IMAGE * );
int im_clip2d( IMAGE *, IMAGE * );
int im_clip2f( IMAGE *, IMAGE * );
int im_clip2c( IMAGE *, IMAGE * );
int im_clip( IMAGE *, IMAGE * );
int im_ri2c( IMAGE *, IMAGE *, IMAGE * );
int im_c2imag( IMAGE *, IMAGE * );
int im_c2real( IMAGE *, IMAGE * );
int im_c2ps( IMAGE *, IMAGE * );
int im_fliphor( IMAGE *, IMAGE * );
int im_flipver( IMAGE *, IMAGE * );
int im_falsecolour( IMAGE *, IMAGE * );
int im_recomb( IMAGE *, IMAGE *, DOUBLEMASK * );
int im_insert( IMAGE *, IMAGE *, IMAGE *, int, int );
int im_insert_noexpand( IMAGE *, IMAGE *, IMAGE *, int, int );
int im_rot90( IMAGE *, IMAGE * );
int im_rot180( IMAGE *, IMAGE * );
int im_rot270( IMAGE *, IMAGE * );
int im_lrjoin( IMAGE *, IMAGE *, IMAGE * );
int im_tbjoin( IMAGE *, IMAGE *, IMAGE * );
int im_scale( IMAGE *, IMAGE * );
int im_scaleps( IMAGE *, IMAGE * );
int im_slice( IMAGE *, IMAGE *, double, double );
int im_system( IMAGE *im, const char *cmd, char **out );
int im_print( const char *message );
int im_thresh( IMAGE *, IMAGE *, double );
int im_jpeg2vips( const char *, IMAGE * );
int im_jpeg2vips_header( const char *, IMAGE * );
int im_vips2jpeg( IMAGE *, const char * );
int im_vips2mimejpeg( IMAGE *, int );
int im_vips2bufjpeg( IMAGE *, IMAGE *, int, char **, int * );
int im_vips2tiff( IMAGE *, const char * );
int im_bernd( const char *, int, int, int, int );
int im_tiff2vips( const char *, IMAGE * );
int im_tiff2vips_header( const char *, IMAGE * );
int im_magick2vips( const char *, IMAGE * );
int im_magick2vips_header( const char *, IMAGE * );
int im_png2vips( const char *, IMAGE * );
int im_png2vips_header( const char *, IMAGE * );
int im_ppm2vips( const char *, IMAGE * );
int im_ppm2vips_header( const char *, IMAGE * );
int im_vips2ppm( IMAGE *, const char * );
int im_dicom2vips( const char *, IMAGE * );
int im_dicom2vips_header( const char *, IMAGE * );
int im_vips2png( IMAGE *, const char * );

/* colour
 */
int im_Lab2LCh( IMAGE *, IMAGE * );
int im_LCh2Lab( IMAGE *, IMAGE * );
int im_LabQ2XYZ( IMAGE *, IMAGE * );
int im_LCh2UCS( IMAGE *, IMAGE * );
int im_Lab2LCh( IMAGE *, IMAGE * );
int im_Lab2LabQ( IMAGE *, IMAGE * );
int im_Lab2LabS( IMAGE *, IMAGE * );
int im_Lab2XYZ( IMAGE *, IMAGE * );
int im_Lab2XYZ_temp( IMAGE *, IMAGE *, double X0, double Y0, double Z0 );
int im_Lab2UCS( IMAGE *, IMAGE * );
int im_LabQ2Lab( IMAGE *, IMAGE * );
int im_LabQ2LabS( IMAGE *, IMAGE * );
int im_LabS2LabQ( IMAGE *, IMAGE * );
int im_LabS2Lab( IMAGE *, IMAGE * );
int im_UCS2XYZ( IMAGE *, IMAGE * );
int im_UCS2LCh( IMAGE *, IMAGE * );
int im_UCS2Lab( IMAGE *, IMAGE * );
int im_XYZ2Lab( IMAGE *, IMAGE * );
int im_XYZ2Lab_temp( IMAGE *, IMAGE *, double X0, double Y0, double Z0 );
int im_XYZ2UCS( IMAGE *, IMAGE * );
int im_sRGB2XYZ( IMAGE *, IMAGE * );
int im_XYZ2sRGB( IMAGE *, IMAGE * );
int im_Yxy2XYZ( IMAGE *, IMAGE * );
int im_XYZ2Yxy( IMAGE *, IMAGE * );

int im_dECMC_fromLab( IMAGE *, IMAGE *, IMAGE * );
int im_dE_fromXYZ( IMAGE *, IMAGE *, IMAGE * );
int im_dE_fromLab( IMAGE *, IMAGE *, IMAGE * );

void imb_Lab2LCh( float *, float *, int );
void imb_LCh2Lab( float *, float *, int );
void imb_XYZ2Lab( float *, float *, int, im_colour_temperature * );
void imb_Lab2XYZ( float *, float *, int, im_colour_temperature * );
void imb_LabQ2Lab( PEL *, float *, int );
void imb_Lab2LabQ( float *, PEL *, int );
void imb_LabS2Lab( signed short *, float *, int );
void imb_Lab2LabS( float *, signed short *, int n );

void im_col_make_tables_UCS( void );

float im_col_dECMC( float, float, float, float, float, float );
float im_col_dE00( float, float, float, float, float, float );

int im_lab_morph( IMAGE *in, IMAGE *out,
	DOUBLEMASK *mask, 
	double L_offset, double L_scale, 
	double a_scale, double b_scale );

/* other
 */
int im__mean_std_double_buffer( double *buffer, int size,
	double *pmean, double *pstd );
int im__mean_std_int_buffer( int *buffer, int size,
	double *pmean, double *pstd );
int im_feye( IMAGE *image, 
	const int xsize, const int ysize, const double factor );
int im_eye( IMAGE *image, 
	const int xsize, const int ysize, const double factor );
int im_zone( IMAGE *im, int size );
int im_fzone( IMAGE *im, int size );
int im_grey( IMAGE *im, const int xsize, const int ysize );
int im_fgrey( IMAGE *im, const int xsize, const int ysize );

int im_cooc_matrix( IMAGE *im, IMAGE *m, 
	int xp, int yp, int xs, int ys, int dx, int dy, int flag );
int im_cooc_asm( IMAGE *m, double *asmoment );
int im_cooc_contrast( IMAGE *m, double *contrast );
int im_cooc_correlation( IMAGE *m, double *correlation );
int im_cooc_entropy( IMAGE *m, double *entropy );

int im_glds_matrix( IMAGE *im, IMAGE *m, 
	int xpos, int ypos, int xsize, int ysize, int dx, int dy );
int im_glds_asm( IMAGE *m, double *asmoment );
int im_glds_contrast( IMAGE *m, double *contrast );
int im_glds_entropy( IMAGE *m, double *entropy );
int im_glds_mean( IMAGE *m, double *mean );

int im_simcontr( IMAGE *image, int xs, int ys );
int im_sines( IMAGE *image, 
	int xsize, int ysize, double horfreq, double verfreq );
int im_spatres( IMAGE *in,  IMAGE *out, int step );

/* mosaicing
 */
int im_lrmerge( IMAGE *ref, IMAGE *sec, IMAGE *out, 
	int dx, int dy, int mwidth );
int im_tbmerge( IMAGE *ref, IMAGE *sec, IMAGE *out, 
	int dx, int dy, int mwidth );

int im_lrmerge1( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int xr1, int yr1, int xs1, int ys1, 
	int xr2, int yr2, int xs2, int ys2,
	int mwidth );
int im_tbmerge1( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int xr1, int yr1, int xs1, int ys1, 
	int xr2, int yr2, int xs2, int ys2,
	int mwidth );

int im_lrmosaic( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int bandno,
	int xref, int yref, int xsec, int ysec,
	int halfcorrelation, int halfarea,
	int balancetype,
	int mwidth );
int im_tbmosaic( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int bandno,
	int xref, int yref, int xsec, int ysec,
	int halfcorrelation, int halfarea,
	int balancetype,
	int mwidth );

int im_lrmosaic1( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int bandno,
	int xr1, int yr1, int xs1, int ys1, 
	int xr2, int yr2, int xs2, int ys2,
	int halfcorrelation, int halfarea,
	int balancetype,
	int mwidth );
int im_tbmosaic1( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int bandno,
	int xr1, int yr1, int xs1, int ys1, 
	int xr2, int yr2, int xs2, int ys2,
	int halfcorrelation, int halfarea,
	int balancetype,
	int mwidth );

int im_match_linear( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int xr1, int yr1, int xs1, int ys1,
	int xr2, int yr2, int xs2, int ys2 );
int im_match_linear_search( IMAGE *ref, IMAGE *sec, IMAGE *out,
	int xr1, int yr1, int xs1, int ys1,
	int xr2, int yr2, int xs2, int ys2,
	int hwindowsize, int hsearchsize );

int im_global_balance( IMAGE *in, IMAGE *out, double gamma );
int im_global_balancef( IMAGE *in, IMAGE *out, double gamma );

int im_affine( IMAGE *in, IMAGE *out,
	double a, double b, double c, double d, double dx, double dy,
	int ox, int oy, int ow, int oh );
int im_similarity( IMAGE *in, IMAGE *out,
	double a, double b, double dx, double dy );
int im_similarity_area( IMAGE *in, IMAGE *out,
	double a, double b, double dx, double dy,
	int ox, int oy, int ow, int oh );
int im_correl( IMAGE *ref, IMAGE *sec, 
	int xref, int yref, int xsec, int ysec,
	int hwindowsize, int hsearchsize,
	double *correlation, int *x, int *y );
int im_remosaic( IMAGE *in, IMAGE *out, 
	const char *old_str, const char *new_str );

int im__find_best_contrast( IMAGE *image,
	int xpos, int ypos, int xsize, int ysize,
	int xarray[], int yarray[], int cont[],
	int nbest, int hcorsize );
int im__balance( IMAGE *ref, IMAGE *sec, IMAGE *out,
	IMAGE **ref_out, IMAGE **sec_out, int dx, int dy, int balancetype );

/* inplace
 */
int im_plotmask( IMAGE *, int, int, PEL *, PEL *, Rect * );
int im_smear( IMAGE *, int, int, Rect * );
int im_smudge( IMAGE *, int, int, Rect * );
int im_paintrect( IMAGE *, Rect *, PEL * );
int im_circle( IMAGE *, int, int, int, int );
int im_insertplace( IMAGE *, IMAGE *, int, int );
int im_line( IMAGE *, int, int, int, int, int );
int im_fastlineuser();
int im_readpoint( IMAGE *, int, int, PEL * );
int im_flood( IMAGE *, int, int, PEL *, Rect * );
int im_flood_blob( IMAGE *, int, int, PEL *, Rect * );

/* relational
 */
int im_equal( IMAGE *, IMAGE *, IMAGE * );
int im_equalconst( IMAGE *, IMAGE *, double );
int im_equal_vec( IMAGE *, IMAGE *, int, double * );
int im_notequal( IMAGE *, IMAGE *, IMAGE * );
int im_notequalconst( IMAGE *, IMAGE *, double );
int im_notequal_vec( IMAGE *, IMAGE *, int, double * );
int im_more( IMAGE *, IMAGE *, IMAGE * );
int im_moreconst( IMAGE *, IMAGE *, double );
int im_more_vec( IMAGE *, IMAGE *, int, double * );
int im_less( IMAGE *, IMAGE *, IMAGE * );
int im_lessconst( IMAGE *, IMAGE *, double );
int im_less_vec( IMAGE *, IMAGE *, int, double * );
int im_moreeq( IMAGE *, IMAGE *, IMAGE * );
int im_moreeqconst( IMAGE *, IMAGE *, double );
int im_moreeq_vec( IMAGE *, IMAGE *, int, double * );
int im_lesseq( IMAGE *, IMAGE *, IMAGE * );
int im_lesseqconst( IMAGE *, IMAGE *, double );
int im_lesseq_vec( IMAGE *, IMAGE *, int, double * );
int im_ifthenelse( IMAGE *, IMAGE *, IMAGE *, IMAGE * );
int im_blend( IMAGE *, IMAGE *, IMAGE *, IMAGE * );

/* matrix
 */
DOUBLEMASK *im_matinv( DOUBLEMASK *, const char * );
DOUBLEMASK *im_mattrn( DOUBLEMASK *, const char * );
DOUBLEMASK *im_matcat( DOUBLEMASK *, DOUBLEMASK *, const char * );
DOUBLEMASK *im_matmul( DOUBLEMASK *, DOUBLEMASK *, const char * );

int *im_ivector();
float *im_fvector();
double *im_dvector();
void im_free_ivector();
void im_free_fvector();
void im_free_dvector();

int **im_imat_alloc();
float **im_fmat_alloc();
double **im_dmat_alloc();
void im_free_imat();
void im_free_fmat();
void im_free_dmat();

int im_invmat( double **, int );

/* video
 */
int im_video_v4l1( IMAGE *im, const char *device,
	int channel, int brightness, int colour, int contrast, int hue, 
	int ngrabs );

/* Internal.
 */
int im__cast_and_call();

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif /*IM_PROTO_H*/
