/* Definitions for thread support.
 *
 * JC, 9/5/94
 * 30/7/99 RP, JC
 *	- reworked for posix/solaris threads
 * 28/9/99 JC
 *	- restructured, made part of public API
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifndef IM_THREAD_H
#define IM_THREAD_H

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/

#ifdef SOLARIS_THREADS
#include <thread.h>
#include <synch.h>
#endif /*SOLARIS_THREADS*/

#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif /*HAVE_PTHREAD*/

/* A shortcut for some thread support.
 */
#if defined( SOLARIS_THREADS ) || defined( HAVE_PTHREAD )
#define HAVE_THREADS
#endif

/* A lock ... either posix or solaris.
 */
#ifdef SOLARIS_THREADS
typedef mutex_t im_lock_t;
#elif HAVE_PTHREAD
typedef pthread_mutex_t im_lock_t;
#else 
typedef int im_lock_t;
#endif 

/* Static initialisation for a lock.
 */
#ifdef SOLARIS_THREADS
#define IM_LOCK_STATIC (0)
#elif HAVE_PTHREAD
#define IM_LOCK_STATIC PTHREAD_MUTEX_INITIALIZER
#else 
#define IM_LOCK_STATIC (0)
#endif 

/* Implement our own semaphores.
 */
typedef struct {
	char *name;
	int v;

	im_lock_t mutex;
#ifdef HAVE_PTHREAD
	pthread_cond_t cond;
#elif SOLARIS_THREADS
	cond_t cond;
#endif
} im_semaphore_t;

/* A thread id.
 */
#ifdef SOLARIS_THREADS
typedef thread_t im_threadid_t;
#elif HAVE_PTHREAD
typedef pthread_t im_threadid_t;
#else 
typedef int im_threadid_t;
#endif 

/* Basic im_lock_t operations.
 */
void im_lock( im_lock_t *l );
void im_unlock( im_lock_t *l );
void im_lock_init( im_lock_t *l );
void im_lock_destroy( im_lock_t *l );

/* Semaphone ops.
 */
int im_semaphore_up( im_semaphore_t *s );
int im_semaphore_down( im_semaphore_t *s );
int im_semaphore_upn( im_semaphore_t *s, int n );
int im_semaphore_downn( im_semaphore_t *s, int n );
void im_semaphore_destroy( im_semaphore_t *s );
void im_semaphore_init( im_semaphore_t *s, int v, char *name );

/* Low-level thread functions.
 */
void im_thread_create( 
	void *(*start_func)( void * ), void *arg, im_threadid_t *id ); 
void im_thread_join( im_threadid_t id, void **ret ); 

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif /*IM_THREAD_H*/
