/* @(#) Function to write an IMAGE to a DOUBLEMASK. One band IM_BANDFMT_DOUBLE images
 * @(#) only.
 * @(#)
 * @(#) DOUBLEMASK *
 * @(#) im_vips2mask( IMAGE *in, char *out )
 * @(#)
 * @(#) The function returns NULL on error and a new DOUBLEMASK on success
 * Author: J.Cupitt
 * Written on: 6/6/94
 * Modified on:
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>

#include <vips/vips.h>
#include <vips/util.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

DOUBLEMASK *
im_vips2mask( IMAGE *in, const char *outname )
{
	int x, y;
	double *p, *q;
	DOUBLEMASK *out;

	/* Check the image.
	 */
	if( im_incheck( in ) ) {
		im_errormsg( "im_vips2mask: bad input image" );
		return( NULL );
	}
	if( in->Bands != 1 || in->BandFmt != IM_BANDFMT_DOUBLE || 
		in->Coding != IM_CODING_NONE ) {
		im_errormsg( "im_vips2mask: one band, double uncoded "
			"images only" );
		return( NULL );
	}

	/* Make the output mask.
	 */
	if( !(out = im_create_dmask( outname, in->Xsize, in->Ysize )) )
		return( NULL );

	/* Write!
	 */
	p = (double *) in->data;
	q = out->coeff;
	for( y = 0; y < out->ysize; y++ ) {
		for( x = 0; x < out->xsize; x++ )
			*q++ = *p++;
	}

	return( out );
}

