/* @(#)  Add gaussian noise with mean 0 and variance sigma to image
 * @(#)   The noise is generated by averaging 12 random numbers
 * @(#)  page 78 PIETGEN 1989 n = 12
 * @(#)  Input image is any, output is float
 * @(#)  If running on SYSTEM V CONSTANT should be replaced by 2**15 - 1
 * @(#)   Usage
 * @(#) 
 * @(#) int im_addgnoise(imin, imout, sigma)
 * @(#) IMAGE *imin, *imout;
 * @(#) double sigma;
 * @(#)  Returns 0 on success and -1 on error
 * @(#)
 *
 * Copyright 1990, N. Dessipris.
 *
 * File written on 2/12/1986
 * Author : N. Dessipris
 * Updated : 22/01/1991
 * 1/2/95 JC
 *	- junked!
 *	- now uses partial im_gaussnoise() and partial im_add() to do the
 *	  same job
 & 1/5/01 JC
 *	- oops, failed for not-1-band images
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>

#include <vips/vips.h>
#include <vips/region.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

int
im_addgnoise( IMAGE *in, IMAGE *out, double sigma )
{
	IMAGE *nb;
	int i;

	/* Make n-band noise image.
	 */
	for( i = 0; i < in->Bands; i++ ) {
		IMAGE *t2 = im_open_local( out, "im_addgnoise:2", "p" );

		if( !t2 || 
			im_gaussnoise( t2, in->Xsize, in->Ysize, 0.0, sigma ) )
			return( -1 );
		
		if( i > 0 ) {
			IMAGE *t3 = im_open_local( out, "im_addgnoise:3", "p" );

			if( !t3 || im_bandjoin( nb, t2, t3 ) )
				return( -1 );
			t2 = t3;
		}

		nb = t2;
	}

	if( im_add( in, nb, out ) )
		return( -1 );
	
	return( 0 );
}
