/* @(#) Takes as input a histogram and creates a lut which when applied
 * @(#) on the original image, histogram equilises it.
 * @(#) 
 * @(#) Histogram equalisation is carried out for each band of hist 
 * @(#) individually.
 * @(#) 
 * @(#) int im_histeq( IMAGE *hist, IMAGE *lut )
 * @(#)
 * @(#) Returns 0 on sucess and -1 on error
 *
 * Copyright: 1991, N. Dessipris
 *
 * Author: N. Dessipris
 * Written on: 02/08/1990
 * 24/5/95 JC
 *	- tidied up and ANSIfied
 * 20/7/95 JC
 *	- smartened up again
 *	- now works for hists >256 elements
 * 3/3/01 JC
 *	- broken into cum and norm ... helps im_histspec()
 *	- better behaviour for >8 bit hists
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>

#include <vips/vips.h>
#include <vips/util.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Form cumulative histogram.
 */
int 
im_histcum( IMAGE *in, IMAGE *out )
{
	IMAGE *t1 = im_open_local( out, "im_histeq:1", "p" );

	const int px = in->Xsize * in->Ysize;
	const int mx = px * in->Bands;

	unsigned int *inbuf;	
	unsigned int *outbuf;	/* Output write buffer */

	int i, j;

	if( !t1 )
		return( -1 );
	if( in->Coding != IM_CODING_NONE ) {
		im_errormsg( "im_histcum: input coded" );
		return( -1 );
	}
	if( px > 65536 ) {
		im_errormsg( "im_histcum: input too large" );
		return( -1 );
	}
        if( !im_isuint( in ) ) {
                im_errormsg( "im_histcum: input not some unsigned "
			"integer type" );
                return( -1 );
	}

	/* Force to uint. 
	 */
	if( im_clip2ui( in, t1 ) )
		return( -1 );
	if( im_iocheck( t1, out ) )
		return( -1 );
	inbuf = (unsigned int *) t1->data;

	/* Make output.
	 */
	if( !(outbuf = IM_ARRAY( out, IM_IMAGE_N_ELEMENTS( t1 ), unsigned int )) )
                return( -1 );

	/* Form cumulative histogram.
	 */
	for( i = 0; i < t1->Bands; i++ ) {
		unsigned int total = 0;

		for( j = i; j < mx; j += t1->Bands ) {
			total += inbuf[j];
			outbuf[j] = total;
		}
	}

	/* Write!
	 */
	if( im_cp_desc( out, t1 ) || im_setupout( out ) ||
		im_writeline( 0, out, (char *) outbuf ) )
		return( -1 );

	return( 0 );
}

/* Normalise histogram ... normalise range to make it square (ie. max ==
 * number of elements). Normalise each band separately.
 */
int 
im_histnorm( IMAGE *in, IMAGE *out )
{
	IMAGE *t1 = NULL;
	const int px = in->Xsize * in->Ysize;
	int i;
	int fmt;

	for( i = 0; i < in->Bands; i++ ) {
		IMAGE *t2 = im_open_local( out, "im_histnorm:2", "p" );
		IMAGE *t3 = im_open_local( out, "im_histnorm:3", "p" );
		double max;

		if( !t2 || !t3 || im_extract_band( in, t2, i ) || 
			im_max( t2, &max ) || 
			im_lintra( (double) px / max, t2, 0, t3 ) )
			return( -1 );

		if( !t1 )
			t1 = t3;
		else {
			IMAGE *t5 = im_open_local( out, "im_histnorm:5", "p" );

			if( !t5 || im_bandjoin( t1, t3, t5 ) )
				return( -1 );
			t1 = t5;
		}
	}

	/* Make output format as small as we can.
	 */
	if( px <= 256 ) 
		fmt = IM_BANDFMT_UCHAR;
	else if( px <= 65536 ) 
		fmt = IM_BANDFMT_USHORT;
	else 
		fmt = IM_BANDFMT_UINT;

	if( im_clip2fmt( t1, out, fmt ) )
		return( -1 );

	return( 0 );
}

/* Histogram equalisation. 
 */
int 
im_histeq( IMAGE *in, IMAGE *out )
{
	IMAGE *t1 = im_open_local( out, "im_histeq:1", "p" );

	/* Normalised cumulative.
	 */
	if( !t1 || im_histcum( in, t1 ) || im_histnorm( t1, out ) )
		return( -1 );

	return( 0 );
}
