/* im_header_int, im_header_double, im_header_string: output various fields
 * from the VIPS header
 *
 * 9/7/02 JC
 *	- first version
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>

#include <vips/vips.h>
#include <vips/util.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

int
im_header_int( IMAGE *im, const char *field, int *out )
{
	if( strcmp( field, "Xsize" ) == 0 )
		*out = im->Xsize;
	else if( strcmp( field, "Ysize" ) == 0 )
		*out = im->Ysize;
	else if( strcmp( field, "Bands" ) == 0 )
		*out = im->Bands;
	else if( strcmp( field, "Bbits" ) == 0 )
		*out = im->Bbits;
	else if( strcmp( field, "BandFmt" ) == 0 )
		*out = im->BandFmt;
	else if( strcmp( field, "Coding" ) == 0 )
		*out = im->Coding;
	else if( strcmp( field, "Type" ) == 0 )
		*out = im->Type;
	else if( strcmp( field, "Xoffset" ) == 0 )
		*out = im->Xoffset;
	else if( strcmp( field, "Yoffset" ) == 0 )
		*out = im->Yoffset;
	else {
		im_errormsg( "im_header_int: no such int field \"%s\"", field );
		return( -1 );
	}

	return( 0 );
}

int
im_header_double( IMAGE *im, const char *field, double *out )
{
	if( strcmp( field, "Xres" ) == 0 )
		*out = im->Xres;
	else if( strcmp( field, "Yres" ) == 0 )
		*out = im->Yres;
	else {
		im_errormsg( "im_header_double: no such double field "
			"\"%s\"", field );
		return( -1 );
	}

	return( 0 );
}

int
im_header_string( IMAGE *im, const char *field, char **out )
{
	if( strcmp( field, "Hist" ) == 0 && im->Hist )
		*out = im->Hist;
	else if( strcmp( field, "Hist" ) == 0 && !im->Hist )
		*out = "";
	else if( strcmp( field, "filename" ) == 0 )
		*out = im->filename;
	else {
		im_errormsg( "im_header_string: no such string field "
			"\"%s\"", field );
		return( -1 );
	}

	return( 0 );
}
