/* Manage pipelines of partial images.
 * 
 * J.Cupitt, 17/4/93.
 * 1/7/93 JC
 *	- adapted for partial v2
 * 9/5/94
 *	- new thread stuff added, with a define to turn it off
 * 21/11/94 JC
 *	- pw and ph wrong way round!
 * 24/5/95 JC
 *	- redone, now works in pipelines!
 * 30/8/96 JC
 *	- more sharing with im_generate()
 * 2/3/98 JC
 *	- IM_ANY added
 * 19/1/99 JC
 *	- oops, threads were broken :(
 * 30/7/99 RP JC
 *	- threads reorganised for POSIX
 * 25/10/03 JC
 *	- read via a buffer image so we work with mmap window images
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG_IO
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>

#include <vips/vips.h>
#include <vips/util.h>
#include <vips/list.h>
#include <vips/rect.h>
#include <vips/region.h>
#include <vips/thread.h>
#include <vips/threadgroup.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

static int
iterate( im_threadgroup_t *tg, IMAGE *im, 
	void *(*start)(), int (*generate)(), int (*stop)(), void *b, void *c )
{	
	int i;
	int res;

#ifdef DEBUG_IO
	if( tg && tg->nthr > 1 )
		im_diagnostics( "im_iterate: using %d threads", tg->nthr );
#endif /*DEBUG_IO*/

	/* Call all the start functions, and pop in the sequence values.
	 */
	for( i = 0; i < tg->nthr; i++ ) {
		if( start && !(tg->thr[i]->a = start( im, b, c )) ) {
			im_errormsg( "im_iterate: user start function "
				"failed for image \"%s\"", im->filename );
			return( -1 );
		}
		tg->thr[i]->b = b;
		tg->thr[i]->c = c;
	}

	/* Loop and generate multi-thread. 
	 */
	res = im__eval_to_image( tg, im );

	/* Call all stop functions.
	 */
	for( i = 0; i < tg->nthr; i++ ) {
		if( tg->thr[i]->a && stop ) {
			/* Trigger the stop function. 
			 */
			if( stop( tg->thr[i]->a, b, c ) )
				im_errormsg( "im_iterate: panic: user stop "
					"callback failed for image \"%s\"", 
					im->filename );
			tg->thr[i]->a = NULL;
		}
	}

	return( res );
}

/* Scan region over image in small pieces.
 */
int
im_iterate( IMAGE *im, 
	void *(*start)(), int (*generate)(), int (*stop)(), void *b, void *c )
{
	IMAGE *t;
	im_threadgroup_t *tg;
	int res;

	if( im_image_sanity( im ) )
		return( -1 );

	if( !(t = im_open( "im_iterate_buffer", "p" )) )
		return( -1 );
	if( im_copy( im, t ) ) {
		im_close( t );
		return( -1 );
	}

	if( !(tg = im_threadgroup_create( t )) ) {
		im_close( t );
		return( -1 );
	}
	tg->work = generate;
	tg->inplace = 0;

#ifdef DEBUG_IO
	if( tg && tg->nthr > 1 )
		im_diagnostics( "im_iterate: using %d threads", tg->nthr );
#endif /*DEBUG_IO*/

	res = iterate( tg, t, start, generate, stop, b, c );

	im_threadgroup_free( tg );
	im_close( t );

	return( res );
}
