/* Function dispatch tables for other.
 *
 * J. Cupitt, 8/2/95
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>

#include <vips/vips.h>
#include <vips/util.h>
#include <vips/dispatch.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Args for im_eye.
 */
static im_arg_desc eye_args[] = {
	IM_OUTPUT_IMAGE( "out" ),
	IM_INPUT_INT( "xsize" ),
	IM_INPUT_INT( "ysize" ),
	IM_INPUT_DOUBLE( "factor" )
};

/* Call im_eye via arg vector.
 */
static int
eye_vec( im_object *argv )
{
	int xsize = *((int *) argv[1]);
	int ysize = *((int *) argv[2]);
	double factor = *((double *) argv[3]);

	return( im_eye( argv[0], xsize, ysize, factor ) );
}

/* Description of im_eye.
 */ 
static im_function eye_desc = {
	"im_eye", 			/* Name */
	"generate IM_BANDFMT_UCHAR [0,255] frequency/amplitude image",
	0,				/* Flags */
	eye_vec, 			/* Dispatch function */
	IM_NUMBER( eye_args ), 		/* Size of arg list */
	eye_args 			/* Arg list */
};

/* Call im_feye via arg vector.
 */
static int
feye_vec( im_object *argv )
{
	int xsize = *((int *) argv[1]);
	int ysize = *((int *) argv[2]);
	double factor = *((double *) argv[3]);

	return( im_feye( argv[0], xsize, ysize, factor ) );
}

/* Description of im_feye.
 */ 
static im_function feye_desc = {
	"im_feye", 			/* Name */
	"generate IM_BANDFMT_FLOAT [-1,1] frequency/amplitude image",
	0,				/* Flags */
	feye_vec, 			/* Dispatch function */
	IM_NUMBER( eye_args ), 		/* Size of arg list */
	eye_args 			/* Arg list */
};

/* Args for im_zone.
 */
static im_arg_desc zone_args[] = {
	IM_OUTPUT_IMAGE( "out" ),
	IM_INPUT_INT( "size" )
};

/* Call im_zone via arg vector.
 */
static int
zone_vec( im_object *argv )
{
	int size = *((int *) argv[1]);

	return( im_zone( argv[0], size ) );
}

/* Description of im_zone.
 */ 
static im_function zone_desc = {
	"im_zone", 			/* Name */
	"generate IM_BANDFMT_UCHAR [0,255] zone plate image", /* Description */
	0,				/* Flags */
	zone_vec, 			/* Dispatch function */
	IM_NUMBER( zone_args ), 		/* Size of arg list */
	zone_args 			/* Arg list */
};

/* Call im_fzone via arg vector.
 */
static int
fzone_vec( im_object *argv )
{
	int size = *((int *) argv[1]);

	return( im_fzone( argv[0], size ) );
}

/* Description of im_fzone.
 */ 
static im_function fzone_desc = {
	"im_fzone", 			/* Name */
	"generate IM_BANDFMT_FLOAT [-1,1] zone plate image", /* Description */
	0,				/* Flags */
	fzone_vec, 			/* Dispatch function */
	IM_NUMBER( zone_args ), 		/* Size of arg list */
	zone_args 			/* Arg list */
};

/* Args for im_grey.
 */
static im_arg_desc grey_args[] = {
	IM_OUTPUT_IMAGE( "out" ),
	IM_INPUT_INT( "xsize" ),
	IM_INPUT_INT( "ysize" )
};

/* Call im_grey via arg vector.
 */
static int
grey_vec( im_object *argv )
{
	int xsize = *((int *) argv[1]);
	int ysize = *((int *) argv[2]);

	return( im_grey( argv[0], xsize, ysize ) );
}

/* Description of im_grey.
 */ 
static im_function grey_desc = {
	"im_grey", 			/* Name */
	"generate IM_BANDFMT_UCHAR [0,255] grey scale image", /* Description */
	0,				/* Flags */
	grey_vec, 			/* Dispatch function */
	IM_NUMBER( grey_args ), 		/* Size of arg list */
	grey_args 			/* Arg list */
};

/* Call im_fgrey via arg vector.
 */
static int
fgrey_vec( im_object *argv )
{
	int xsize = *((int *) argv[1]);
	int ysize = *((int *) argv[2]);

	return( im_fgrey( argv[0], xsize, ysize ) );
}

/* Description of im_fgrey.
 */ 
static im_function fgrey_desc = {
	"im_fgrey", 			/* Name */
	"generate IM_BANDFMT_FLOAT [0,1] grey scale image", /* Description */
	0,				/* Flags */
	fgrey_vec, 			/* Dispatch function */
	IM_NUMBER( grey_args ), 		/* Size of arg list */
	grey_args 			/* Arg list */
};

/* Package up all these functions.
 */
static im_function *other_list[] = {
	&eye_desc,
	&grey_desc,
	&feye_desc,
	&fgrey_desc,
	&fzone_desc,
	&zone_desc
};

/* Package of functions.
 */
im_package im__other = {
	"other",
	IM_NUMBER( other_list ),
	other_list
};
