/* modify vips file header! - useful for setting resolution, coding...
very dangerous!
no way of setting non-used codes in variables like newxres
so need flags to show new parameter has been set.. boring
Copyright K.Martinez 30/6/93
29/7/93 JC
	-format added
	- ==0 added to strcmp!
17/11/94 JC
	- new header fields added
*/

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <vips/vips.h>

int newbands = 0;
int bandsflag=0;
int newtype = 0;
int typeflag=0;
int newformat = 0;
int formatflag=0;
int newcoding=0;
int codingflag=0;
float newxres=0;
int xresflag=0;
float newyres=0;
int yresflag=0;
int newxsize=0;
int xsizeflag=0;
int newysize=0;
int ysizeflag=0;

int newcompression=0;
int compressionflag=0;
int newlength=0;
int lengthflag=0;
int newlevel=0;
int levelflag=0;

void usage()
{
	error_exit( "usage: edvips -flag value ... imagefile\n"
		"changes vips file header, where flags are:\n"
		"-xsize <int>      sets new x size\n"
		"-ysize <int>      sets new y size\n"
		"-bands <int>      sets new bands\n"
		"-xres <float>     sets new x resolution\n"
		"-yres <float>     sets new y resolution\n"
		"-type <string>    sets new type - eg. -type B_W\n"
		"-coding <string>  sets new coding - eg. -coding LABPACK\n"
		"-format <string>  sets new format and bbits - eg. -format FMTUCHAR\n" 
		"-compression <string>  sets new Compression - eg. -compression JPEG_COMPRESSION\n" 
		"-length <int>     sets new Length\n"
		"-level <int>      sets new compression Level" );
}

int
main(argc,argv)
int argc;
char **argv;
{
IMAGE *image;
VAS_HD *vashdr;
if((argc <4) )
	usage();

	argc--, argv++; /* argv[0] is now first arg */
	for (; argc > 2 && argv[0][0] == '-'; argc--, argv++)
		if (strcmp(argv[0], "-xsize") == 0) {
			argc--, argv++;
			newxsize = atof(argv[0]);
			xsizeflag = 1;
		}
		else if (strcmp(argv[0], "-ysize") == 0) {
			argc--, argv++;
			newysize = atoi(argv[0]);
			ysizeflag = 1;
		}
		else if (strcmp(argv[0], "-bands") == 0) {
			argc--, argv++;
			newbands = atoi(argv[0]);
			bandsflag = 1;
		}
		else if (strcmp(argv[0], "-xres") == 0) {
			argc--, argv++;
			newxres = (float)atof(argv[0]);
			xresflag = 1;
		}
		else if (strcmp(argv[0], "-yres") == 0) {
			argc--, argv++;
			newyres = (float)atof(argv[0]);
			yresflag=1;
		}
		else if (strcmp(argv[0], "-type") == 0) {
			argc--, argv++;
			if( (newtype = im_char2Type(argv[0])) < 0 ) 
				usage();
			typeflag=1;
		}
		else if (strcmp(argv[0], "-format") == 0) {
			argc--, argv++;
			if( (newformat = im_char2BandFmt(argv[0])) < 0 )
				usage();
			formatflag=1;
		}
		else if (strcmp(argv[0], "-coding") == 0) {
			argc--, argv++;
			if( (newcoding = im_char2Coding(argv[0])) < 0 )
				usage();
			codingflag=1;
		}
		else if (strcmp(argv[0], "-compression") == 0) {
			argc--, argv++;
			if( (newcompression = im_char2Compression(argv[0])) < 0 )
				usage();
			compressionflag=1;
		}
		else if (strcmp(argv[0], "-level") == 0) {
			argc--, argv++;
			newlevel = atoi(argv[0]);
			levelflag=1;
		}
		else if (strcmp(argv[0], "-length") == 0) {
			argc--, argv++;
			newlength = atoi(argv[0]);
			lengthflag=1;
		}
		else
			usage();

if( !(image = im_open(argv[0],"rw") ) )
	error_exit("could not open image %s\n",argv[0]);

vashdr = (VAS_HD*)image->baseaddr;
if(xsizeflag)
	vashdr->Xsize = newxsize;
if(ysizeflag)
	vashdr->Ysize = newysize;
if(xresflag)
	vashdr->Xres = newxres;
if(yresflag)
	vashdr->Yres = newyres;
if(codingflag)
	vashdr->Coding = newcoding;
if(typeflag)
	vashdr->Type = newtype;
if(formatflag) {
	static int bbits_array[] = {
		IM_BBITS_BYTE, IM_BBITS_BYTE, IM_BBITS_SHORT, IM_BBITS_SHORT,
		IM_BBITS_INT, IM_BBITS_INT, IM_BBITS_FLOAT, IM_BBITS_COMPLEX, 
		IM_BBITS_DOUBLE, IM_BBITS_DPCOMPLEX
	};
	vashdr->BandFmt = newformat;

	/* Set Bbits too.
	 */
	vashdr->Bbits = bbits_array[ newformat ];
}
if(bandsflag)
	vashdr->Bands = newbands;
if(levelflag)
	vashdr->Level = newlevel;
if(compressionflag)
	vashdr->Compression = newcompression;
if(lengthflag)
	vashdr->Length = newlength;

im_close(image);

return(0);
}

