/*
 * This file is part of Soprano Project
 *
 * Copyright (C) 2009-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _VIRTUOSO_CONVERTER_ISQL_H_
#define _VIRTUOSO_CONVERTER_ISQL_H_

#include <QtCore/QObject>

#include <KProcess>
#include <KTemporaryFile>


class ISql : public QObject
{
    Q_OBJECT

public:
    ISql( QObject* parent = 0 );
    ~ISql();

    static ISql* fireAndForgetCommand( int port, const QString& command );

public Q_SLOTS:
    void executeCommand( int port, const QString& s );

Q_SIGNALS:
    void finished( bool success );

private Q_SLOTS:
    void slotProcessFinished( int exitCode, QProcess::ExitStatus exitStatus );

private:
    bool m_deleteSelf;
    KProcess m_process;
    int m_port;
    KTemporaryFile* m_tmpFile;
};

#endif
