/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* autoexec.sql */

static const char *proc0 = 
"create procedure DB.DBA.ddl_load_script (in _filename varchar)\n"
"{\n"
"declare cnt, parts, errors any;\n"
"cnt := file_to_string (_filename);\n"
"parts := sql_split_text (cnt);\n"
"foreach (varchar s in parts) do\n"
"{\n"
"declare stat, msg any;\n"
"stat := \'00000\';\n"
"exec (s, stat, msg);\n"
"if (stat <> \'00000\')\n"
"{\n"
"log_message (sprintf (\'Error in autoexec.isql: [%s] %s\', stat, msg));\n"
"rollback work;\n"
"}\n"
"else\n"
"{\n"
"commit work;\n"
"}\n"
"}\n"
"}\n"
"--src autoexec.sql:23\n";

static const char *proc1 = 
"create procedure DB.DBA.ddl_load_script_safe (in _filename varchar)\n"
"{\n"
"declare _status, _message varchar;\n"
"_status := \'\';\n"
"_message := \'OK\';\n"
"if (not file_stat (_filename))\n"
"return;\n"
"exec (concat (\'DB.DBA.ddl_load_script (\', WS.WS.STR_SQL_APOS(_filename), \')\'), _status, _message);\n"
"if (_message<>\'OK\')\n"
"{\n"
"dbg_printf (\'\\nError on loading file \\\'%s\\\'\', _filename );\n"
"dbg_printf (\'Status returned: %s %s\', _status, _message);\n"
"}\n"
"}\n"
"--src autoexec.sql:46\n";

static const char *proc2 = 
"create procedure ddl_autoexec (in _filename varchar)\n"
"{\n"
"if (_filename = \'\')\n"
"_filename := \'autoexec.isql\';\n"
"\n"
"DB.DBA.ddl_load_script_safe (_filename);\n"
"}\n"
"--src autoexec.sql:62\n";


static const char *other0 = 
" DB.DBA.DAV_AUTO_REPLICATE_TO_RDF_QUAD ()\n";

static const char *other1 = 
" VAD.DBA.VAD_AUTO_UPGRADE ()\n";

static const char *other2 = 
" ddl_autoexec (\'\')\n";
static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_auto (void)
{
  /* autoexec.sql */

  DEFINE_PROC ("DB.DBA.ddl_load_script", proc0);
  DEFINE_PROC ("DB.DBA.ddl_load_script_safe", proc1);
  DEFINE_PROC ("ddl_autoexec", proc2);
}


void
sqls_arfw_define_auto (void)
{
  /* ./autoexec.sql */

  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("do this always", other2);
}
