/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
#include "help.hpp"

Help::Help() : QWidget() {
    setFixedSize(QSize(350, 600));
    setWindowTitle("ViTE help");
    QIcon icon;
    icon.addPixmap(QPixmap(QString::fromUtf8(":icon/icon/vite.png")), QIcon::Normal, QIcon::Off);
    setWindowIcon(icon);
    _contenu = new QWidget(this);
    _contenu->setFixedSize(QSize(350,570));
    _image = new QLabel(_contenu);
    _image->setPixmap(QPixmap(QString::fromUtf8(":img/img/help.png")));
    _text = new QTextEdit("", _contenu);
    _cancel = new QPushButton("&Cancel", this);
    
    _text->setHtml("<center><h1>Quick Help</h1></center>"
                   "<h2>Menu <em>File</em></h2>"
                   "<dl>"
                   "<dt><strong>Open a file</strong></dt>"
                   "<dd>menu <em>File</em> then <em>Open</em> (shortcut: ctrl + o)</dd>"
                   "<dt><strong>Export a file</strong></dt>"
                   "<dd>menu <em>File</em> then <em>Export</em> (shortcut: ctrl + e)</dd>"
                   "<dt><strong>Close a file</strong></dt>"
                   "<dd>menu <em>File</em> then <em>Close</em> (shortcut: ctrl + w)</dd>"
                   "<dt><strong>Quit ViTE</strong></dt>"
                   "<dd>menu <em>File</em> then <em>Quit</em> (shortcut: ctrl + q)</dd>"
                   "</dl>"
                   "<h2>Menu <em>View</em></h2>"
                   "<dl>"
                   "<dt><strong>Display/Hide the informations window</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Show infos window</em></dd>"
                   "<dt><strong>Display/Hide the toolbar</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Show/Hide toolbar</i</dd>"
                   "<dt><strong>Zoom in the trace</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Zoom in</em> (shortcut: +)</dd>"
                   "<dt><strong>Zoom out of the trace</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Zoom out</em> (shortcut: -)</dd>"
                   "<dt><strong>Show all the trace</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Show all</em> (shortcut: ctrl + shift + A)</dd>"
                   "<dt><strong>Move to the beginning of the trace</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Move to start</em> (shortcut: Home)</dd>"
                   "<dt><strong>Move to the end of the trace</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Move to end</em> (shortcut: End)</dd>"
                   "<dt><strong>Switch to fullscreen mode</strong></dt>"
                   "<dd>menu <em>View</em> then <em>Fullscreen</em> (shortcut: F11)</dd>"
                   "<dt><strong>Display/Hide the warnings and errors</strong></dt>"
                   "<dd>menu <em>View</em> then <em>No warning</em></dd>"
                   "<dt><strong>Display/Hide the arrows</strong></dt>"
                   "<dd>menu <em>View</em> then <em>No arrows</em></dd>"
                   "<dt><strong>Display/Hide the events</strong></dt>"
                   "<dd>menu <em>View</em> then <em>No events</em></dd>"
                   "</dl>"
                   "<h2>Menu <em>Help</em></h2>"
                   "<dl>"
                   "<dt><strong>Show the quick help</strong></dt>"
                   "<dd>menu <em>Help</em> then <em>Help</em> (shortcut: F1)</dd>"
                   "<dt><strong>Informations about ViTE software</strong></dt>"
                   "<dd>menu <em>Help</em> then <em>About</em></dd>"
                   "</dl>"
                   "<h2>More help</h2>"
                   "<p>You can find more informations about the functions and the options of ViTE on the user manual.</p>");
    _text->resize(350, 199);
    _text->setReadOnly(true);
    _image->move(0,199);
    _cancel->move(250, 570);
    QObject::connect(_cancel, SIGNAL(clicked()), this, SLOT(close()));
}

Help::~Help(){
    delete _contenu;
    delete _image;
    delete _text;
    delete _cancel;
}
