/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
#include "Definition.hpp"

using namespace std;

Definition::Definition(){
    _event_name.erase();
}

Definition::Definition(string& eventname){
    _event_name = eventname;
}


void Definition::store(string name, string type){
    Field e;

    e._name = name;
    e._type = type;
    _fields.push_back(e);
}

void Definition::print() const{
    cout << _event_name << endl;

    const unsigned int field_size = _fields.size();
    for(unsigned int i = 0 ; i < field_size ; i ++){
	cout << " " << _fields[i]._name << " " << _fields[i]._type << endl;
    }
    cout << "______" << endl;
}

string Definition::print_string() const{
    string definition = _event_name;

    const unsigned int field_size = _fields.size();
    for(unsigned int i = 0 ; i < field_size ; i ++){
	definition += "\n";
        definition += _fields[i]._name;
        definition += " ";
        definition += _fields[i]._type;
    }
    definition += "\n";
    return definition;
}

const vector<Field> &Definition::get_fields() const{
    return _fields;
}

string Definition::get_event_name() const{
    return _event_name;
}

bool Definition::check_definition() const{
    const unsigned int number_of_fields = _fields.size();

    // Name - string or integer
    // ContainerType - string or integer
    // Alias - string or integer
    if(_event_name == "PajeDefineContainerType" || _event_name == "PajeDefineEventType" || _event_name == "PajeDefineStateType" || _event_name == "PajeDefineVariableType"){
        bool has_name_or_alias = false;
        bool has_container_type = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if((_fields[i]._name == "Name" || _fields[i]._name == "Alias") && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_name_or_alias = true;
            }
            // We check if we have the ContainerType
            else if(_fields[i]._name == "ContainerType" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_container_type = true;
            }
            // We return true if we have the compulsory fields and we don't care of others
            if(has_name_or_alias && has_container_type){
                return true;
            }
        }
    }
    // Time - date, Name - string or integer, Type - string or integer,
    // Container - string or integer, Alias - string or integer
    else if(_event_name == "PajeCreateContainer"){
        bool has_name_or_alias = false;
        bool has_time = false;
        bool has_type = false;
        bool has_container = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if((_fields[i]._name == "Name" || _fields[i]._name == "Alias") && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_name_or_alias = true;
            }
            // We check if we have the container
            else if(_fields[i]._name == "Container" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_container = true;
            }
            // We check if we have the time
            else if(_fields[i]._name == "Time" && _fields[i]._type == "date"){
                has_time = true;
            }
            // We check if we have the type
            else if(_fields[i]._name == "Type" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_type = true;
            }
            // We return true if we have the compulsory fields and we don't care of others
            if(has_name_or_alias && has_container && has_time && has_type){
                return true;
            }
        }
    }
    // Time - date, Name - string or integer
    // Type - string or integer
    else if(_event_name == "PajeDestroyContainer"){
        bool has_name_or_alias = false;
        bool has_time = false;
        bool has_type = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if((_fields[i]._name == "Name" || _fields[i]._name == "Alias") && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_name_or_alias = true;
            }
            // We check if we have the time
            else if(_fields[i]._name == "Time" && _fields[i]._type == "date"){
                has_time = true;
            }
            // We check if we have the type
            else if(_fields[i]._name == "Type" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_type = true;
            }
            // We return true if we have the compulsory fields and we don't care of others
            if(has_name_or_alias && has_time && has_type){
                return true;
            }
        }
    }
    // Name - string or integer, ContainerType - string or integer
    // SourceContainerType - string or integer, DestContainerType - string or integer
    // Alias - string or integer
    else if(_event_name == "PajeDefineLinkType"){
        bool has_name_or_alias = false;
        bool has_ContainerType = false;
        bool has_SourceContainerType = false;
        bool has_DestContainerType = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if((_fields[i]._name == "Name" || _fields[i]._name == "Alias") && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_name_or_alias = true;
            }
            // We check if we have the ContainerType
            else if(_fields[i]._name == "ContainerType" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_ContainerType = true;
            }
            // We check if we have the SourceContainerType
            else if(_fields[i]._name == "SourceContainerType" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_SourceContainerType = true;
            }
            // We check if we have the DestContainerType
            else if(_fields[i]._name == "DestContainerType" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_DestContainerType = true;
            }
            // We return true if we have the compulsory fields and we don't care of others
            if(has_name_or_alias && has_ContainerType && has_SourceContainerType && has_DestContainerType){
                return true;
            }
        }
    }
    // Name - string or integer, EntityType - string or integer, Alias - string or integer
    else if(_event_name == "PajeDefineEntityValue"){
        bool has_name_or_alias = false;
        bool has_EntityType = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if((_fields[i]._name == "Name" || _fields[i]._name == "Alias") && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_name_or_alias = true;
            }
            // We check if we have the time
            else if(_fields[i]._name == "EntityType" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_EntityType = true;
            }
            // We return true if we have the compulsory fields and we don't care of others
            if(has_name_or_alias && has_EntityType){
                return true;
            }
        }
    }
    // Time - date, Type - string or integer, Container - string or integer, Value - string or integer
    else if(_event_name == "PajeSetState" || _event_name == "PajePushState" ||
            _event_name == "PajeNewEvent"){
        bool has_Container = false;
        bool has_time = false;
        bool has_Value = false;
        bool has_type = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if(_fields[i]._name == "Container" &&
               (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_Container = true;
            }
            // We check if we have the time
            else if(_fields[i]._name == "Time" && _fields[i]._type == "date"){
                has_time = true;
            }
            // We check if we have the type
            else if(_fields[i]._name == "Type" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_type = true;
            }
            // We check if we have the value
            else if(_fields[i]._name == "Value" && (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_Value = true;
            }            // We return true if we have the compulsory fields and we don't care of others
            if(has_Container && has_time && has_type && has_Value){
                return true;
            }
        }
    }
    // Time - date, Type - string or integer, Container - string or integer
    else if(_event_name == "PajePopState"){
        bool has_Container = false;
        bool has_time = false;
        bool has_type = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the time
            if(_fields[i]._name == "Time" && _fields[i]._type == "date"){
                has_time = true;
            }
            // We check if we have the type
            else if(_fields[i]._name == "Type" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_type = true;
            }
            // We check if we have the value
            else if(_fields[i]._name == "Container" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_Container = true;
            }            // We return true if we have the compulsory fields and we don't care of others
            if(has_Container && has_time && has_type){
                return true;
            }
        }
    }
    // Time - date, Type - string or integer, Container - string or integer, Value - double
    else if(_event_name == "PajeSetVariable" || _event_name == "PajeAddVariable" ||
            _event_name == "PajeSubVariable"){
        bool has_Container = false;
        bool has_time = false;
        bool has_Value = false;
        bool has_type = false;
        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if(_fields[i]._name == "Container" &&
               (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_Container = true;
            }
            // We check if we have the time
            else if(_fields[i]._name == "Time" && _fields[i]._type == "date"){
                has_time = true;
            }
            // We check if we have the type
            else if(_fields[i]._name == "Type" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_type = true;
            }
            // We check if we have the value
            else if(_fields[i]._name == "Value" && _fields[i]._type == "double"){
                has_Value = true;
            }            // We return true if we have the compulsory fields and we don't care of others
            if(has_Container && has_time && has_type && has_Value){
                return true;
            }
        }
    }
    // Container - string or integer, Time - date, Type - string or integer
    // SourceContainer - string or integer, Value - string or integer, Key - string or integer
    else if(_event_name == "PajeStartLink"){
        bool has_Container = false;
        bool has_time = false;
        bool has_type = false;
        bool has_Value = false;
        bool has_key = false;
        bool has_SourceContainer = false;

        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if(_fields[i]._name == "Container" &&
               (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_Container = true;
            }
            // We check if we have the time
            else if(_fields[i]._name == "Time" && _fields[i]._type == "date"){
                has_time = true;
            }
            // We check if we have the type
            else if(_fields[i]._name == "Type" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_type = true;
            }
            // We check if we have the key
            else if(_fields[i]._name == "Key" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_key = true;
            }
            // We check if we have the SourceContainer
            else if(_fields[i]._name == "SourceContainer" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_SourceContainer = true;
            }
            // We check if we have the value
            else if(_fields[i]._name == "Value" && 
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_Value = true;
            }            // We return true if we have the compulsory fields and we don't care of others
            if(has_Container && has_time && has_type && has_Value && has_key && has_SourceContainer){
                return true;
            }
        }
    }
    // Container - string or integer, Time - date, Type - string or integer
    // DestContainer - string or integer, Value - string or integer, Key - string or integer
    else if(_event_name == "PajeEndLink"){
        bool has_Container = false;
        bool has_time = false;
        bool has_type = false;
        bool has_Value = false;
        bool has_key = false;
        bool has_DestContainer = false;

        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the name or the alias
            if(_fields[i]._name == "Container" &&
               (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_Container = true;
            }
            // We check if we have the time
            else if(_fields[i]._name == "Time" && _fields[i]._type == "date"){
                has_time = true;
            }
            // We check if we have the type
            else if(_fields[i]._name == "Type" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_type = true;
            }
            // We check if we have the key
            else if(_fields[i]._name == "Key" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_key = true;
            }
            // We check if we have the SourceContainer
            else if(_fields[i]._name == "DestContainer" &&
                    (_fields[i]._type == "string"|| _fields[i]._type == "int")){
                has_DestContainer = true;
            }
            // We check if we have the value
            else if(_fields[i]._name == "Value" && 
                    (_fields[i]._type == "string" || _fields[i]._type == "int")){
                has_Value = true;
            }            // We return true if we have the compulsory fields and we don't care of others
            if(has_Container && has_time && has_type && has_Value && has_key && has_DestContainer){
                return true;
            }
        }
    }
    else{
        return false;
    }
    return false;
}
