/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file Definition.hpp
 *\brief This file contains the definition during decoding the trace file.
 */

#ifndef DEFINITION_HPP
#define DEFINITION_HPP


#include <vector>
#include <iostream>
#include <string>

/*! \struct Field Definition.hpp "../parser/Definition.hpp"
 *  \brief Contains the name and the type of a definition element.
 */
struct Field{
    /*!
     *  \brief Contains the name of a definition element.
     */
    std::string _name;
    /*!
     *  \brief Contains the type of a definition element.
     */
    std::string _type;
};


/*! \class Definition Definition.hpp "../parser/Definition.hpp"
 *  \brief Contains the definition of a definition.
 */

class Definition{

private:

    std::vector<Field> _fields;
    std::string _event_name;

    /*!
     * \fn is_valid_type(const std::string &type_name) const
     * \brief Check if the type_name is a real type.
     * \param type_name the name we want to check.
     * \return true if the type exists.
     */
    bool is_valid_type(const std::string &type_name) const;

public:

    /*!
     * \fn Definition()
     * \brief : constructor
     * \param : string event name
     *
     */
    Definition();

    /*!
     * \fn Definition(std::string &eventname)
     * \brief constructor
     *  \param eventname : the name of the new Definition
     */
    Definition(std::string &eventname);

    /*!
     * \fn store(std::string name, std::string type)
     * \brief : add a field to definition
     *  \param name : the name of the event
     *  \param type : the type of the event
     */
    void store(std::string name, std::string type);

    /*!
     * \fn print() const
     * \brief display the definitions
     *
     */
    void print() const;

    /*!
     * \fn print_string() const
     * \brief display the definitions in a string
     * \return the string with informations about the definition
     */
    std::string print_string() const;

    /*!
     * \fn : get_fields() const
     * \brief : get_fields() : return the vector _fields
     */
    const std::vector<Field> &get_fields() const;

    /*!
     * \fn : get_event_name() const
     * \return the string _event_name
     *
     */
    std::string get_event_name() const;

    /*! \fn check_definition() const
     * \brief Check if the definition stored is correct.
     * \return true if the definition is correct.
     */
    bool check_definition() const;
};

#endif // DEFINITION_HPP

