/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file ParserDefinitionDecoder.hpp
 */

#ifndef PARSERDEFINITIONDECODER_HPP
#define PARSERDEFINITIONDECODER_HPP

#include <iostream>
#include <fstream>
#include <map>

#include "Definition.hpp"
#include "Line.hpp"

#ifndef VITE_DEBUG
  #include "../message/Errors.hpp"
#else
// For debugging
  #include "../../tests/stubs/Errors.hpp"
#endif

/*!
 *
 * \class ParserDefinitionDecoder
 * \brief Parse the definitions of the trace and stock them.
 *
 */
class ParserDefinitionDecoder{

    /**
     * Reads line to find events definition
     *
     */

private:
    /*! \brief Hash table to retrive easily event in Parser Event. */
    std::map<unsigned int, Definition> _definitions;
    int _state;
    unsigned int _current_definition;
    static const int _OUT_A_DEFINITION;
    static const int _IN_A_DEFINITION;

public:
    /*!
     * \fn ParserDefinitionDecoder
     * \brief constructor
     */
    ParserDefinitionDecoder();

    /*!
     *  \fn definitions_number
     *  \return : the number of definitions in the map
     */
    int definitions_number();

    /*!
     *  \fn store_definition(Line &)
     *  \param l the line to store.
     */
    void store_definition(Line &l);

    /*!
     *  \fn get_definition(unsigned int i)
     *  \param i : the unsigned integer matching the definition we want
     *  \return : the i-th definition
     */
    Definition &get_definition(unsigned int i);

    /*!
     *  \fn get_hash_table_of_definitions
     *  \return : the hash table of definitions
     */
    std::map<unsigned int,Definition> *get_hash_table_of_definitions();

    /*!
     *  \fn enter_definition(Line &line)
     *  \param line line
     */
    void enter_definition(Line &line);
 
    /*!
     *  \fn leave_definition(Line&line)
     *  \param line
     */
    void leave_definition(Line &line);

    /*!
     *  \fn add_field_to_definition(std::string& first_token, Line& line)
     *  \param first_token : the name of the file to parse
     *  \param line : the structure of data to fill
     */
    void add_field_to_definition(std::string& first_token, Line& line);

    /*! \fn print_definitions
     * \brief Print all the definitions. Useful for debug.
     */
    void print_definitions();

};

#endif // PARSERDEFINITIONDECODER_HPP
