#
# Find the OTF libraries and include dir
#

# OTF_INCLUDE_DIR  - Directories to include to use OTF
# OTF_LIBRARY    - Files to link against to use OTF
# OTF_FOUND        - When false, don't try to use OTF
#
# OTF_DIR can be used to make it simpler to find the various include
# directories and compiled libraries when OTF was not installed in the
# usual/well-known directories (e.g. because you made an in tree-source
# compilation or because you installed it in an "unusual" directory).
# Just set OTF_DIR it to your specific installation directory
#
FIND_LIBRARY(OTF_LIBRARY otf
  PATHS
  /usr/lib
  /usr/local/lib
  ${OTF_DIR}/lib
)

IF(OTF_LIBRARY)
  GET_FILENAME_COMPONENT(OTF_GUESSED_INCLUDE_DIR_tmp "${OTF_LIBRARY}" PATH)
  STRING(REGEX REPLACE "lib$" "include" OTF_GUESSED_INCLUDE_DIR "${OTF_GUESSED_INCLUDE_DIR_tmp}")
ENDIF(OTF_LIBRARY)

FIND_PATH( OTF_INCLUDE_DIR otf.h
  PATHS
  ${OTF_GUESSED_INCLUDE_DIR}
  ${OTF_DIR}/include
  /usr/include
  /usr/local/include
  ../externals/otf/otflib/
)


IF( OTF_INCLUDE_DIR )
  IF( OTF_LIBRARY )
    SET( OTF_FOUND "YES" )
    MARK_AS_ADVANCED( OTF_DIR )
    MARK_AS_ADVANCED( OTF_INCLUDE_DIR )
    MARK_AS_ADVANCED( OTF_LIBRARY )
  ENDIF( OTF_LIBRARY )
ENDIF( OTF_INCLUDE_DIR )



IF( NOT OTF_FOUND )
  MESSAGE("OTF installation was not found. Please provide OTF_DIR:")
  MESSAGE("  - through the GUI when working with ccmake, ")
  MESSAGE("  - as a command line argument when working with cmake e.g. ")
  MESSAGE("    cmake .. -DOTF_DIR:PATH=/usr/local/otf ")
  MESSAGE("Note: the following message is triggered by cmake on the first ")
  MESSAGE("    undefined necessary PATH variable (e.g. OTF_INCLUDE_DIR).")
  MESSAGE("    Providing OTF_DIR (as above described) is probably the")
  MESSAGE("    simplest solution unless you have a really customized/odd")
  MESSAGE("    OTF installation...")
  SET(OTF_DIR "" CACHE PATH "Root of OTF install tree." )
ENDIF( NOT OTF_FOUND )
