/*
 *	VME Linux/m68k Loader
 *
 *	(c) Copyright 1997 by Nick Holgate
 *
 *	This file is subject to the terms and conditions of the GNU General Public
 *	License.  See the file COPYING for more details.
 */

/*--------------------------------------------------------------------------*/

.equ	BVMBugEntry,	0xf8000404	| BVMBug entry address
.equ	loader,			0x10000		| address to store linux loader

/*--------------------------------------------------------------------------*/
/*  BVME Initial Program Loader
 */

.text
	movem.l	%d0-%d7/%a0-%a6,-(%a7)	| save registers
start:
	movea.l	#BVMBugEntry,%a5		| get BVMBug entry address

	moveq	#13,%d0					| disk open
	jsr		(%a5)
	tst.l	%d0						| disk error?
	bne.s	error					| yes, report it

	lea.l	fraglist(%pc),%a6		| get address of fragment list

	movea.l	#loader,%a0				| destination address
main.loop:
	moveq	#0,%d1					| make sure high word is zero
	move.w	(%a6)+,%d1				| get number of blocks
	beq.s	done					| branch if end of list

	move.l	(%a6)+,%d2				| get disk block number
	bne.s	disk.read				| if not a hole, go read disk

	lsl.w	#7,%d1					| convert 512 byte sectors to long words
	bra.s	clear.loop.test			| enter clear memory loop

clear.loop:
	move.l	%d2,(%a0)+				| clear long word
clear.loop.test:
	dbra	%d1,clear.loop			| until all cleared
	bra.s	main.loop				| back for next fragment

disk.read:
	moveq	#14,%d0					| disk read
	jsr		(%a5)
	tst.l	%d0						| disk error?
	bne.s	error					| yes, report it
	lsl.w	#7,%d1					| convert 512 byte sectors to long words
	lea.l	(%a0,%d1.w*4),%a0		| update memory pointer

	bra.s	main.loop				| back for next fragment

done:
	move.l	%a7,-(%a7)				| pass pointer to stacked registers
	jsr		loader					| call loader

error:
	lea		errmsg(%pc),%a0			| get pointer to error message
	moveq	#1,%d0					| print string
	jsr		(%a5)
	moveq	#22,%d0					| enter BVMBug
	jsr		(%a5)
	bra.s	start					| try again if 'go' from BVMBug

errmsg:
.asciz	"\n\nDisk read error\n\n"

.align 2
fraglist:

/*-----------------------------< end of file >------------------------------*/
