/****************************************************************************
 *                             VREL COMPONENTS                              *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

#ifndef CONSTRUCTOR_H
#define CONSTRUCTOR_H

#include "decllist.h"
#include "instlist.h"
#include "envvar.h"
#include "datalist.h"
#include "envobject.h"
#include "namelist.h"

/**
 * class Constructeur for compound
 */
class Constructeur
{
 private:
  
  Instruction_liste * instr;       ///< liste des instructions du constructeur
  Environnement_var * argument;    ///< liste des arguments
  Environnement_objets * envobj;   ///< environnement local d'objets.
  Environnement_var * declfixe ;   ///< variables initiales locales.

 public:

  int nb_arguments;                ///< nb d'arguments
  Environnement_var * decl ;       ///< variables locales au constructeur.

  Constructeur(Nom_liste *,Declaration_var_liste *,  Instruction_liste *); 

  virtual ~Constructeur() {};

  void exec(Data_liste *);
  /**<
   * - 1. Affecter les variables en arguments
   * - 2. Charger les variables en arguments 
   * - 3. Excuter les instructions
   * - 4. Sauver l'environnement courant
   */
};

#endif
