/****************************************************************************
 *                             VREL COMPONENTS                              *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

#ifndef ENVVAR_H
#define ENVVAR_H

#include "data.h"

/**
 * class environnement for variables
 */
class Environnement_var
{
 public:

  char nom[256][30];  ///< Tableau des noms de variables.
  Data** donnee;      ///< Tableau des data associes.
  int count;          ///< (count-1) = nombre de variables dclares.

  Environnement_var(); ///< initialisation des tableaux et du compteur.

  int parcours(char *);
  // Parcours la liste chaine des variables existantes et renvoie l'index
  // sur cette variable si la variable existe dj. Sinon, renvoie 0.

  void declaration(char*);
  // Ajouter une variable dans le tableau de nom.

  void declaration(char *, float);
  // Ajouter une variable dans le tableau de nom et l'affecter  un nombre.
  
  void declaration(char *, char *);
  // Ajouter une variable dans le tableau de nom et l'affecter  une chaine.

  int affectation (char *, Data*);
  // Mthode d'affectation; la data sera d'abord value (mthode get_data).

  int affectation2 (char *, Data*);
  // Mthode d'affectation sans evaluation (ie la data peut etre un pointeur 
  // sur un objet de type Variable).
  
  Data* eval(char *);
  // Fonction qui renvoie la valeur d'une variable.

  virtual ~Environnement_var();		///< Destructeur

};

#endif
