/****************************************************************************
 *                             VREL	                                    *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

#include "vrel.h"
#include "program.h"
#include "envobject.h"
#include "envclass.h"
#include "envvar.h"
#include "tabvar.h"
#include "tabobj.h"


extern FILE *yyin;     // fichier source (.vrel)
extern FILE *yyout;    // fichier de configuration vreng (.vre)
extern int yyparse(void); // parseur cr par bison


char vrelfile[100];	// fichier lu courant
int comptfichier;	// numero de fichier ouvert
FILE * tabyyin[20];	// tableau mmorisant le pointeur sur le fichier ouvert 
int tablinenumber[20];	// tableau mmorisant le numro de ligne dans ce fichier
char tabvrelfile[20][100]; // tableau contenant les noms de fichiers

Programme *prog;	// Pointeur sur le programme

Environnement_var * varlocal = new Environnement_var();
// Pointeur sur les variables locales.
Environnement_var * varglobal = new Environnement_var();
// Pointeur sur les variables globales.
Environnement_var * attribut = new Environnement_var();
// Pointeur sur les attributs de la classe courante.
Environnement_classe * mere = new Environnement_classe(); 
// Tableau des classes.
Environnement_objets * pere = new Environnement_objets(); 
// Tableau des objets crees.
Tabvar * tableauvar  = new Tabvar();
// Tableau des environnements de variables.
Tabobj * tableauobj  = new Tabobj();
// Tableau des environnements d'objets.


int main(int argc, char *argv[]) 
{
  if (argc == 1) {
    printf("Usage: %s inputfile [outputfile]\n", argv[0]);
    exit(1);
  }
  if ((yyin = fopen(argv[1], "r")) == NULL) {
    perror(argv[1]); 
    exit(1); 
  }
  if (argc == 3) {
    if ((yyout = fopen(argv[2], "w")) == NULL) {
      perror(argv[2]); 
      yyout = stdout;
    }
  }
  else
    yyout = stdout;
  
  strcpy(vrelfile, argv[1]);
  comptfichier = 0;

  // Parsing and translation
  yyparse();
  prog->exec();
  fprintf(yyout, "</vre>\n");
  
  fclose(yyin);
  fclose(yyout);
  printf("vrel done\n");
}
