# vsdump: test program to dump and parse content of vsd file
#
# Copyright (C) 2006-2007	Valek Filippov (frob@df.ru)
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 3 or later of the GNU General Public
# License as published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
# USA
import vsdoc
import struct
import tree
import math
import cmd

chunktype = {0x0c:'ForeignData',\
                      0x0d:'OLE_Info',\
                      0x0e: 'Text IX',\
                      0x10:'Data1',\
                      0x11:'Data2',\
                      0x12:'Data3',\
                      0x15:'Page',\
                      0x18:'FontFaces',\
                      0x19:'FontFace',\
                      0x1a:'Styles',\
                      0x1f:'OLE_Data',\
                      0x46:'PageSheet',\
                      0x47:'ShapeType="Group"',\
                      0x48:'ShapeType="Shape"',\
                      0x4a:'StyleSheet',\
                      0x4d:'ShapeType="Gude"',\
                      0x4e:'ShapeType="Foreign"',\
                      0x4f:'DocSheet',\
                      0x84:'Event',\
                      0x85:'Line',
                      0x86:'Fill',\
                      0x87:'TextBlock',\
                      0x88:'Tabs Data',\
                      0x8a:'MoveTo',\
                      0x8b:'LineTo',\
                      0x8c:'ArcTo',\
                      0x8d:'InfiniteLine',\
                      0x8f:'Ellipse',\
                      0x90:'EllipticalArcTo',\
                      0x92:'PageProps',\
                      0x93:'StyleProps',\
                      0x94:'Char IX',\
                      0x95:'ParaIX',\
                      0x96:'Tabs Data',\
                      0x97:'Tabs Data',\
                      0x98:'Foreign?',\
                      0x99:'ConnectionPoints',\
                      0x9b:'XForm',\
                      0x9c:'TextXForm',\
                      0x9d:'XForm1D',\
                      0x9e:'Scratch',\
                      0xa0:'Protection',\
                      0xa1:'TextFields',\
                      0xa2:'Control',\
                      0xa3:'Help',\
                      0xa4:'Misc',\
                      0xa5:'SplineStart',\
                      0xa6:'SplineKnot',\
                      0xa7:'LayerMem',\
                      0xa8:'LayerIX',\
                      0xa9:'Act ID',\
                      0xaa:'Control',\
                      0xb4:'User-defined',\
                      0xb5:'Tabs Data',\
                      0xb6:'CustomProps',\
                      0xb7:'RulerGrid',\
                      0xb9:'ConnectionPoints',\
                      0xba:'ConnectionPoints',\
                      0xbb:'ConnectionPoints',\
                      0xbd:'Image',\
                      0xbe:'Group',\
                      0xbf:'Layout',\
                      0xc0:'PageLayout',\
                      0xc1:'PolylineTo',\
                      0xc3:'NURBSTo',\
                      0xc4:'Hyperlink',\
                      0xc5:'Reviewer',\
                      0xc6:'Annotation',\
                      0xc7:'SmartTagDef',\
                      0xc8:'PrintProps',\
                      0xd1:'NRBSTo Data'}

 
    
def parse_page(rect,doc,model,iter,cr):
    chunkfunc = {	0x0e:cmd.text,\
                            0x15:cmd.page,\
                            0x48:cmd.shapetype,\
                            0x85:cmd.line,\
                            0x86:cmd.fill,\
#                      0x87:textblock,\
                            0x8a:cmd.moveto,\
                            0x8b:cmd.lineto,\
                            0x8c:cmd.arcto,\
                            0x8f:cmd.ellipse,\
#                      0x90:EllipticalArcTo,\
                            0x92:cmd.pageprops,
                            0x94:cmd.char,\
#                      0x95:ParaIX,\
                            0x9b:cmd.xform,\
#                      0x9c:TextXForm,\
                            0x9d:cmd.xform1d,\
#                      0xc1:PolylineTo,\
            }
    value = model.get_value(iter,0)
    pntr = value["pointer"]
    data = pntr.data
    type = ord(data[0])
##    if chunktype.has_key(type):
##        print 'Type: ',chunktype[type]
    if chunkfunc.has_key(type):
        chunkfunc[type](rect,doc,data,cr)
                      
                      
def parse(pntr,model,version,cr):    
    offset = 0
    while offset < len(pntr.data):
        chnk = vsdoc.chunk()
        [chnk.type] = struct.unpack('<L', pntr.data[offset:offset+4])
        [chnk.IX] = struct.unpack('<L', pntr.data[offset+4:offset+8])
        if chnk.IX == 0xffffffff:
            chnk.IX = -1
        [chnk.unkn1] = struct.unpack('<L', pntr.data[offset+8:offset+12])
        [chnk.length] = struct.unpack('<L', pntr.data[offset+12:offset+16])
        [chnk.unkn2] = struct.unpack('<h', pntr.data[offset+16:offset+18])
        chnk.unkn3 = ord(pntr.data[offset+18])
        trailer = 0
        if (chnk.unkn1 != 0) or (chnk.type == 0x71) or (chnk.type==0x70):
            trailer = 8
        if (0x6b == chnk.type or 0x6a == chnk.type or 0x69 == chnk.type or 0x66 == chnk.type or 0x65 == chnk.type or 0x2c == chnk.type):
            trailer = 8
        
        if(11 == version): #/* separators were found only in Visio2k3 atm.  trailer means that there is a separator too. */
            if 0 != chnk.unkn1 or\
                (2 == chnk.unkn2 and 0x55 == chnk.unkn3) or\
                (2 == chnk.unkn2 and 0x54 == chnk.unkn3 and 0xaa == chnk.type) or\
                (3 == chnk.unkn2 and 0x50 != chnk.unkn3) or\
                (0x69 == chnk.type):        # /* max kosmach wrongly added it version independently */
                trailer = trailer + 4
        if(11 == version and (0x1f == chnk.type or 0xc9 == chnk.type)):
            trailer = 0
        
##        print 'Type: %02x IX: %02x u1: %02x Len: %02x u2: %02x u3: %02x Trailer: %x Offset: %x'\
##                    %(chnk.type,chnk.IX, chnk.unkn1,chnk.length, chnk.unkn2, chnk.unkn3, trailer, offset)        

        ptr = vsdoc.pointer()
        ptr.data = pntr.data[offset:offset+19+chnk.length+trailer]
        offset = offset + 19+ chnk.length+trailer
        ptr.path = pntr.path
        if chunktype.has_key(chnk.type):
            itername = '%-24s'%chunktype[chnk.type]+'(IX: %x  Len: %x)'%(chnk.IX, chnk.length)
        else:
            itername = 'Type: %02x \t\tI/L u1/u2/u3: %02x/%02x  %02x %02x %02x'%(chnk.type,chnk.IX,chnk.length,chnk.unkn1,chnk.unkn2,chnk.unkn3)
        tree.tree_append(model,ptr,itername)
    
        
