/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.util;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.util.CharArray;
import com.sun.xml.fastinfoset.util.ValueArray;
import com.sun.xml.fastinfoset.util.ValueArrayResourceException;

public class ContiguousCharArrayArray
extends ValueArray {
    public static final int INITIAL_CHARACTER_SIZE = 512;
    public static final int MAXIMUM_CHARACTER_SIZE = Integer.MAX_VALUE;
    protected int _maximumCharacterSize;
    public int[] _offset;
    public int[] _length;
    public char[] _array;
    public int _arrayIndex;
    public int _readOnlyArrayIndex;
    private CharArray _charArray = new CharArray();
    private ContiguousCharArrayArray _readOnlyArray;

    public ContiguousCharArrayArray(int initialCapacity, int maximumCapacity, int initialCharacterSize, int maximumCharacterSize) {
        this._offset = new int[initialCapacity];
        this._length = new int[initialCapacity];
        this._array = new char[initialCharacterSize];
        this._charArray.ch = this._array;
        this._maximumCapacity = maximumCapacity;
        this._maximumCharacterSize = maximumCharacterSize;
    }

    public ContiguousCharArrayArray() {
        this(10, Integer.MAX_VALUE, 512, Integer.MAX_VALUE);
    }

    public final void clear() {
        this._arrayIndex = this._readOnlyArrayIndex;
        this._size = this._readOnlyArraySize;
    }

    public final int getArrayIndex() {
        return this._arrayIndex;
    }

    public final void setReadOnlyArray(ValueArray readOnlyArray, boolean clear) {
        if (!(readOnlyArray instanceof ContiguousCharArrayArray)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{readOnlyArray}));
        }
        this.setReadOnlyArray((ContiguousCharArrayArray)readOnlyArray, clear);
    }

    public final void setReadOnlyArray(ContiguousCharArrayArray readOnlyArray, boolean clear) {
        if (readOnlyArray != null) {
            this._readOnlyArray = readOnlyArray;
            this._readOnlyArraySize = readOnlyArray.getSize();
            this._readOnlyArrayIndex = readOnlyArray.getArrayIndex();
            if (clear) {
                this.clear();
            }
            this._array = this.getCompleteCharArray();
            this._charArray.ch = this._array;
            this._offset = this.getCompleteOffsetArray();
            this._length = this.getCompleteLengthArray();
            this._size = this._readOnlyArraySize;
        }
    }

    public final char[] getCompleteCharArray() {
        if (this._readOnlyArray == null) {
            return this._array;
        }
        char[] ra = this._readOnlyArray.getCompleteCharArray();
        char[] a = new char[this._readOnlyArrayIndex + this._array.length];
        System.arraycopy(ra, 0, a, 0, this._readOnlyArrayIndex);
        return a;
    }

    public final int[] getCompleteOffsetArray() {
        if (this._readOnlyArray == null) {
            return this._offset;
        }
        int[] ra = this._readOnlyArray.getCompleteOffsetArray();
        int[] a = new int[this._readOnlyArraySize + this._offset.length];
        System.arraycopy(ra, 0, a, 0, this._readOnlyArraySize);
        return a;
    }

    public final int[] getCompleteLengthArray() {
        if (this._readOnlyArray == null) {
            return this._length;
        }
        int[] ra = this._readOnlyArray.getCompleteOffsetArray();
        int[] a = new int[this._readOnlyArraySize + this._length.length];
        System.arraycopy(ra, 0, a, 0, this._readOnlyArraySize);
        return a;
    }

    public final CharArray get(int i) {
        this._charArray.start = this._offset[i];
        this._charArray.length = this._length[i];
        return this._charArray;
    }

    public final void add(int o, int l) {
        if (this._size == this._offset.length) {
            this.resize();
        }
        this._offset[this._size] = o;
        this._length[this._size++] = l;
    }

    public final void add(char[] c, int l) {
        if (this._size == this._offset.length) {
            this.resize();
        }
        this._offset[this._size] = this._arrayIndex;
        this._length[this._size++] = l;
        int arrayIndex = this._arrayIndex + l;
        if (arrayIndex >= this._array.length) {
            this.resizeArray(arrayIndex);
        }
        System.arraycopy(c, 0, this._array, this._arrayIndex, l);
        this._arrayIndex = arrayIndex;
    }

    protected final void resize() {
        if (this._size == this._maximumCapacity) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.arrayMaxCapacity"));
        }
        int newSize = this._size * 3 / 2 + 1;
        if (newSize > this._maximumCapacity) {
            newSize = this._maximumCapacity;
        }
        int[] offset = new int[newSize];
        System.arraycopy(this._offset, 0, offset, 0, this._size);
        this._offset = offset;
        int[] length = new int[newSize];
        System.arraycopy(this._length, 0, length, 0, this._size);
        this._length = length;
    }

    protected final void resizeArray(int requestedSize) {
        if (this._arrayIndex == this._maximumCharacterSize) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.maxNumberOfCharacters"));
        }
        int newSize = requestedSize * 3 / 2 + 1;
        if (newSize > this._maximumCharacterSize) {
            newSize = this._maximumCharacterSize;
        }
        char[] array = new char[newSize];
        System.arraycopy(this._array, 0, array, 0, this._arrayIndex);
        this._array = array;
        this._charArray.ch = array;
    }
}

