#include "brip_rect_mask.h"

#include <vcl_iostream.h>

//        0 0 - 0 0
//        0 - + - 0
//        - + + + -
//        0 - + - 0
//        0 0 - 0 0
//
static int cr1_5x5 [] =
  {
    0, 0,-1, 0, 0,
    0,-1, 1,-1, 0,
   -1, 1, 1, 1,-1 ,
    0,-1, 1,-1, 0,
    0, 0,-1, 0, 0
  };

//        0 - - - 0
//        - + + + -
//        - + + + -
//        - + + + -
//        0 - - - 0
//
static int s1_5x5 [] =
  {
    0,-1,-1,-1, 0,
   -1, 1, 1, 1,-1,
   -1, 1, 1, 1,-1,
   -1, 1, 1, 1,-1,
    0,-1,-1,-1, 0,
  };

//        0 - - - 0
//        - + + + -
//        0 - - - 0
//
static int r10a0_3x5 [] =
  {
    0,-1,-1,-1, 0,
    -1, 1, 1, 1,-1,
    0,-1,-1,-1, 0
  };

//        0 0 0 - 0
//        0 0 - + -
//        0 - + - 0
//        - + - 0 0
//        0 - 0 0 0
//
static int r10a45_5x5 [] =
  {
    0,0,0,-1,0,
    0,0,-1,1,-1,
    0,-1,1,-1,0,
    -1,1,-1,0,0,
    0,-1,0,0,0
  };

//     0 - - - - - - - 0
//     - + + + + + + + -
//     0 - - - - - - - 0
//
static int r30a0_3x9 [] =
  {
    0,-1,-1,-1,-1,-1,-1,-1,0,
    -1,1,1,1,1,1,1,1,-1,
    0,-1,-1,-1,-1,-1,-1,-1,0
  };

//     0 0 0 0 0 0 - - 0
//     0 0 0 - - - + + -
//     0 - - + + + - - 0
//     - + + - - - 0 0 0
//     0 - - 0 0 0 0 0 0
//
static int r30a22_5x9 [] =
  {
    0,0,0,0,0,0,-1,-1,0,
    0,0,0,-1,-1,-1,1,1,-1,
    0,-1,-1,1,1,1,-1,-1,0,
    -1,1,1,-1,-1,-1,0,0,0,
    0,-1,-1,0,0,0,0,0,0
  };

//       0 0 0 0 0 - 0
//       0 0 0 0 - + -
//       0 0 0 - + - 0
//       0 0 - + - 0 0
//       0 - + - 0 0 0
//       - + - 0 0 0 0
//       0 - 0 0 0 0 0
//
static int r30a45_7x7 [] =
  {
    0,0,0,0,0,-1,0,
    0,0,0,0,-1,1,-1,
    0,0,0,-1,1,-1,0,
    0,0,-1,1,-1,0,0,
    0,-1,1,-1,0,0,0,
    -1,1,-1,0,0,0,0,
    0,-1,0,0,0,0,0
  };

//     0 - - - - - - - 0
//     - + + + + + + + -
//     - + + + + + + + -
//     - + + + + + + + -
//     0 - - - - - - - 0
//
static int r31a0_5x9 [] =
  {
    0,-1,-1,-1,-1,-1,-1,-1,0,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    0,-1,-1,-1,-1,-1,-1,-1,0
  };

//     0 0 0 0 - - - - 0
//     0 - - - + + + + -
//     - + + + + + + + -
//     - + + + + - - - 0
//     0 - - - - 0 0 0 0
//
static int r31a22_5x9 [] =
  {
    0,0,0,0,-1,-1,-1,-1,0,
    0,-1,-1,-1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,-1,-1,-1,0,
    0,-1,-1,-1,-1,0,0,0,0
  };

//       0 0 0 0 - - 0
//       0 0 0 - + + -
//       0 0 - + + + -
//       0 - + + + - 0
//       - + + + - 0 0
//       - + + - 0 0 0
//       0 - - 0 0 0 0
//
static int r31a45_7x7 [] =
  {
    0,0,0,0,-1,-1,0,
    0,0,0,-1,1,1,-1,
    0,0,-1,1,1,1,-1,
    0,-1,1,1,1,-1,0,
    -1,1,1,1,-1,0,0,
    -1,1,1,-1,0,0,0,
    0,-1,-1,0,0,0,0
  };

//     0 - - - - - - - 0
//     - + + + + + + + -
//     - + + + + + + + -
//     - + + + + + + + -
//     - + + + + + + + -
//     - + + + + + + + -
//     0 - - - - - - - 0
//
static int r32a0_7x9 [] =
  {
    0,-1,-1,-1,-1,-1,-1,-1,0,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    0,-1,-1,-1,-1,-1,-1,-1,0
  };

//     0 0 0 - - - - - 0
//     0 0 - + + + + + -
//     0 - + + + + + + -
//     - + + + + + + + -
//     - + + + + + + - 0
//     - + + + + + - 0 0
//     0 - - - - - 0 0 0
//
static int r32a22_7x9 [] =
  {
    0,0,0,-1,-1,-1,-1,-1,0,
    0,0,-1,1,1,1,1,1,-1,
    0,-1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,-1,0,
    -1,1,1,1,1,1,-1,0,0,
    0,-1,-1,-1,-1,-1,0,0,0
  };

//     0 0 0 0 0 - 0 0 0
//     0 0 0 0 - + - 0 0
//     0 0 0 - + + + - 0
//     0 0 - + + + + + -
//     0 - + + + + + - 0
//     - + + + + + - 0 0
//     0 - + + + - 0 0 0
//     0 0 - + - 0 0 0 0
//     0 0 0 - 0 0 0 0 0
//
static int r32a45_9x9 [] =
  {
    0,0,0,0,0,-1,0,0,0,
    0,0,0,0,-1,1,-1,0,0,
    0,0,0,-1,1,1,1,-1,0,
    0,0,-1,1,1,1,1,1,-1,
    0,-1,1,1,1,1,1,-1,0,
    -1,1,1,1,1,1,-1,0,0,
    0,-1,1,1,1,-1,0,0,0,
    0,0,-1,1,-1,0,0,0,0,
    0,0,0,-1,0,0,0,0,0
  };

//  0 - - - - - - - - - - - 0
//  - + + + + + + + + + + + -
//  - + + + + + + + + + + + -
//  - + + + + + + + + + + + -
//  - - - - - - - - - - - - 0
//
static int r51a0_5x13[] =
  {
    0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0
  };

//  0 0 0 0 0 0 0 0 0 - - - 0
//  0 0 0 0 0 0 0 0 - + + + -
//  0 0 0 0 0 - - - + + + + -
//  0 0 0 - - + + + + + + + -
//  0 - - + + + + + + + - - 0
//  - + + + + + + + - - 0 0 0
//  - + + + + - - - 0 0 0 0 0
//  - + + + - 0 0 0 0 0 0 0 0
//  0 - - - 0 0 0 0 0 0 0 0 0
//
static int r51a22_9x13[] =
  {
    0,0,0,0,0,0,0,0,0,-1,-1,-1,0,
    0,0,0,0,0,0,0,0,-1,1,1,1,-1,
    0,0,0,0,0,-1,-1,-1,1,1,1,1,-1,
    0,0,0,-1,-1,1,1,1,1,1,1,1,-1,
    0,-1,-1,1,1,1,1,1,1,1,-1,-1,0,
    -1,1,1,1,1,1,1,1,-1,-1,0,0,0,
    -1,1,1,1,1,-1,-1,-1,0,0,0,0,0,
    -1,1,1,1,-1,0,0,0,0,0,0,0,0,
    0,-1,-1,-1,0,0,0,0,0,0,0,0,0
  };

//   0 0 0 0 0 0 0 0 - - 0
//   0 0 0 0 0 0 0 - + + -
//   0 0 0 0 0 0 - + + + -
//   0 0 0 0 0 - + + + - 0
//   0 0 0 0 - + + + - 0 0
//   0 0 0 - + + + - 0 0 0
//   0 0 - + + + - 0 0 0 0
//   0 - + + + - 0 0 0 0 0
//   - + + + - 0 0 0 0 0 0
//   - + + - 0 0 0 0 0 0 0
//   0 - - 0 0 0 0 0 0 0 0
//
static int r51a45_11x11[] =
  {
    0,0,0,0,0,0,0,0,-1,-1,0,
    0,0,0,0,0,0,0,-1,1,1,-1,
    0,0,0,0,0,0,-1,1,1,1,-1,
    0,0,0,0,0,-1,1,1,1,-1,0,
    0,0,0,0,-1,1,1,1,-1,0,0,
    0,0,0,-1,1,1,1,-1,0,0,0,
    0,0,-1,1,1,1,-1,0,0,0,0,
    0,-1,1,1,1,-1,0,0,0,0,0,
    -1,1,1,1,-1,0,0,0,0,0,0,
    -1,1,1,-1,0,0,0,0,0,0,0,
    0,-1,-1,0,0,0,0,0,0,0,0
  };

//  - - - - - - - - - - - - -
//  - + + + + + + + + + + + -
//  - + + + + + + + + + + + -
//  - + + + + + + + + + + + -
//  - + + + + + + + + + + + -
//  - + + + + + + + + + + + -
//  - - - - - - - - - - - - -
//
static int r52a0_7x13[] =
  {
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    -1,1,1,1,1,1,1,1,1,1,1,1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
  };

#if 0 // not used
//  0 0 0 0 0 0 0 0 - - - - 0
//  0 0 0 0 0 - - + + + + + -
//  0 0 0 0 - + + + + + + + -
//  0 0 0 - + + + + + + + - -
//  0 - - + + + + + + + - - 0
//  - - + + + + + + + - 0 0 0
//  - + + + + + + + - 0 0 0 0
//  - + + + + + - - 0 0 0 0 0
//  0 - - - - 0 0 0 0 0 0 0 0
//
static int r52a22_9x13[] =
  {
    0,0,0,0,0,0,0,0,0,-1,-1,-1,0,
    0,0,0,0,0,-1,-1,1,1,1,1,1,-1,
    0,0,0,0,-1,1,1,1,1,1,1,1,-1,
    0,0,0,-1,1,1,1,1,1,1,1,-1,-1,
    0,-1,-1,1,1,1,1,1,1,1,-1,-1,0,
    -1,-1,1,1,1,1,1,1,1,-1,0,0,0,
    -1,1,1,1,1,1,1,1,-1,0,0,0,0,
    -1,1,1,1,1,1,-1,-1,0,0,0,0,0,
    0,-1,-1,-1,-1,0,0,0,0,0,0,0,0
  };
#endif // 0

//  0 0 0 0 0 0 0 0 0 - 0 0 0
//  0 0 0 0 0 0 0 0 - + - 0 0
//  0 0 0 0 0 0 0 - + + + - 0
//  0 0 0 0 0 0 - + + + + + -
//  0 0 0 0 0 - + + + + + - 0
//  0 0 0 0 - + + + + + - 0 0
//  0 0 0 - + + + + + - 0 0 0
//  0 0 - + + + + + - 0 0 0 0
//  0 - + + + + + - 0 0 0 0 0
//  - + + + + + - 0 0 0 0 0 0
//  0 - + + + - 0 0 0 0 0 0 0
//  0 0 - + - 0 0 0 0 0 0 0 0
//  0 0 0 - 0 0 0 0 0 0 0 0 0
//
static int r52a45_13x13[] =
  {
   0,0,0,0,0,0,0,0,0,-1,0,0,0,
   0,0,0,0,0,0,0,0,-1,1,-1,0,0,
   0,0,0,0,0,0,0,0,-1,1,1,1,-1,
   0,0,0,0,0,0,-1,1,1,1,1,1,-1,
   0,0,0,0,0,-1,1,1,1,1,1,-1,0,
   0,0,0,0,-1,1,1,1,1,1,-1,0,0,
   0,0,0,-1,1,1,1,1,1,-1,0,0,0,
   0,0,-1,1,1,1,1,1,-1,0,0,0,0,
   0,-1,1,1,1,1,1,-1,0,0,0,0,0,
   -1,1,1,1,1,1,-1,0,0,0,0,0,0,
   0,-1,1,1,1,-1,0,0,0,0,0,0,0,
   0,0,-1,1,-1,0,0,0,0,0,0,0,0,
   0,0,0,-1,0,0,0,0,0,0,0,0,0
  };

//  0 0 0 0 0 0 0 0 0 0 0
//  0 0 0 0 0 0 - - - - 0
//  0 0 0 0 0 - + + + + -
//  0 0 0 0 - + + + + + -
//  0 0 0 - + + + + + + -
//  0 0 - + + + + + + + -
//  0 0 - + + + + + + - 0
//  0 - + + + + + + - 0 0
//  0 - + + + + + + - 0 0
//  0 0 - + + + + - 0 0 0
//  0 0 0 - - - - 0 0 0 0
//
static int b0_11x11[] =
  {
    0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,-1,-1,-1,-1,0,
    0,0,0,0,0,-1,1,1,1,1,-1,
    0,0,0,0,-1,1,1,1,1,1,-1,
    0,0,0,-1,1,1,1,1,1,1,-1,
    0,0,-1,1,1,1,1,1,1,1,-1,
    0,0,-1,1,1,1,1,1,1,-1,0,
    0,-1,1,1,1,1,1,1,-1,0,0,
    0,0,-1,1,1,1,1,-1,0,0,0,
    0,0,0,-1,-1,-1,-1,0,0,0,0
  };

//    0 0 0 0 0 0 0 0 0
//    0 - - - - - 0 0 0
//    - + + + + + - 0 0
//    - + + + + + - 0 0
//    - + + + + + + - 0
//    0 - + + + + - 0 0
//    0 0 - + + + + - 0
//    0 0 0 - + + + - 0
//    0 0 0 0 - - - 0 0
//
static int b1_9x9[] =
  {
    0,0,0,0,0,0,0,0,0,
    0,-1,-1,-1,-1,-1,0,0,0,
    -1,1,1,1,1,1,-1,0,0,
    -1,1,1,1,1,1,-1,0,0,
    -1,1,1,1,1,1,1,-1,0,
    0,-1,1,1,1,1,-1,0,0,
    0,0,-1,1,1,1,1,-1,0,
    0,0,0,-1,1,1,1,-1,0,
    0,0,0,0,-1,-1,-1,0,0
  };

//  0 0 0 0 0 0 0 0 0 0 0
//  0 0 0 0 - - - - - - 0
//  0 0 0 - + + + + + + -
//  0 0 0 - + + + + + + -
//  0 0 - + + + + + + - 0
//  0 0 - + + + + + + - 0
//  0 - + + + + + + - 0 0
//  0 - + + + + + + - 0 0
//  - + + + + + + - 0 0 0
//  - + + + + + + - 0 0 0
//  0 - - - - - - 0 0 0 0
//
static int b0s_11x11[] =
  {
    0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,-1,-1,-1,-1,-1,-1,0,
    0,0,0,-1,1,1,1,1,1,1,-1,
    0,0,0,-1,1,1,1,1,1,1,-1,
    0,0,-1,1,1,1,1,1,1,-1,0,
    0,0,-1,1,1,1,1,1,1,-1,0,
    0,-1,1,1,1,1,1,1,-1,0,0,
    0,-1,1,1,1,1,1,1,-1,0,0,
    -1,1,1,1,1,1,1,-1,0,0,0,
    -1,1,1,1,1,1,1,-1,0,0,0,
    0,-1,-1,-1,-1,-1,-1,0,0,0,0
  };

//    0 0 0 0 0 0 0 0 0
//    0 - - - - - 0 0 0
//    - + + + + + - 0 0
//    - + + + + + - 0 0
//    - + + + + + + - 0
//    0 - + + + + + + -
//    0 0 - + + + + + -
//    0 0 - + + + + + -
//    0 0 - - - - - - 0
//
static int b1s_9x9[] =
  {
    0,0,0,0,0,0,0,0,0,
    0,-1,-1,-1,-1,-1,0,0,0,
    -1,1,1,1,1,1,-1,0,0,
    -1,1,1,1,1,1,-1,0,0,
    -1,1,1,1,1,1,1,-1,0,
    0,-1,1,1,1,1,1,1,-1,
    0,0,-1,1,1,1,1,1,-1,
    0,0,-1,1,1,1,1,1,-1,
    0,0,-1,-1,-1,-1,-1,0,0
  };

// ====================   Corners ===========================

//    - - - - -
//    - + + + +
//    - + + + 0
//    - + + 0 0
//    - + 0 0 0
static int c4_90_0_5x5[] =
  {
    -1,-1,-1,-1,-1,
    -1,1,1,1,1,
    -1,1,1,1,0,
    -1,1,1,0,0,
    -1,1,0,0,0
  };

//   0 0 0 0 - - -
//   0 0 0 - - - -
//   0 0 - + + + +
//   0 - + + + + 0
//   - + + + + 0 0
//
static int c4_45_0_5x7[] =
  {
    0,0,0,0,-1,-1,-1,
    0,0,0,-1,-1,-1,-1,
    0,0,-1,1,1,1,1,
    0,-1,1,1,1,1,0,
    -1,1,1,1,1,0,0
  };

//    0 0 0 0 0 0 0
//    0 0 0 - 0 0 0
//    0 0 - + - 0 0
//    0 - + + + - 0
//    - + + + + + -
//
static int c4_45_45_5x7[] =
  {
    0,0,0,0,0,0,0,
    0,0,0,-1,0,0,0,
    0,0,-1,1,-1,0,0,
    0,-1,1,1,1,-1,0,
    -1,1,1,1,1,1,-1
  };

//=======================   edges =========================

//       - - - - -
//       - - - - -
//       + + + + +
//       + + + + +
//       + + + + +
//
static int e5a0_5x5[] =
  {
    -1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    1,1,1,1,1,
    1,1,1,1,1,
    1,1,1,1,1
  };

#if 0 // not used
//   0 0 - - -
//   - - - - -
//   - - + + +
//   + + + + +
//   + + + 0 0
//
static int e5a22_5x5[] =
  {
    0,0,-1,-1,-1,
    -1,-1,-1,-1,-1,
    -1,-1,1,1,1,
    1,1,1,1,1,
    1,1,1,0,0
  };
#endif

//  0 - - - +
//  - - - + +
//  - - + + +
//  - + + + 0
//  + + + 0 0
//
static int e5a45_5x5[] =
  {
    0,-1,-1,-1,1,
    -1,-1,-1,1,1,
    -1,-1,1,1,1,
    -1,1,1,1,0,
    1,1,1,0,0
  };

//  - - - - - - - - - - -
//  - - - - - - - - - - -
//  + + + + + + + + + + +
//  + + + + + + + + + + +
//  + + + + + + + + + + +
//
static int e11a0_5x11[] =
  {
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1
  };

vnl_matrix<int> reflect_about_vert(vnl_matrix<int> const& m)
{
  unsigned nc = m.cols(), nr = m.rows();
  vnl_matrix<int> ref(nr, nc);
  int rc = (nc-1)/2;
  for (unsigned r = 0; r<nr; ++r)
    for (int c = -rc; c<=rc; ++c)
      ref[r][rc+c] = m[r][rc-c];
  return ref;
}

#if 0
vnl_matrix<int> reflect_about_vert_even(vnl_matrix<int> const& m)
{
  unsigned nc = m.cols(), nr = m.rows();
  vnl_matrix<int> ref(nr, nc);
  int rc = nc/2;
  for (unsigned r = 0; r<nr; ++r)
    for (int c = -rc; c<=rc; ++c)
      ref[r][rc+c] = m[r][rc-c];
  return ref;
}
#endif

vnl_matrix<int> reflect_about_horz(vnl_matrix<int> const& m)
{
  unsigned nc = m.cols(), nr = m.rows();
  vnl_matrix<int> ref(nr, nc);
  int rr = (nr-1)/2;
  for (unsigned c = 0; c<nc; ++c)
    for (int r = -rr; r<=rr; ++r)
      ref[rr+r][c] = m[rr-r][c];
  return ref;
}

#if 0
vnl_matrix<int> reflect_about_horz_even(vnl_matrix<int> const& m)
{
  unsigned nc = m.cols(), nr = m.rows();
  vnl_matrix<int> ref(nr, nc);
  int rr = nr-1/2;
  for (unsigned c = 0; c<nc; ++c)
    for (int r = -rr; r<=rr; ++r)
      ref[rr+r][c] = m[rr-r][c];
  return ref;
}
#endif

brip_rect_mask::brip_rect_mask(mask_id mid)
{
  switch (mid)
    {
    case cr1:{
      vnl_matrix<int> cr1a0(cr1_5x5, 5, 5);
      masks_[a0] =    cr1a0;
      break;
    }
    case s1:{
      vnl_matrix<int> s1a0(s1_5x5, 5, 5);
      masks_[a0] =    s1a0;
      break;
    }
    case b0:{
      vnl_matrix<int> b0a0(b0_11x11, 11, 11);
      masks_[a0] =    b0a0;
      break;
    }
    case b1:{
      vnl_matrix<int> b1a0(b1_9x9, 9, 9);
      masks_[a0] =    b1a0;
      break;
    }
    case b0s:{
      vnl_matrix<int> b0sa0(b0s_11x11, 11, 11);
      masks_[a0] =    b0sa0;
      break;
    }
    case b1s:{
      vnl_matrix<int> b1sa0(b1s_9x9, 9, 9);
      masks_[a0] =    b1sa0;
      break;
    }

    case r10:{
      vnl_matrix<int> r10a0(r10a0_3x5, 3, 5), r10a45(r10a45_5x5, 5, 5);
      masks_[a0] =    r10a0;
      masks_[a45]  =  r10a45;
      masks_[a90]  =  r10a0.transpose();
      masks_[a135] =  reflect_about_vert(r10a45);
      break;
    }
    case r30: {
      vnl_matrix<int> r30a0(r30a0_3x9, 3, 9), r30a22(r30a22_5x9, 5, 9),
        r30a45(r30a45_7x7, 7, 7);
      masks_[a0] =    r30a0;
      masks_[a22] =   r30a22;
      masks_[a45] =   r30a45;
      masks_[a67]  =  r30a22.transpose();
      masks_[a90]  =  r30a0.transpose();
      masks_[a112] =  reflect_about_vert(r30a22.transpose());
      masks_[a135] =  reflect_about_vert(r30a45);
      masks_[a157] =  reflect_about_horz(r30a22);
      break;
    }
    case r31: {
      vnl_matrix<int> r31a0(r31a0_5x9, 5, 9), r31a22(r31a22_5x9, 5, 9),
        r31a45(r31a45_7x7, 7, 7);
      masks_[a0] =    r31a0;
      masks_[a22] =   r31a22;
      masks_[a45] =   r31a45;
      masks_[a67]  =  r31a22.transpose();
      masks_[a90]  =  r31a0.transpose();
      masks_[a112] =  reflect_about_vert(r31a22.transpose());
      masks_[a135] =  reflect_about_vert(r31a45);
      masks_[a157] =  reflect_about_horz(r31a22);
      break;
    }
    case r32: {
      vnl_matrix<int> r32a0(r32a0_7x9, 7, 9), r32a22(r32a22_7x9, 7, 9),
        r32a45(r32a45_9x9, 9, 9);
      masks_[a0] =    r32a0;
      masks_[a22] =   r32a22;
      masks_[a45] =   r32a45;
      masks_[a67]  =  r32a22.transpose();
      masks_[a90]  =  r32a0.transpose();
      masks_[a112] =  reflect_about_vert(r32a22.transpose());
      masks_[a135] =  reflect_about_vert(r32a45);
      masks_[a157] =  reflect_about_horz(r32a22);
      break;
    }

    case r51: {
      vnl_matrix<int> r51a0(r51a0_5x13, 5, 13),  r51a22(r51a22_9x13, 9, 13),
        r51a45(r51a45_11x11, 11, 11);
      masks_[a0] =    r51a0;
      masks_[a22] =   r51a22;
      masks_[a45] =   r51a45;
      masks_[a67]  =  r51a22.transpose();
      masks_[a90]  =  r51a0.transpose();
      masks_[a112] =  reflect_about_vert(r51a22.transpose());
      masks_[a135] =  reflect_about_vert(r51a45);
      masks_[a157] =  reflect_about_horz(r51a22);
      break;
    }
    case r52: {
      vnl_matrix<int> r52a0(r52a0_7x13, 7, 13),  r52a22(r51a22_9x13, 9, 13),
        r52a45(r52a45_13x13, 13, 13);
      masks_[a0] =    r52a0;
      masks_[a22] =   r52a22;
      masks_[a45] =   r52a45;
      masks_[a67]  =  r52a22.transpose();
      masks_[a90]  =  r52a0.transpose();
      masks_[a112] =  reflect_about_vert(r52a22.transpose());
      masks_[a135] =  reflect_about_vert(r52a45);
      masks_[a157] =  reflect_about_horz(r52a22);
      break;
    }
    case c4_90_0: {
      vnl_matrix<int> c4_90_0a0(c4_90_0_5x5, 5, 5);
      masks_[a0] =    c4_90_0a0;
      masks_[a90] =   reflect_about_vert(c4_90_0a0);
      masks_[a180] =   reflect_about_horz(c4_90_0a0);
      masks_[a270] =   reflect_about_horz(reflect_about_vert(c4_90_0a0));
      break;
    }
    case c4_45_0: {
      vnl_matrix<int> c4_45_0a0(c4_45_0_5x7, 5, 7);
      masks_[a0] =    c4_45_0a0;
      masks_[a45]=    c4_45_0a0.transpose();
      masks_[a90] =   reflect_about_vert(c4_45_0a0);
      masks_[a135] =  reflect_about_vert(c4_45_0a0.transpose());
      masks_[a180] =   reflect_about_horz(c4_45_0a0);
      masks_[a225]= reflect_about_horz(reflect_about_vert(c4_45_0a0.transpose()));
      masks_[a270] =  reflect_about_horz(reflect_about_vert(c4_45_0a0));
      break;
    }
    case c4_45_45: {
      vnl_matrix<int> c4_45_45a0(c4_45_45_5x7, 5, 7);
      masks_[a0] =    c4_45_45a0;
      masks_[a90] =   c4_45_45a0.transpose();
      masks_[a180] =  reflect_about_horz(c4_45_45a0);
      masks_[a270] =  reflect_about_horz(c4_45_45a0).transpose();
      break;
    }
    case e5:{
      vnl_matrix<int> e5a0(e5a0_5x5, 5, 5), e5a45(e5a45_5x5, 5, 5);
      masks_[a0] =    e5a0;
      masks_[a45] =   e5a45;
      masks_[a90]  =  e5a0.transpose();
      masks_[a135]  =  reflect_about_horz(e5a45);
      masks_[a180]  =  reflect_about_horz(e5a0);
      masks_[a225] =  reflect_about_vert(reflect_about_horz(e5a45));
      masks_[a270]  =  reflect_about_vert(e5a0.transpose());
      masks_[a315]  =  reflect_about_vert(e5a45.transpose());
      break;
    }
    case e11:{
      vnl_matrix<int> e11a0(e11a0_5x11, 5, 11);
      masks_[a0] =    e11a0;
      masks_[a90]  =  e11a0.transpose();
      masks_[a180]  =  reflect_about_horz(e11a0);
      masks_[a270]  =  reflect_about_vert(e11a0.transpose());
      break;
    }

    default:
      vcl_cout << "specified mask does not exist\n";
    };
}

bool brip_rect_mask::
find_ait(ang_id aid,
         vcl_map<ang_id, vnl_matrix<int> >::const_iterator& ait) const
{
  ait = masks_.find(aid);
  if (ait == masks_.end())
    return false;
  return true;
}

brip_rect_mask::ang_id brip_rect_mask::angle_id(unsigned angle_index) const
{
  vcl_map<ang_id, vnl_matrix<int> >::const_iterator ait = masks_.begin();
  for (unsigned i = 0; i<angle_index; ++i)
    ++ait;
  return (*ait).first;
}

bool brip_rect_mask::set_angle_id(ang_id aid)
{
  vcl_map<ang_id, vnl_matrix<int> >::const_iterator ait;
  bool found = find_ait(aid, ait);
  if (!found){
    ru_ = 0; rv_ = 0;
    return false;
  }
  current_mask_ = (*ait).second;
  ru_ = (current_mask_.cols()-1)/2;
  rv_ = (current_mask_.rows()-1)/2;
  return true;
}

vcl_ostream& operator<<(vcl_ostream& s, brip_rect_mask const& msk)
{
  s << "masks\n";
  brip_rect_mask& msk_nc = const_cast<brip_rect_mask&>(msk);
  unsigned nangles = msk.n_angles();
  for (unsigned a = 0; a<nangles; ++a){
    brip_rect_mask::ang_id aid = msk.angle_id(a);
    msk_nc.set_angle_id(aid);
    unsigned ni =msk_nc.ni(), nj = msk_nc.nj();
    int ri = (ni-1)/2, rj = (nj-1)/2;
    for (int jr = -rj; jr<=rj ; ++jr){
      for (int ir = -ri; ir<= ri; ++ir)
      {
        int m = msk_nc(ir,jr);
        if (m >0)
          s << '+' << ' ';
        else if (m<0)
          s << '-' << ' ';
        else
          s << '0' << ' ';
      }
      s << '\n';
    }
    s<< '\n';
  }
  return s;
}
