#include <iostream>
#include "settings.h"
#include "misc.h"

using namespace std;
/////////////////////////////////////////////////////////////////
// Settings
/////////////////////////////////////////////////////////////////
Settings::Settings()
{
	clear();		 
}

Settings::~Settings()
{
}

void Settings::clear()
{
	pathlist.clear();
	keylist.clear();
	valuelist.clear();
}

void Settings::clearLocal(const QString &s)
{
	QStringList::Iterator itp=pathlist.begin();
	QStringList::Iterator itk=keylist.begin();
	QStringList::Iterator itv=valuelist.begin();

	while (itp !=pathlist.end() )
	{
		if ((*itk).startsWith (s))
		{
			itp=pathlist.remove (itp);
			itk=keylist.remove (itk);
			itv=valuelist.remove (itv);
		}	else
		{
			itp++;
			itk++;
			itv++;
		}
	}
}

QString Settings::readLocalEntry ( const QString &fpath, const QString & key, const QString & def = QString::null ) 
{
	QStringList::Iterator itp=pathlist.begin();
	QStringList::Iterator itk=keylist.begin();
	QStringList::Iterator itv=valuelist.begin();

	// First search for value in settings saved in map
	while (itp !=pathlist.end() )
	{
		if (*itp == fpath && *itk == key)
			return *itv;
		itp++;
		itk++;
		itv++;
	}

	// Fall back to global vym settings
	bool ok;
	return readEntry (key,def, &ok);
}	

void Settings::setLocalEntry (const QString &fpath, const QString &key, const QString &value)
{
	QStringList::Iterator itp=pathlist.begin();
	QStringList::Iterator itk=keylist.begin();
	QStringList::Iterator itv=valuelist.begin();

	if (!fpath.isEmpty() && !key.isEmpty() && !value.isEmpty() )
	{
		// Search for existing entry first
		while (itp !=pathlist.end() )
		{
			if (*itp == fpath && *itk == key)
			{
				*itv=value;
				return;
			}
			itp++;
			itk++;
			itv++;
		}
		
		// If no entry exists, append a new one
		pathlist.append (fpath);
		keylist.append (key);
		valuelist.append (value);
	}
}

QString Settings::getXMLData (const QString &fpath)
{
	QString s;
	QStringList::Iterator itp=pathlist.begin();
	QStringList::Iterator itk=keylist.begin();
	QStringList::Iterator itv=valuelist.begin();

	while (itp !=pathlist.end() )
	{
		if (*itp == fpath )
			if (!(*itv).isEmpty())
				s+=singleElement (
					"setting",
					attribut ("key",*itk) 
					+attribut ("value",*itv)
				)+"\n";
		itp++;
		itk++;
		itv++;
	}
	return s;
}

void Settings::write()
{
	QStringList::Iterator itp=pathlist.begin();
	QStringList::Iterator itk=keylist.begin();
	QStringList::Iterator itv=valuelist.begin();

	while (itp !=pathlist.end() )
	{
		itp++;
		itk++;
		itv++;
	}
}

