#include "mainwindow.h"

#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qmenubar.h>
#include <qapplication.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qcolor.h>
#include <qcolordialog.h>
#include <qbitmap.h>
#include <qinputdialog.h>
//#include <qdatetime.h>			// for random seed


#include <iostream>
#include <cstdlib>
#include <typeinfo>

#include "aboutdialog.h"
#include "exportoofiledialog.h"
#include "exports.h"
#include "exportxhtmldialog.h"
#include "file.h"
#include "flagrowobj.h"
#include "imports.h"
#include "mapeditor.h"
#include "misc.h"
#include "options.h"
#include "process.h"
#include "settings.h"
#include "showtextdialog.h"
#include "texteditor.h"
#include "version.h"

extern TextEditor *textEditor;
extern Main *mainWindow;
extern QString tmpVymDir;
extern QString clipboardDir;
extern bool clipboardEmpty;
extern int statusbarTime;
extern FlagRowObj* standardFlagsDefault;
extern FlagRowObj* systemFlagsDefault;

extern QPtrList <QAction> actionListBranches;

extern QAction* actionFileSave;
extern QAction* actionFilePrint;
extern QAction* actionEditUndo;
extern QAction* actionEditRedo;
extern QAction *actionEditCopy;
extern QAction *actionEditCut;
extern QAction *actionEditPaste;
extern QAction *actionEditMoveUp;
extern QAction *actionEditMoveDown;
extern QAction *actionEditToggleScroll;
extern QAction* actionEditOpenURL;
extern QAction* actionEditOpenURLTab;
extern QAction* actionEditURL;
extern QAction* actionEditHeading2URL;
extern QAction* actionEditBugzilla2URL;
extern QAction* actionEditFATE2URL;
extern QAction *actionEditOpenVymLink;
extern QAction *actionEditVymLink;
extern QAction *actionEditDeleteVymLink;
extern QAction *actionEditToggleHideExport;
extern QAction *actionEditMapInfo;
extern QAction *actionEditHeading;
extern QAction *actionEditDelete;
extern QAction *actionEditAddBranch;
extern QAction *actionEditAddBranchHere;
extern QAction *actionEditAddBranchAbove;
extern QAction *actionEditAddBranchBelow;
extern QAction *actionEditRemoveBranchKeepChilds;
extern QAction *actionEditRemoveChilds;
extern QAction *actionEditImportAdd;
extern QAction *actionEditImportReplace;
extern QAction *actionEditSaveBranch;
extern QAction *actionEditSelectFirst;
extern QAction *actionEditSelectLast;
extern QAction *actionEditLoadImage;

extern QAction* actionFormatColor;
extern QAction* actionFormatPickColor;
extern QAction* actionFormatColorBranch;
extern QAction* actionFormatColorSubtree;
extern QAction* actionFormatLinkColorHint;
extern QAction* actionFormatBackColor;
extern QAction* actionFormatLinkColor;
extern QAction *actionFormatIncludeImagesVer;
extern QAction *actionFormatIncludeImagesHor;

extern QActionGroup* actionGroupModModes;
extern QAction* actionModModeColor;
extern QAction* actionModModeLink;
extern QAction* actionModModeCopy;

extern QActionGroup *actionGroupFormatFrameTypes;
extern QAction *actionFormatFrameNone;
extern QAction *actionFormatFrameRectangle;

extern QActionGroup *actionGroupFormatLinkStyles;
extern QAction *actionFormatLinkStyleLine;
extern QAction *actionFormatLinkStyleParabel;
extern QAction *actionFormatLinkStylePolyLine;
extern QAction *actionFormatLinkStylePolyParabel;
extern QAction *actionFormatHideLinkUnselected;

extern QAction *actionViewToggleNoteEditor;
extern QAction *actionViewToggleHistoryWindow;

extern QAction* actionSettingsAutoedit;
extern QAction* actionSettingsAutoselectHeading;
extern QAction* actionSettingsAutoselectHeading;
extern QAction* actionSettingsAutoselectText;
extern QAction* actionSettingsPasteNewHeading;
extern QAction* actionSettingsUseDelKey;
extern QAction* actionSettingsUseFlagGroups;
extern QAction* actionSettingsUseHideExport;

extern QPopupMenu* branchContextMenu;
extern QPopupMenu* branchAddContextMenu;
extern QPopupMenu* branchRemoveContextMenu;
extern QPopupMenu* branchLinksContextMenu;
extern QPopupMenu* branchLinksContextMenuDup;
extern QPopupMenu* floatimageContextMenu;
extern QPopupMenu* saveImageFormatMenu;
extern QPopupMenu* canvasContextMenu;
extern QPopupMenu* lastMapsMenu;
extern QPopupMenu* importMenu;
extern QPopupMenu* exportMenu;
extern QPopupMenu* exportImageFormatMenu;


extern Settings settings;
extern Options options;
extern QDir vymBaseDir;
extern QString iconPath;
extern QString flagsPath;

#if defined(Q_OS_LINUX)
extern void qt_wait_for_window_manager( QWidget* w );
#endif

Main::Main(QWidget* parent, const char* name, WFlags f) :
    QMainWindow(parent,name,f)
{
	mainWindow=this;

	setCaption ("VYM - View Your Mind");

	// Load window settings
	resize (settings.readNumEntry( "/vym/mainwindow/geometry/width", 800),
	        settings.readNumEntry( "/vym/mainwindow/geometry/height",600));
	move   (settings.readNumEntry( "/vym/mainwindow/geometry/posX", 100),
	        settings.readNumEntry( "/vym/mainwindow/geometry/posY", 100));


	// Create unique temporary directory
	tmpVymDir=makeUniqueDir ("/tmp/vym-XXXXXX");

	// Create direcctory for clipboard
	clipboardDir=tmpVymDir+"/clipboard";
	QDir d(clipboardDir);
	d.mkdir (clipboardDir,true);
	makeSubDirs (clipboardDir);
	clipboardEmpty=true;

	procBrowser=NULL;

	// FIXME not used currently
	// Set random seed (random used for object IDs)
    // QTime t = QTime::currentTime();		// set random seed
    // srand( t.hour()*12+t.minute()*60+t.second()*60 );


	// Initialize some settings, which are platform dependant
	QString p,s;

		// application to open URLs
		p="/vym/mainwindow/readerURL";
		#if defined(Q_OS_LINUX)
			s=settings.readEntry (p,"konqueror");
		#else
			#if defined(Q_OS_MACX)
				s=settings.readEntry (p,"/usr/bin/open");
			#else
				s=settings.readEntry (p,"mozilla");
			#endif
		#endif
		settings.writeEntry( p,s);

		// application to open PDFs
		p="/vym/mainwindow/readerPDF";
		#if defined(Q_OS_LINUX)
			s=settings.readEntry (p,"acroread");
		#else
			#if defined(Q_OS_MACX)
				s=settings.readEntry (p,"/usr/bin/open");
			#else
				s=settings.readEntry (p,"acroread");
			#endif
		#endif
		settings.writeEntry( p,s);

	
	maxLastMaps=9;

	// Create tab widget which holds the maps
	tabWidget= new QTabWidget (this);
	connect( tabWidget, SIGNAL( currentChanged( QWidget * ) ), 
		this, SLOT( editorChanged( QWidget * ) ) );

	setCentralWidget(tabWidget);	

    setupFileActions();
    setupEditActions();
    setupFormatActions();
    setupViewActions();
    setupModeActions();
	setupFlagActions();
    setupSettingsActions();
	setupContextMenus();
    if (settings.readBoolEntry( "/vym/mainwindow/showTestMenu",false)) setupTestActions();
    setupHelpActions();
    
	// After menu is created, we can enable some actions
	actionFilePrint->setEnabled (true);

    statusBar();


	// Initialize Find window
	findWindow=new FindWindow(NULL,"findwindow");
	connect (findWindow, SIGNAL( findButton(QString) ), 
		this, SLOT(editFind(QString) ) );	
	connect (findWindow, SIGNAL( somethingChanged() ), 
		this, SLOT(editFindChanged() ) );	

	// Connect TextEditor, so that we can update flags if text changes
	connect (textEditor, SIGNAL (textHasChanged() ), this, SLOT (updateNoteFlag()));

	updateGeometry();
}

Main::~Main()
{
	// Save Settings
	settings.writeEntry( "/vym/mainwindow/geometry/width", width() );
	settings.writeEntry( "/vym/mainwindow/geometry/height", height() );
	settings.writeEntry( "/vym/mainwindow/geometry/posX", pos().x() );
	settings.writeEntry( "/vym/mainwindow/geometry/posY", pos().y() );

	settings.writeEntry( "/vym/version/version", __VYM_VERSION );
	settings.writeEntry( "/vym/version/builddate", __BUILD_DATE );

	settings.writeEntry( "/vym/mapeditor/editmode/autoselectheading",actionSettingsAutoselectHeading->isOn() );
	settings.writeEntry( "/vym/mapeditor/editmode/autoselecttext",actionSettingsAutoselectText->isOn() );
	settings.writeEntry( "/vym/mapeditor/editmode/pastenewheading",actionSettingsPasteNewHeading->isOn() );
	settings.writeEntry( "/vym/mapeditor/editmode/autoedit",actionSettingsAutoedit->isOn() );
	settings.writeEntry( "/vym/mapeditor/editmode/useDelKey",actionSettingsUseDelKey->isOn() );
	settings.writeEntry( "/vym/mapeditor/editmode/useFlagGroups",actionSettingsUseFlagGroups->isOn() );
	settings.writeEntry( "/vym/export/useHideExport",actionSettingsUseHideExport->isOn() );

	QString s;
	int maps=lastMaps.count();
	settings.writeEntry( "/vym/lastMaps/number",maps );
	for (int i=1;i<=maps;i++)
	{
		QStringList::Iterator it = lastMaps.at(i-1);
		s=QString("/vym/lastMaps/map-%1").arg(i);
		if (!s.isEmpty() && i<=maxLastMaps) 
			settings.writeEntry (s, *it);
	}


	// To make the texteditor save its settings, call the destructor
	delete (textEditor);

	// Remove temporary directory
	removeDir (QDir(tmpVymDir));
}

void Main::loadCmdLine()
{
	/* TODO draw some kind of splashscreen while loading...
	if (qApp->argc()>1)
	{
	}
	*/
	
	QStringList flist=options.getFileList();
	QStringList::Iterator it=flist.begin();

	while (it !=flist.end() )
	{
		fileLoad (*it, NewMap);
		*it++;
	}	
}


void Main::statusMessage(const QString &s)
{
	statusBar()->message (s);
}

void Main::closeEvent (QCloseEvent* )
{
	fileExitVYM();
}

// File Actions
void Main::setupFileActions()
{
    QToolBar *tb = new QToolBar( this );
    tb->setLabel( "File Actions" );
    QPopupMenu *menu = new QPopupMenu( this );
    menuBar()->insertItem( tr( "&File" ), menu );

	// Keycodes:  /usr/lib64/qt3/include/qnamespace.h

    QAction *a;
    a = new QAction( tr( "New map","File menu" ), QPixmap( iconPath+"filenew.png"), tr( "&New..." ), CTRL + Key_N, this, "fileNew" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileNew() ) );
    a->addTo( tb );
    a->addTo( menu );
	
    a = new QAction( tr( "Open","File menu" ), QPixmap( iconPath+"fileopen.png"), tr( "&Open..." ), CTRL + Key_O, this, "fileOpen" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileLoad() ) );
    a->addTo( tb );
    a->addTo( menu );
	
	lastMapsMenu = new QPopupMenu (this);

    menu->insertItem (tr("Open Recent"),lastMapsMenu );
    menu->insertSeparator();
	
    a = new QAction( tr( "Save" ), QPixmap( iconPath+"filesave.png"), tr( "&Save..." ), CTRL + Key_S, this, "fileSave" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileSave() ) );
    a->addTo( tb );
    a->addTo( menu );
	actionFileSave=a;
	
    a = new QAction( tr( "Save &As" ), QPixmap(iconPath+"filesaveas.png"), tr( "Save &As..." ), 0, this, "fileSaveAs" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileSaveAs() ) );
    a->addTo( menu );

    menu->insertSeparator();

	importMenu = new QPopupMenu (this);
    menu->insertItem (tr("Import"),importMenu );

	a = new QAction( tr( "Import")+" "+tr("KDE Bookmarks" ), QPixmap(), tr("KDE Bookmarks"), 0, this, "importKDEBookmarks" );
	connect( a, SIGNAL( activated() ), this, SLOT( fileImportKDEBookmarks() ) );
	a->addTo (importMenu);

    if (settings.readBoolEntry( "/vym/mainwindow/showTestMenu",false)) 
	{
		a = new QAction( tr( "Import")+" "+tr("Firefox Bookmarks" ), QPixmap(), tr("Firefox Bookmarks"), 0, this, "importFirefoxBookmarks" );
		connect( a, SIGNAL( activated() ), this, SLOT( fileImportFirefoxBookmarks() ) );
		a->addTo (importMenu);
	}	

	a = new QAction( tr( "Import")+" Mind Manager" , QPixmap(), "Mind Manager...", 0, this, "importMM" );
	connect( a, SIGNAL( activated() ), this, SLOT( fileImportMM() ) );
	a->addTo (importMenu);

    a = new QAction( tr( "Import directory structure (experimental)" ), QPixmap(), tr( "Import Dir"+QString("...") ), 0, this, "export" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileImportDir() ) );
    a->addTo( importMenu);

	exportMenu = new QPopupMenu (this);
    menu->insertItem (tr("Export"),exportMenu );

    menu->insertSeparator();


    a = new QAction( tr( "Print" ), QPixmap( iconPath+"fileprint.png"), tr( "&Print")+QString("..."), CTRL + Key_P, this, "filePrint" );
    connect( a, SIGNAL( activated() ), this, SLOT( filePrint() ) );
    a->addTo( tb );
    a->addTo( menu );
	actionFilePrint=a;

    a = new QAction( tr( "Close Map" ), QPixmap(iconPath+"fileclose.png"), tr( "&Close Map" ), ALT + Key_C, this, "fileCloseMap" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileCloseMap() ) );
    a->addTo( menu );

    a = new QAction( tr( "Exit")+" "+__VYM, QPixmap(iconPath+"exit.png"), tr( "E&xit")+" "+__VYM, CTRL + Key_Q, this, "fileExitVYM" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileExitVYM() ) );
    a->addTo( menu );
}


//Edit Actions
void Main::setupEditActions()
{
    QToolBar *tb = new QToolBar( this );
    tb->setLabel( "Edit Actions" );
    QPopupMenu *menu = new QPopupMenu( this );
    menuBar()->insertItem( tr( "&Edit" ), menu );

    QAction *a;
	QAction *alt;
    a = new QAction( tr( "Undo" ), QPixmap( iconPath+"undo.png"), tr( "&Undo" ), CTRL + Key_Z, this, "editUndo" );
    connect( a, SIGNAL( activated() ), this, SLOT( editUndo() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionEditUndo=a;
    
    if (settings.readBoolEntry( "/vym/mainwindow/showTestMenu",false)) 
	{
		a = new QAction( tr( "Redo" ), QPixmap( iconPath+"redo.png"), tr( "&Redo" ), CTRL + Key_Y, this, "editRedo" ); 
		connect( a, SIGNAL( activated() ), this, SLOT( editRedo() ) );
		a->addTo( tb );
		a->addTo( menu );
	}
   
    menu->insertSeparator();
    a = new QAction( tr( "Copy" ), QPixmap( iconPath+"editcopy.png"), tr( "&Copy" ), CTRL + Key_C, this, "editCopy" );
    connect( a, SIGNAL( activated() ), this, SLOT( editCopy() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionEditCopy=a;
    a = new QAction( tr( "Cut" ), QPixmap( iconPath+"editcut.png" ), tr( "Cu&t" ), CTRL + Key_X, this, "editCut" );
    connect( a, SIGNAL( activated() ), this, SLOT( editCut() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionEditCut=a;
    a = new QAction( tr( "Paste" ), QPixmap( iconPath+"editpaste.png"), tr( "&Paste" ), CTRL + Key_V, this, "editPaste" );
    connect( a, SIGNAL( activated() ), this, SLOT( editPaste() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionEditPaste=a;

    // Shortcuts to modify heading:
    a = new QAction( tr( "edit Heading" ),tr( "Edit heading" ), Key_Enter, this, "editHeading" );
    connect( a, SIGNAL( activated() ), this, SLOT( editHeading() ) );
	actionListBranches.append(a);
    a = new QAction( tr( "edit Heading" ),tr( "Edit heading" ), Key_Return, this, "editHeading" );
    connect( a, SIGNAL( activated() ), this, SLOT( editHeading() ) );
	actionListBranches.append(a);
	actionEditHeading=a;
    a = new QAction( tr( "edit Heading" ),tr( "Edit heading" ), Key_F2, this, "editHeading" );
    connect( a, SIGNAL( activated() ), this, SLOT( editHeading() ) );
	a->setEnabled (false);
	actionEditHeading=a;
	actionListBranches.append(a);
    
    // Shortcut to delete selection
    a = new QAction( tr( "Delete Selection" ),tr( "Delete Selection" ), Key_Delete, this, "deleteBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editDeleteSelection() ) );
	a->setEnabled (false);
	actionEditDelete=a;
    
    // Shortcut to add branch
	alt = new QAction( tr( "Add a branch as child of selection" ),QPixmap(iconPath+"newbranch.png"),tr( "Add branch as child" ), Key_A, this, "newBranch" );
    connect( alt, SIGNAL( activated() ), this, SLOT( editNewBranch() ) );
		a = new QAction( tr( "Add a branch as child of selection" ),QPixmap(iconPath+"newbranch.png"),tr( "Add branch as child" ), Key_Insert, this, "newBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editNewBranch() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	#if defined (Q_OS_MACX)
		// In OSX show different shortcut in menues, the keys work independtly always			
		actionEditAddBranch=alt;
	#else	
		actionEditAddBranch=a;
	#endif	
    actionEditAddBranch->addTo( menu );
    actionEditAddBranch->addTo( tb );

    // Add branch by inserting it at selection
	a = new QAction( tr( "Add a branch by inserting and making selection its child" ),tr( "Add branch (insert)" ), ALT + Key_Insert, this, "newBranchHere" );
    connect( a, SIGNAL( activated() ), this, SLOT( editNewBranchHere() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditAddBranchHere=a;
	a = new QAction( tr( "Add a branch by inserting and making selection its child" ),tr( "Add branch (insert)" ), ALT + Key_A, this, "newBranchHere" );
    connect( a, SIGNAL( activated() ), this, SLOT( editNewBranchHere() ) );
	actionListBranches.append(a);

	// Add branch above
    a = new QAction( tr( "Add a branch above selection" ),tr( "Add branch above" ), SHIFT+Key_Insert, this, "newBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editNewBranchAbove() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditAddBranchAbove=a;
    a = new QAction( tr( "Add a branch above selection" ),tr( "Add branch above" ), SHIFT+Key_A, this, "newBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editNewBranchAbove() ) );
	actionListBranches.append(a);

	// Add branch below 
    a = new QAction( tr( "Add a branch below selection" ),tr( "Add branch below" ), CTRL +Key_Insert, this, "newBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editNewBranchBelow() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditAddBranchBelow=a;
    a = new QAction( tr( "Add a branch below selection" ),tr( "Add branch below" ), CTRL +Key_A, this, "newBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editNewBranchBelow() ) );
	actionListBranches.append(a);

    a = new QAction( tr( "Move branch up" ), QPixmap(iconPath+"up.png" ), tr( "Move up" ), Key_PageUp, this, "editMoveUp" );
    connect( a, SIGNAL( activated() ), this, SLOT( editMoveUp() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionEditMoveUp=a;

    a = new QAction( tr( "Move branch down" ), QPixmap( iconPath+"down.png"), tr( "Move down" ), Key_PageDown, this, "editMoveDown" );
    connect( a, SIGNAL( activated() ), this, SLOT( editMoveDown() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionEditMoveDown=a;
	

	a = new QAction( tr( "Scroll branch" ), QPixmap(flagsPath+"flag-scrolled-right.png"), tr( "Scroll branch" ), Key_ScrollLock, this, "scroll" );
    connect( a, SIGNAL( activated() ), this, SLOT( editToggleScroll() ) );
	alt = new QAction( tr( "Scroll branch" ), QPixmap(flagsPath+"flag-scrolled-right.png"), tr( "Scroll branch" ), Key_S, this, "scroll" );
    connect( alt, SIGNAL( activated() ), this, SLOT( editToggleScroll() ) );
	#if defined(Q_OS_MACX)
		actionEditToggleScroll=alt;
	#else	
		actionEditToggleScroll=a;
	#endif	
	actionEditToggleScroll->setEnabled (false);
	actionEditToggleScroll->setToggleAction(true);
    actionEditToggleScroll->addTo( tb );
    actionEditToggleScroll->addTo( menu );
	actionListBranches.append(actionEditToggleScroll);
	
    a = new QAction( tr( "Unscroll all" ), QPixmap(), tr( "Unscroll all scrolled branches" ), 0, this, "scroll" );
    connect( a, SIGNAL( activated() ), this, SLOT( editUnScrollAll() ) );
    a->addTo( menu );
	
    menu->insertSeparator();

	a = new QAction( tr( "Find" ), QPixmap(iconPath+"find.png"), tr( "Find"+QString("...") ), CTRL + Key_F, this, "find" );
    connect( a, SIGNAL( activated() ), this, SLOT( editOpenFindWindow() ) );
    a->addTo( menu );
    
	menu->insertSeparator();

	a = new QAction( tr( "Open URL" ), QPixmap(flagsPath+"flag-url.png"), tr( "Open URL" ), CTRL + Key_U, this, "url" );
    connect( a, SIGNAL( activated() ), this, SLOT( editOpenURL() ) );
    a->addTo( tb );
	a->setEnabled (false);
	actionEditOpenURL=a;

	a = new QAction( tr( "Open URL in new tab" ), QPixmap(), tr( "Open URL in new tab" ), CTRL + Key_U, this, "urltab" );
    connect( a, SIGNAL( activated() ), this, SLOT( editOpenURLTab() ) );
	a->setEnabled (false);
	actionEditOpenURLTab=a;

	a = new QAction( tr( "Edit URL" ), QPixmap(), tr( "Edit URL"+QString("...") ), SHIFT + CTRL + Key_U, this, "url" );
    connect( a, SIGNAL( activated() ), this, SLOT( editURL() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditURL=a;
	
	a = new QAction( tr( "Use heading of selected branch as URL" ), QPixmap(), tr( "Use heading for URL" ), 0, this, "heading2url" );
    connect( a, SIGNAL( activated() ), this, SLOT( editHeading2URL() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditHeading2URL=a;
    
	a = new QAction( tr( "Create URL to Bugzilla" ), QPixmap(), tr( "Create URL to Bugzilla" ), 0, this, "bugzilla2url" );
    connect( a, SIGNAL( activated() ), this, SLOT( editBugzilla2URL() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditBugzilla2URL=a;
    
	a = new QAction( tr( "Create URL to FATE" ), QPixmap(), tr( "Create URL to FATE" ), 0, this, "FATE2url" );
    connect( a, SIGNAL( activated() ), this, SLOT( editFATE2URL() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditFATE2URL=a;
	
    a = new QAction( tr( "Jump to another vym map, if needed load it first" ), QPixmap(flagsPath+"flag-vymlink.png"), tr( "Jump to map" ), 0, this, "jumpMap" );
    connect( a, SIGNAL( activated() ), this, SLOT( editOpenVymLink() ) );
    a->addTo( tb );
	a->setEnabled (false);
	actionEditOpenVymLink=a;
	
    a = new QAction( tr( "Edit link to another vym map" ), QPixmap(), tr( "Edit vym link"+QString("...") ), 0, this, "editLinkMap" );
    connect( a, SIGNAL( activated() ), this, SLOT( editVymLink() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditVymLink=a;

    a = new QAction( tr( "Delete link to another vym map" ), QPixmap(), tr( "Delete vym link" ), 0, this, "deleteLinkMap" );
    connect( a, SIGNAL( activated() ), this, SLOT( editDeleteVymLink() ) );
	a->setEnabled (false);
	actionEditDeleteVymLink=a;

    a = new QAction( tr( "Hide object in exports" ), QPixmap(flagsPath+"flag-hideexport.png"), tr( "Hide in exports" ), Key_H, this, "hideExport" );
    connect( a, SIGNAL( activated() ), this, SLOT( editToggleHideExport() ) );
	a->setToggleAction(true);
    a->addTo( tb );
	a->setEnabled (false);
	actionEditToggleHideExport=a;

    a = new QAction( tr( "Edit Map Info" ), QPixmap(), tr( "Edit Map Info"+QString("...") ), 0, this, "editMapInfo" );
    connect( a, SIGNAL( activated() ), this, SLOT( editMapInfo() ) );
	a->setEnabled (true);
	actionEditMapInfo=a;

	menu->insertSeparator();

	// Import at selection (adding to selection)
    a = new QAction( tr( "Add map at selection" ),tr( "Add map (insert)" ), 0, this, "importAdd" );
    connect( a, SIGNAL( activated() ), this, SLOT( editImportAdd() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditImportAdd=a;

	// Import at selection (replacing selection)
    a = new QAction( tr( "Replace selection with map" ),tr( "Add map (replace)" ), 0, this, "importReplace" );
    connect( a, SIGNAL( activated() ), this, SLOT( editImportReplace() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditImportReplace=a;

	// Save selection 
    a = new QAction( tr( "Save selection" ),tr( "Save selection" ), 0, this, "saveSelection" );
    connect( a, SIGNAL( activated() ), this, SLOT( editSaveBranch() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditSaveBranch=a;

	// Only remove branch, not its childs
    a = new QAction( tr( "Remove only branch and keep its childs" ),tr( "Remove only branch " ), ALT + Key_Delete, this, "removeBranchHere" );
    connect( a, SIGNAL( activated() ), this, SLOT( editRemoveBranchKeepChilds() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditRemoveBranchKeepChilds=a;

	// Only remove childs of a branch
    a = new QAction( tr( "Remove childs of branch" ),tr( "Remove childs" ), SHIFT + Key_Delete, this, "removeBranchChilds" );
    connect( a, SIGNAL( activated() ), this, SLOT( editRemoveChilds() ) );
	a->setEnabled (false);
	actionListBranches.append(a);
	actionEditRemoveChilds=a;

    // Shortcuts for navigating with cursor:
    a = new QAction( tr( "Select upper branch" ),tr( "Select upper branch" ), Key_Up, this, "upperBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editUpperBranch() ) );
    a = new QAction( tr( "Select lower branch" ),tr( "Select lower branch" ), Key_Down, this, "lowerBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editLowerBranch() ) );
    a = new QAction( tr( "Select left branch" ),tr( "Select left branch" ), Key_Left, this, "upperBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editLeftBranch() ) );
    a = new QAction( tr( "Select right branch" ),tr( "Select child branch" ), Key_Right, this, "rightBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editRightBranch() ) );
    a = new QAction( tr( "Select first branch" ),tr( "Select first branch" ), Key_Home, this, "firstBranch" );
	a->setEnabled (false);
    a->addTo ( menu );
	actionListBranches.append(a);
	actionEditSelectFirst=a;
    connect( a, SIGNAL( activated() ), this, SLOT( editFirstBranch() ) );
    a = new QAction( tr( "Select last branch" ),tr( "Select last branch" ), Key_End, this, "lastBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( editLastBranch() ) );
	a->setEnabled (false);
    a->addTo ( menu );
	actionListBranches.append(a);
	actionEditSelectLast=a;

    a = new QAction( tr( "Add Image" ),tr( "Add Image" )+QString("..."), 0, this, "loadImage" );
    connect( a, SIGNAL( activated() ), this, SLOT( editLoadImage() ) );
	actionEditLoadImage=a;

}

// Format Actions
void Main::setupFormatActions()
{
    QPopupMenu *menu = new QPopupMenu( this );
    menuBar()->insertItem( tr( "F&ormat" ), menu );

    QToolBar *tb = new QToolBar( this );
    QAction *a;
    QPixmap pix( 16,16);
    pix.fill (black);
    actionFormatColor= new QAction( tr( "Set Color" ), pix, tr( "Set &Color" )+QString("..."), 0, this, "formatColor" );
    connect( actionFormatColor, SIGNAL( activated() ), this, SLOT( formatSelectColor() ) );
    actionFormatColor->addTo( tb );
    actionFormatColor->addTo( menu );
    a= new QAction( tr( "Pick color\nHint: You can pick a color from another branch and color using CTRL+Left Button" ), QPixmap(iconPath+"formatcolorpicker.png"), tr( "Pic&k color" ), CTRL + Key_K, this, "pickColor" );
    connect( a, SIGNAL( activated() ), this, SLOT( formatPickColor() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionListBranches.append(a);
	actionFormatPickColor=a;
    a= new QAction( tr( "Color branch" ), QPixmap(iconPath+"formatcoloritem.png"), tr( "Color &branch" ), CTRL + Key_I, this, "colorItem" );
    connect( a, SIGNAL( activated() ), this, SLOT( formatColorItem() ) );
	a->setEnabled (false);
    a->addTo( tb );
    a->addTo( menu );
	actionListBranches.append(a);
	actionFormatColorBranch=a;
    a= new QAction( tr( "Color Subtree" ), QPixmap(iconPath+"formatcolorbranch.png"), tr( "Color sub&tree" ), CTRL + Key_T, this, "colorBranch" );
    connect( a, SIGNAL( activated() ), this, SLOT( formatColorBranch() ) );
	a->setEnabled (false);
    a->addTo( menu );
    a->addTo( tb );
	actionListBranches.append(a);
	actionFormatColorSubtree=a;

    menu->insertSeparator();
	actionGroupFormatLinkStyles=new QActionGroup ( this, "formatLinkStyles");
	actionGroupFormatLinkStyles->setExclusive (true);
    a= new QAction( tr( "Line" ), QPixmap(), tr( "Linkstyle Line" ), 0, actionGroupFormatLinkStyles, "formatLinkStyleLine" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatLinkStyleLine() ) );
	actionFormatLinkStyleLine=a;
    a= new QAction( tr( "Line" ), QPixmap(), tr( "Linkstyle Parabel" ), 0, actionGroupFormatLinkStyles, "formatLinkStyleLine" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatLinkStyleParabel() ) );
	actionFormatLinkStyleParabel=a;
    a= new QAction( tr( "PolyLine" ), QPixmap(), tr( "Linkstyle Thick Line" ), 0, actionGroupFormatLinkStyles, "formatLinkStyleLine" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatLinkStylePolyLine() ) );
	actionFormatLinkStylePolyLine=a;
    a= new QAction( tr( "PolyParabel" ), QPixmap(), tr( "Linkstyle Thick Parabel" ), 0, actionGroupFormatLinkStyles, "formatLinkStylePolyParabel" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatLinkStylePolyParabel() ) );
	actionFormatLinkStylePolyParabel=a;
	actionGroupFormatLinkStyles->addTo (menu);
	
	actionGroupFormatFrameTypes=new QActionGroup ( this, "formatFrameTypes");
	actionGroupFormatFrameTypes->setExclusive (true);
    a = new QAction( tr( "No Frame" ),tr( "No Frame" ), 0, actionGroupFormatFrameTypes, "frameNone" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatFrameNone() ) );
	actionFormatFrameNone=a;
    a = new QAction( tr( "Rectangle" ),tr( "Rectangle" ), 0, actionGroupFormatFrameTypes, "frameRectangle" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatFrameRectangle() ) );
	actionFormatFrameRectangle=a;

    a = new QAction( tr ("Include top and bottom position of images into branch"), tr( "Include images vertically" ), 0, actionFormatIncludeImagesVer, "includeImagesVer" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatIncludeImagesVer() ) );
	actionFormatIncludeImagesVer=a;

    a = new QAction( tr ("Include left and right position of images into branch"), tr( "Include images horizontally" ), 0, actionFormatIncludeImagesHor, "includeImagesHor" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatIncludeImagesHor() ) );
	actionFormatIncludeImagesHor=a;

    a = new QAction( tr( "Hide link" ),tr( "Hide link if object is not selected" ), 0, actionFormatHideLinkUnselected, "hideLinkUnselected" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatHideLinkUnselected() ) );
	actionFormatHideLinkUnselected=a;

    menu->insertSeparator();
    a= new QAction( tr( "Use same color for links and headings" ), QPixmap(), tr( "&Use color of heading for link" ), 0, this, "formatLinkColorHint" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( formatToggleLinkColorHint() ) );
	a->addTo( menu );
	actionFormatLinkColorHint=a;
    pix.fill (white);
    actionFormatLinkColor= new QAction( tr( "Set Link Color" ), pix, tr( "Set &Link Color"+QString("...") ), 0, this, "formatLinkColor" );
    connect( actionFormatLinkColor, SIGNAL( activated() ), this, SLOT( formatSelectLinkColor() ) );
    actionFormatLinkColor->addTo( menu );
    actionFormatBackColor= new QAction( tr( "Set Background Color" ), pix, tr( "Set &Background Color" )+QString("..."), 0, this, "formatBackColor" );
    connect( actionFormatBackColor, SIGNAL( activated() ), this, SLOT( formatSelectBackColor() ) );
    actionFormatBackColor->addTo( menu );
}

// View Actions
void Main::setupViewActions()
{
    QToolBar *tb = new QToolBar( this );
    tb->setLabel( "View Actions" );
    QPopupMenu *menu = new QPopupMenu( this );
    menuBar()->insertItem( tr( "&View" ), menu );

    QAction *a;
    a = new QAction( tr( "Zoom reset" ), QPixmap(iconPath+"viewmag-reset.png"), tr( "reset Zoom" ), CTRL + Key_0, this, "zoomReset" );
    connect( a, SIGNAL( activated() ), this, SLOT(viewZoomReset() ) );
    a->addTo( tb );
    a->addTo( menu );
    a = new QAction( tr( "Zoom in" ), QPixmap(iconPath+"viewmag+.png"), tr( "Zoom in" ), CTRL + Key_Plus, this, "zoomIn" );
    connect( a, SIGNAL( activated() ), this, SLOT(viewZoomIn() ) );
    a->addTo( tb );
    a->addTo( menu );
    a = new QAction( tr( "Zoom out" ), QPixmap(iconPath+"viewmag-.png"), tr( "Zoom out" ), CTRL + Key_Minus, this, "zoomOut" );
    connect( a, SIGNAL( activated() ), this, SLOT( viewZoomOut() ) );
    a->addTo( tb );
    a->addTo( menu );


    a = new QAction( tr( "Show Note Editor" ), QPixmap(flagsPath+"flag-note.png"), tr( "Show Note Editor" ), CTRL + Key_E , this, "noteEditor" );
    connect( a, SIGNAL( activated() ), this, SLOT(windowToggleNoteEditor() ) );
	a->setToggleAction(true);
	if (textEditor->showWithMain())
		a->setOn(true);
	else	
		a->setOn(false);
    a->addTo( tb );
    a->addTo( menu );
	actionViewToggleNoteEditor=a;

    a = new QAction( tr( "Show history window" ), QPixmap(), tr( "Show history window" ), CTRL + Key_H , this, "historyWindow" );
    connect( a, SIGNAL( activated() ), this, SLOT(windowToggleHistory() ) );
	a->setToggleAction(false);
    a->addTo( menu );
	actionViewToggleHistoryWindow=a;

    a = new QAction( tr( "&Next Window" ), QPixmap(), tr( "Next Window" ), ALT + Key_N , this, "nextWindow" );
    connect( a, SIGNAL( activated() ), this, SLOT(windowNextEditor() ) );
    a->addTo( menu );
    a = new QAction( tr( "&Previous Window" ), QPixmap(), tr( "Previous Window" ), ALT + Key_P , this, "previousWindow" );
    connect( a, SIGNAL( activated() ), this, SLOT(windowPreviousEditor() ) );
    a->addTo( menu );
}

// Mode Actions
void Main::setupModeActions()
{
    //QPopupMenu *menu = new QPopupMenu( this );
    //menuBar()->insertItem( tr( "&Mode (using modifiers)" ), menu );

    QToolBar *tb = new QToolBar( this );
    tb->setLabel( tr ("Modes when using modifiers") );
    QAction *a;
	actionGroupModModes=new QActionGroup ( this, "formatLinkStyles");
	actionGroupModModes->setExclusive (true);
    a= new QAction( tr( "Use modifier to color branches" ), QPixmap(iconPath+"modecolor.png"), 0, Key_J, actionGroupModModes, "modModeColor" );
	a->setToggleAction(true);
	a->addTo (tb);
	a->setOn(true);
	actionModModeColor=a;
	
    a= new QAction( tr( "Use modifier to copy" ), QPixmap(iconPath+"modecopy.png"), 0, Key_K, actionGroupModModes, "modModeCopy" );
	a->setToggleAction(true);
	a->addTo (tb);
	actionModModeCopy=a;

    a= new QAction( tr( "Use modifier to draw xLinks" ), QPixmap(iconPath+"modelink.png"), 0, Key_L, actionGroupModModes, "modModeLink" );
	a->setToggleAction(true);
	a->addTo (tb);
	actionModModeLink=a;
}

// Flag Actions
void Main::setupFlagActions()
{
	// Create System Flags
	systemFlagsDefault = new FlagRowObj ();
	systemFlagsDefault->setVisibility (false);
	systemFlagsDefault->setName ("systemFlagsDef");

	FlagObj *fo = new FlagObj ();
	fo->load(QPixmap(flagsPath+"flag-note.png"));
	fo->setName("note");
	fo->setToolTip(tr("Note","Systemflag"));
	systemFlagsDefault->addFlag (fo);	// makes deep copy

	fo->load(QPixmap(flagsPath+"flag-url.png"));
	fo->setName("url");
	fo->setToolTip(tr("WWW Document (external)","Systemflag"));
	systemFlagsDefault->addFlag (fo);
	
	fo->load(QPixmap(flagsPath+"flag-vymlink.png"));
	fo->setName("vymLink");
	fo->setToolTip(tr("Link to another vym map","Systemflag"));
	systemFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-scrolled-right.png"));
	fo->setName("scrolledright");
	fo->setToolTip(tr("subtree is scrolled","Systemflag"));
	systemFlagsDefault->addFlag (fo);
	
	fo->load(QPixmap(flagsPath+"flag-tmpUnscrolled-right.png"));
	fo->setName("tmpUnscrolledright");
	fo->setToolTip(tr("subtree is temporary scrolled","Systemflag"));
	systemFlagsDefault->addFlag (fo);

	fo->load(QPixmap(flagsPath+"flag-hideexport.png"));
	fo->setName("hideInExport");
	fo->setToolTip(tr("Hide object in exported maps","Systemflag"));
	systemFlagsDefault->addFlag (fo);

	// Create Standard Flags
	standardFlagsDefault = new FlagRowObj ();
	standardFlagsDefault->setVisibility (false);
	standardFlagsDefault->setName ("standardFlagsDef");

	fo->load(QPixmap(flagsPath+"flag-exclamationmark.png"));
	fo->setName ("exclamationmark");
	fo->setGroup("standard-mark");
	fo->setToolTip(tr("Take care!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	// makes deep copy
	
	fo->load(QPixmap(flagsPath+"flag-questionmark.png"));
	fo->setName("questionmark");
	fo->setGroup("standard-mark");
	fo->setToolTip(tr("Really?","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-hook-green.png"));
	fo->setName("hook-green");
	fo->setGroup("standard-hook");
	fo->setToolTip(tr("ok!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-cross-red.png"));
	fo->setName("cross-red");
	fo->setGroup("standard-hook");
	fo->setToolTip(tr("Not ok!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-stopsign.png"));
	fo->setName("stopsign");
	fo->setToolTip(tr("This won't work!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-smiley-good.png"));
	fo->setName("smiley-good");
	fo->setGroup("standard-smiley");
	fo->setToolTip(tr("Good","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-smiley-sad.png"));
	fo->setName("smiley-sad");
	fo->setGroup("standard-smiley");
	fo->setToolTip(tr("Bad","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-smiley-omg.png"));
	// Original omg.png (in KDE emoticons)
	fo->setName("smiley-omg");
	fo->setGroup("standard-smiley");
	fo->setToolTip(tr("Oh no!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-kalarm.png"));
	fo->setName("clock");
	fo->setToolTip(tr("Time critical","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-phone.png"));
	fo->setName("phone");
	fo->setToolTip(tr("Call...","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-lamp.png"));
	fo->setName("lamp");
	fo->setToolTip(tr("Idea!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-arrow-up.png"));
	fo->setName("arrow-up");
	fo->setGroup("standard-arrow");
	fo->setToolTip(tr("Important","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-arrow-down.png"));
	fo->setName("arrow-down");
	fo->setGroup("standard-arrow");
	fo->setToolTip(tr("Unimportant","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-arrow-2up.png"));
	fo->setName("2arrow-up");
	fo->setGroup("standard-arrow");
	fo->setToolTip(tr("Very important!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-arrow-2down.png"));
	fo->setName("2arrow-down");
	fo->setGroup("standard-arrow");
	fo->setToolTip(tr("Very unimportant!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-thumb-up.png"));
	fo->setName("thumb-up");
	fo->setGroup("standard-thumb");
	fo->setToolTip(tr("I like this","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-thumb-down.png"));
	fo->setName("thumb-down");
	fo->setGroup("standard-thumb");
	fo->setToolTip(tr("I like this","Standardflag"));
	fo->setToolTip(tr("I do not like this","Standardflag"));
	standardFlagsDefault->addFlag (fo);	
	
	fo->load(QPixmap(flagsPath+"flag-rose.png"));
	fo->setName("rose");
	fo->setToolTip(tr("Rose","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-heart.png"));
	fo->setName("heart");
	fo->setToolTip(tr("I just love... ","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-present.png"));
	fo->setName("present");
	fo->setToolTip(tr("Surprise!","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-flash.png"));
	fo->setName("flash");
	fo->setToolTip(tr("Dangerous","Standardflag"));
	standardFlagsDefault->addFlag (fo);	
	
	fo->load(QPixmap(flagsPath+"flag-info.png"));
	// Original: xsldbg_output.png
	fo->setName("info");
	fo->setToolTip(tr("Info","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	fo->load(QPixmap(flagsPath+"flag-lifebelt.png"));
	// Original khelpcenter.png
	fo->setName("lifebelt");
	fo->setToolTip(tr("This will help","Standardflag"));
	standardFlagsDefault->addFlag (fo);	

	delete (fo);

	standardFlagsDefault->makeToolbar(this, "Standard Flags");
}

// Settings Actions
void Main::setupSettingsActions()
{
    QPopupMenu *menu = new QPopupMenu( this );
    menuBar()->insertItem( tr( "&Settings" ), menu );

	QAction *a;


    a = new QAction( tr( "Set application to open pdf files"), QPixmap(), tr( "Set application to open pdf files  ...") , 0, this, "setPDF" );
    connect( a, SIGNAL( activated() ), this, SLOT( settingsPDF() ) );
    a->addTo( menu );

    a = new QAction( tr( "Set application to open external links"), QPixmap(), tr( "Set application to open external links..."), 0, this, "setURL" );
    connect( a, SIGNAL( activated() ), this, SLOT( settingsURL() ) );
    a->addTo( menu );

    menu->insertSeparator();
    a = new QAction( tr( "Edit branch after adding it" ), QPixmap(), tr( "Edit branch after adding it" ), 0, this, "autoedit" );
	a->setToggleAction(true);
	a->setOn ( settings.readBoolEntry ("/vym/mapeditor/editmode/autoedit",true) );
    a->addTo( menu );
	actionSettingsAutoedit=a;

    a= new QAction( tr( "Select branch after adding it" ), QPixmap(), tr( "Select branch after adding it" ), 0, this, "autoselectheading" );
	a->setToggleAction(true);
	a->setOn ( settings.readBoolEntry ("/vym/mapeditor/editmode/autoselect",false) );
    a->addTo( menu );
	actionSettingsAutoselectHeading=a;
	
    a= new QAction( tr( "Select heading before editing" ), QPixmap(), tr( "Select existing heading" ), 0, this, "autoselectexistingtext" );
	a->setToggleAction(true);
	a->setOn ( settings.readBoolEntry ("/vym/mapeditor/editmode/autoselectexistingtext",true) );
    a->addTo( menu );
	actionSettingsAutoselectText=a;
	
    a= new QAction( tr( "Pasting into new branch" ), QPixmap(), tr( "pasting into new branch" ), 0, this, "pastenewheading" );
	a->setToggleAction(true);
	a->setOn ( settings.readBoolEntry ("/vym/mapeditor/editmode/newheadingisempty",true) );
    a->addTo( menu );
	actionSettingsPasteNewHeading=a;
	
    a= new QAction( tr( "Delete key for deleting branches" ), QPixmap(), tr( "Delete key" ), 0, this, "delkey" );
	a->setToggleAction(true);
	a->setOn ( settings.readBoolEntry ("/vym/mapeditor/editmode/useDelKey",false) );
    a->addTo( menu );
    connect( a, SIGNAL( activated() ), this, SLOT( settingsToggleDelKey() ) );
	actionSettingsUseDelKey=a;

    a= new QAction( tr( "Use exclusive flags in flag toolbars" ), QPixmap(), tr( "Exclusive flags" ), 0, this, "flaggroups" );
	a->setToggleAction(true);
	a->setOn ( settings.readBoolEntry ("/vym/mapeditor/editmode/useFlagGroups",true) );
    a->addTo( menu );
	actionSettingsUseFlagGroups=a;
	
    a= new QAction( tr( "Use hide flag during exports " ), QPixmap(), tr( "Use hide flags" ), 0, this, "hideexport" );
	a->setToggleAction(true);
	a->setOn ( settings.readBoolEntry ("/vym/export/useHideExport",true) );
    a->addTo( menu );
	actionSettingsUseHideExport=a;
}

// Test Actions
void Main::setupTestActions()
{
    QPopupMenu *menu = new QPopupMenu( this );
    menuBar()->insertItem( tr( "&Test" ), menu );

    QAction *a;
    a = new QAction( tr( "Call test function" ), QPixmap(), tr( "test flag" ), 0, this, "flag" );
    connect( a, SIGNAL( activated() ), this, SLOT( testFunction() ) );
    a->addTo( menu );
}

// Help Actions
void Main::setupHelpActions()
{
    QPopupMenu *menu = new QPopupMenu( this );
    menuBar()->insertItem( tr( "&Help" ), menu );

    QAction *a;
    a = new QAction( tr( "Open VYM Documentation (pdf)" ), QPixmap(), tr( "Open VYM Documentation (pdf) " ), 0, this, "about" );
    connect( a, SIGNAL( activated() ), this, SLOT( helpDoc() ) );
    a->addTo( menu );

    a = new QAction( tr( "About VYM")+" "__VYM, QPixmap(), tr( "About VYM" ), 0, this, "about" );
    connect( a, SIGNAL( activated() ), this, SLOT( helpAbout() ) );
    a->addTo( menu );

    a = new QAction( tr( "Information about QT toolkit" ), QPixmap(), tr( "About QT" ), 0, this, "about" );
    connect( a, SIGNAL( activated() ), this, SLOT( helpAboutQT() ) );
    a->addTo( menu );
}

// Context Menus
void Main::setupContextMenus()
{
	QAction*a;

	// Context Menu for branch or mapcenter
	branchContextMenu =new QPopupMenu (this);

		// Submenu "Add"
		branchAddContextMenu =new QPopupMenu (this);
		actionEditPaste->addTo ( branchAddContextMenu );
		actionEditAddBranch->addTo ( branchAddContextMenu );
		actionEditAddBranchHere->addTo ( branchAddContextMenu );
		actionEditAddBranchAbove->addTo ( branchAddContextMenu );
		actionEditAddBranchBelow->addTo ( branchAddContextMenu );
		branchAddContextMenu->insertSeparator();	
		actionEditLoadImage->addTo( branchAddContextMenu );
		branchAddContextMenu->insertSeparator();	
		actionEditImportAdd->addTo ( branchAddContextMenu );
		actionEditImportReplace->addTo ( branchAddContextMenu );

		// Submenu "Remove"
		branchRemoveContextMenu =new QPopupMenu (this);
		actionEditCut->addTo ( branchRemoveContextMenu );
		actionEditDelete->addTo ( branchRemoveContextMenu );
		actionEditRemoveBranchKeepChilds->addTo( branchRemoveContextMenu );
		actionEditRemoveChilds->addTo( branchRemoveContextMenu );
		
	branchContextMenu->insertItem (tr("Add"),branchAddContextMenu);	
	branchContextMenu->insertItem (tr("Remove"),branchRemoveContextMenu);	

	actionEditSaveBranch->addTo( branchContextMenu );

	branchContextMenu->insertSeparator();	
	actionEditOpenURL->addTo ( branchContextMenu );
	actionEditOpenURLTab->addTo ( branchContextMenu );
	actionEditURL->addTo ( branchContextMenu );
	actionEditHeading2URL->addTo ( branchContextMenu );
	actionEditBugzilla2URL->addTo( branchContextMenu );
    if (settings.readBoolEntry( "/vym/mainwindow/showTestMenu",false)) 
	{
		actionEditFATE2URL->addTo( branchContextMenu );
	}	
	branchContextMenu->insertSeparator();	
	actionEditOpenVymLink->addTo ( branchContextMenu );
	actionEditVymLink->addTo ( branchContextMenu );
	actionEditDeleteVymLink->addTo ( branchContextMenu );
	
	branchContextMenu->insertSeparator();	
	actionGroupFormatFrameTypes->addTo( branchContextMenu );

	branchContextMenu->insertSeparator();	
	actionFormatIncludeImagesVer->addTo( branchContextMenu );
	actionFormatIncludeImagesHor->addTo( branchContextMenu );
	actionFormatHideLinkUnselected->addTo( branchContextMenu );

	// Context Menu for links in a branch menu
	// This will be populated "on demand" in MapEditor::updateActions
	branchContextMenu->insertSeparator();	
	branchLinksContextMenu =new QPopupMenu (this);
	branchLinksContextMenuDup =new QPopupMenu (this);
	branchContextMenu->insertItem (tr("Edit XLink"),branchLinksContextMenuDup);
	connect( branchLinksContextMenuDup, SIGNAL( activated(int) ), this, SLOT( editEditXLink(int ) ) );

	branchContextMenu->insertItem (tr("Goto XLink"),branchLinksContextMenu);
	connect( branchLinksContextMenu, SIGNAL( activated(int) ), this, SLOT( editFollowXLink(int ) ) );
	
	// Context menu for floatimage
	floatimageContextMenu =new QPopupMenu (this);
	saveImageFormatMenu=new QPopupMenu (this);
	exportImageFormatMenu=new QPopupMenu (this);

	QStrList fmt = QImage::outputFormats();
	for (const char* f = fmt.first(); f; f = fmt.next()) 
	{
		saveImageFormatMenu->insertItem( f );
		exportImageFormatMenu->insertItem( f );
	}	
	connect( saveImageFormatMenu, SIGNAL( activated(int) ), this, SLOT( editSaveImage(int ) ) );
	connect( exportImageFormatMenu, SIGNAL( activated(int) ), this, SLOT( fileExportImage(int ) ) );
	floatimageContextMenu->insertItem( tr("Save image"),saveImageFormatMenu );
	
	floatimageContextMenu->insertSeparator();	
	actionEditCopy->addTo( floatimageContextMenu );
	actionEditCut->addTo( floatimageContextMenu );

/* FIXME not needed any longer
	floatimageContextMenu->insertSeparator();	
    a = new QAction( tr( "Use for Export" ), QPixmap(), tr( "Use for Export"), 0, this, "useForExport" );
	a->setToggleAction(true);
    connect( a, SIGNAL( activated() ), this, SLOT( editToggleFloatExport() ) );
    a->addTo( floatimageContextMenu);
	actionEditToggleFloatExport=a;
	*/

	floatimageContextMenu->insertSeparator();	
	actionFormatHideLinkUnselected->addTo( floatimageContextMenu );

	exportMenu->insertItem ( tr("Export as")+" Image",exportImageFormatMenu);

	a = new QAction( tr( "Export in Open Document Format used e.g. in Open Office " ), QPixmap(), "Open Office"+QString("..."), 0, this, "exportOOPresentation" );
	connect( a, SIGNAL( activated() ), this, SLOT( fileExportOOPresentation() ) );
	a->addTo (exportMenu);

	a = new QAction( tr( "Export as")+" webpage (XHTML)" , QPixmap(), "Webpage (XHTML)...", ALT + Key_X, this, "exportXHTML" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileExportXHTML() ) );
    a->addTo( exportMenu );

    a = new QAction( tr( "Export as")+" ASCII"+" "+tr("(still experimental)" ), QPixmap(), "Text (ASCII)...", 0, this, "exportASCII" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileExportASCII() ) );
	a->addTo( exportMenu );

	a = new QAction( tr( "Export as")+" "+tr("KDE Bookmarks" ), QPixmap(), tr("KDE Bookmarks"), 0, this, "importKDEBookmarks" );
	connect( a, SIGNAL( activated() ), this, SLOT( fileExportKDEBookmarks() ) );
	a->addTo (exportMenu);

    a = new QAction( tr( "Export as")+" Taskjuggler"+" "+tr("(still experimental)" ), QPixmap(), "Taskjuggler...", 0, this, "exportTJ" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileExportTaskjuggler() ) );
	a->addTo( exportMenu );

    a = new QAction( tr( "Export as")+" LaTeX"+" "+tr("(still experimental)" ), QPixmap(), "LaTeX...", 0, this, "exportLaTeX" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileExportLaTeX() ) );
	a->addTo( exportMenu );

	a = new QAction( tr( "Export as")+" XML" , QPixmap(), "XML...",  0, this, "exportXML" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileExportXML() ) );
    a->addTo( exportMenu );
	
	// Context menu for canvas
	canvasContextMenu =new QPopupMenu (this);
	actionEditMapInfo->addTo( canvasContextMenu );
	canvasContextMenu->insertSeparator();	
	actionGroupFormatLinkStyles->addTo( canvasContextMenu );
	canvasContextMenu->insertSeparator();	
	actionFormatLinkColorHint->addTo( canvasContextMenu );
	actionFormatLinkColor->addTo( canvasContextMenu );
	actionFormatBackColor->addTo( canvasContextMenu );

	// Menu for last opened files
	// Read settings initially
	QString s;
	int j=settings.readNumEntry( "/vym/lastMaps/number",0);
	for (int i=1;i<=j;i++)
	{
		s=settings.readEntry(QString("/vym/lastMaps/map-%1").arg(i),"");
		if (!s.isEmpty() && j<=maxLastMaps) 
			lastMaps.append(s);
	}
	setupLastMapsMenu();
	connect( lastMapsMenu, SIGNAL( activated(int) ), this, SLOT( fileLoadLast(int ) ) );
}

void Main::setupLastMapsMenu()
{
	// Remove double entries
	QStringList::Iterator it=lastMaps.begin();
	QStringList::Iterator jt;
	while (it!=lastMaps.end() )
	{
		jt=it;
		++jt;
		while (jt!=lastMaps.end() )
		{
			if (*it == *jt)		
				jt=lastMaps.remove(jt);
			else	
				jt++;
		}
		it++;
	}	

	// Limit length of list to maxLastMaps
	while ((int)(lastMaps.count()) > maxLastMaps) lastMaps.pop_back();
	
	// build Menu from lastMaps string list
	lastMapsMenu->clear();
	for (it = lastMaps.begin(); it != lastMaps.end(); ++it ) 
		lastMapsMenu->insertItem (*it );
		
}

void Main::hideEvent (QHideEvent * )
{
	if (!textEditor->isMinimized() ) textEditor->hide();
}

void Main::showEvent (QShowEvent * )
{
	if (textEditor->showWithMain()) textEditor->showNormal();
}

bool Main::reallyWriteDirectory(const QString &dir)
{
	QStringList eList = QDir(dir).entryList();
	if (eList.first() ==".")  eList.pop_front();	// remove "."
	if (eList.first() =="..") eList.pop_front();	// remove "."
	if (!eList.isEmpty())
	{
		QMessageBox mb( __VYM,
			tr("The directory %1 is not empty.\nDo you risk to overwrite its contents?").arg(dir),
		QMessageBox::Warning,
		QMessageBox::Yes ,
		QMessageBox::Cancel | QMessageBox::Default,
		QMessageBox::QMessageBox::NoButton );

		mb.setButtonText( QMessageBox::Yes, tr("Overwrite") );
		mb.setButtonText( QMessageBox::No, tr("Cancel"));
		switch( mb.exec() ) 
		{
			case QMessageBox::Yes:
				// save 
				return true;
			case QMessageBox::Cancel:
				// do nothing
				return false;
		}
	}
	return true;
}

QString Main::browseDirectory (const QString &caption)
{
	QFileDialog fd(this,caption);
	fd.setMode (QFileDialog::DirectoryOnly);
	fd.setCaption(__VYM " - "+caption);
	fd.show();
	
	if ( fd.exec() == QDialog::Accepted )
		return fd.selectedFile();
	else
		return "";
}

MapEditor* Main::currentMapEditor() const
{
    if ( tabWidget->currentPage() &&
	 tabWidget->currentPage()->inherits( "MapEditor" ) )
		return (MapEditor*)tabWidget->currentPage();
    return NULL;	
}

//TODO not used now, maybe use this for overview window later
void Main::newView() 
{
    // Open a new view... have it delete when closed.
    Main *m = new Main(0, 0, WDestructiveClose);
    qApp->setMainWidget(m);
    m->show();
    qApp->setMainWidget(0);
}

void Main::editorChanged(QWidget *)
{
	// Unselect all possibly selected objects
	// (Important to update note editor)
	int i;
	MapEditor *me;
	for (i=0;i<=tabWidget->count() -1;i++)
	{
		
		me=(MapEditor*)tabWidget->page(i);
		me->unselect();
	}	
	currentMapEditor()->reselect();

	// Update actions to in menus and toolbars according to editor
	currentMapEditor()->updateActions();
}

void Main::fileNew()
{
	QString fn="unnamed";
	MapEditor* medit = new MapEditor (tabWidget, true);
	tabWidget->addTab (medit,fn);
	tabWidget->showPage(medit);
	medit->viewport()->setFocus();
		// For the very first map we do not have flagrows yet...
		medit->select("mc:");
}

ErrorCode Main::fileLoad(QString fn, const LoadMode &lmode)
{
	ErrorCode err=success;
	
	// fn is usually the archive, mapfile the file after uncompressing
	QString mapfile;

	// Make fn absolute (needed for unzip)
	fn=QDir (fn).absPath();

	MapEditor *me;

	if (lmode==NewMap)
	{
		// Check, if map is already loaded
		int i=0;
		while (i<=tabWidget->count() -1)
		{
			me=(MapEditor*)tabWidget->page(i);
			if (me->getFilePath() == fn)
			{
				// Already there, ask for confirmation
				QMessageBox mb( __VYM,
					tr("The map %1\nis already opened."
					"Opening the same map in multiple editors may lead \n"
					"to confusion when finishing working with vym."
					"Do you want to").arg(fn),
					QMessageBox::Warning,
					QMessageBox::Yes | QMessageBox::Default,
					QMessageBox::Cancel | QMessageBox::Escape,
					QMessageBox::QMessageBox::NoButton);
				mb.setButtonText( QMessageBox::Yes, tr("Open anyway") );
				mb.setButtonText( QMessageBox::Cancel, tr("Cancel"));
				switch( mb.exec() ) 
				{
					case QMessageBox::Yes:
						// load anyway
						i=tabWidget->count();
						break;
					case QMessageBox::Cancel:
						// do nothing
						return aborted;
						break;
				}
			}
			i++;
		}
	}


	// Try to load map
    if ( !fn.isEmpty() )
	{
		me = currentMapEditor();
		int tabIndex=tabWidget->currentPageIndex();
		// Check first, if mapeditor exists
		// If it is not default AND we want a new map, 
		// create a new mapeditor in a new tab
		if ( lmode==NewMap && (!me || !me->isDefault() ) )
		{
			me = new MapEditor (tabWidget,true);
			tabWidget->addTab (me,fn);
			tabIndex=tabWidget->indexOf (me);
			tabWidget->setCurrentPage (tabIndex);
		}
		
		// Check, if file exists (important for creating new files
		// from command line
		if (!QFile(fn).exists() )
		{
			QMessageBox mb( __VYM,
				tr("This map does not exist:\n  %1\nDo you want to create a new one?").arg(fn),
				QMessageBox::Question,
				QMessageBox::Yes ,
				QMessageBox::Cancel | QMessageBox::Default,
				QMessageBox::QMessageBox::NoButton );

			mb.setButtonText( QMessageBox::Yes, tr("Create"));
			mb.setButtonText( QMessageBox::No, tr("Cancel"));
			switch( mb.exec() ) 
			{
				case QMessageBox::Yes:
					// Create new map
					currentMapEditor()->setFilePath(fn);
					tabWidget->setTabLabel (currentMapEditor(),
						currentMapEditor()->getFileName() );
					statusBar()->message( "Created " + fn , statusbarTime );
					return success;
						
				case QMessageBox::Cancel:
					// don't create new map
					statusBar()->message( "Loading " + fn + " failed!", statusbarTime );
					fileCloseMap();
					return aborted;
			}
		}	


		//tabWidget->currentPage() won't be NULL here, because of above...
		tabWidget->showPage(me);
		me->viewport()->setFocus();

		// Create temporary directory for packing
		char tmpdir1[]="/tmp/vym-XXXXXX";	
		QString tmpMapDir=mkdtemp(tmpdir1);

		// Try to unzip file
		err=unzipDir (tmpMapDir,fn);
		if (err==nozip)
		{
			mapfile=fn;
			me->setZipped(false);
		} else
		{
			me->setZipped(true);
			
			// Look for mapname.xml
			mapfile= fn.left(fn.findRev(".",-1,true));
			mapfile=mapfile.section( '/', -1 );
			QFile file( tmpMapDir + "/" + mapfile + ".xml");
			if (!file.exists() )
			{
				// mapname.xml does not exist, well, 
				// maybe some renamed the mapname.vym file...
				// Try to find any .xml in the toplevel 
				// directory of the .vym file
				QStringList flist=QDir (tmpMapDir).entryList("*.xml");
				if (flist.count()==1) 
				{
					// Only one entry, take this one
					mapfile=tmpMapDir + "/"+flist.first();
				} else
				{
					for ( QStringList::Iterator it = flist.begin(); it != flist.end(); ++it ) 
						*it=tmpMapDir + "/" + *it;
					// TODO Multiple entries, load all (but only the first one into this ME)
					//mainWindow->fileLoadFromTmp (flist);
					//returnCode=1;	// Silently forget this attempt to load
					qWarning ("MainWindow::load (fn)  multimap found...");
				}	
					
				if (flist.isEmpty() )
				{
					QMessageBox::critical( 0, tr( "Critical Load Error" ),
							   tr("Couldn't find a map (*.xml) in .vym archive.\n"));
					err=aborted;				   
				}	
			} //file doesn't exist	
			else
				mapfile=file.name();
		}

		if (err!=aborted)
		{
			// Save existing filename in case  we import
			QString fn_org=me->getFilePath();

			// Finally load map into mapEditor
			me->setFilePath (mapfile,fn);
			err=me->load(mapfile,lmode);

			// Restore old (maybe empty) filepath, if this is an import
			if (lmode!=NewMap)
				me->setFilePath (fn_org);
		}	

		// Finally check for errors and go home
		if (err==aborted) 
		{
			if (lmode==NewMap) fileCloseMap();
			statusBar()->message( "Could not load " + fn, statusbarTime );
		} else 
		{
			if (lmode==NewMap)
			{
				me->setFilePath (fn);
				tabWidget->changeTab(tabWidget->page(tabIndex), me->getFileName());
				if (fn.left(9)!="/tmp/vym-")
				{
					// Only append to lastMaps if not loaded from a tmpDir
					// e.g. imported bookmarks are in a tmpDir
					lastMaps.prepend(me->getFilePath() );
					setupLastMapsMenu();
				}
				actionFilePrint->setEnabled (true);
			}	
			statusBar()->message( "Loaded " + fn, statusbarTime );
		}	

		// Delete tmpDir
		removeDir (QDir(tmpMapDir));
	}
	return err;
}


void Main::fileLoad(const LoadMode &lmode)
{
	QFileDialog *fd=new QFileDialog( this);
	if (!lastFileDir.isEmpty()) 
		fd->setDir (lastFileDir);
	fd->setMode (QFileDialog::ExistingFiles);
	fd->addFilter ("XML (*.xml)");
	fd->addFilter ("VYM map (*.vym *.vyp)");
	switch (lmode)
	{
		case NewMap:
			fd->setCaption(tr("Load vym map"));
			break;
		case ImportAdd:
			fd->setCaption(tr("Import: Add vym map to selection"));
			break;
		case ImportReplace:
			fd->setCaption(tr("Import: Replace selection with vym map"));
			break;
	}
	fd->show();

	QString fn;
	if ( fd->exec() == QDialog::Accepted )
	{
		lastFileDir=fd->dirPath();
	    QStringList flist = fd->selectedFiles();
		QStringList::Iterator it = flist.begin();
		while( it != flist.end() ) 
		{
			fn = *it;
			fileLoad(*it, lmode);				   
			++it;
		}
	}
	delete (fd);
}

void Main::fileLoad()
{
	fileLoad (NewMap);
}

void Main::fileLoadLast(int i)
{
	fileLoad(*lastMaps.at(lastMapsMenu->indexOf (i) ),NewMap);			   
}

void Main::fileSave(const SaveMode &savemode)
{
	// tmp dir for zipping 
	QString tmpMapDir;
	
	// Error codes
	ErrorCode err=success;
	
	QString safeFilePath;

	bool saveZipped=currentMapEditor()->saveZipped();

	MapEditor *	me=currentMapEditor();
	if (me)
	{
		QString fn=me->getFilePath();
		// filename=unnamed, filepath="" in constructor...
		if ( !fn.isEmpty() ) 
		{	
			// We have a filepath, go on saving			
			// First remove existing file, we 
			// don't want to add to old zip archives
			QFile f(fn);
			if (f.exists() ) 
				if (!f.remove())
					QMessageBox::warning( 0, tr( "Save Error" ),
						fn+   tr("\ncould not be removed before saving"));

			// Look, if we should zip the data:
			if (!saveZipped)
			{
				QMessageBox mb( __VYM,
					tr("The map %1\ndid not use the compressed "
					"vym file format.\nWriting it uncompressed will also write images \n"
					"and flags and thus may overwrite files in the "
					"given directory\n\nDo you want to write the map").arg(fn),
					QMessageBox::Warning,
					QMessageBox::Yes | QMessageBox::Default,
					QMessageBox::No ,
					QMessageBox::Cancel | QMessageBox::Escape);
				mb.setButtonText( QMessageBox::Yes, tr("compressed (vym default)") );
				mb.setButtonText( QMessageBox::No, tr("uncompressed") );
				mb.setButtonText( QMessageBox::Cancel, tr("Cancel"));
				switch( mb.exec() ) 
				{
					case QMessageBox::Yes:
						// save compressed (default file format)
						saveZipped=true;
						break;
					case QMessageBox::No:
						// save uncompressed
						saveZipped=false;
						break;
					case QMessageBox::Cancel:
						// do nothing
						return;
						break;
				}
			}

			if (saveZipped)
			{
				char tmpdir1[]="/tmp/vym-XXXXXX";	
				tmpMapDir=mkdtemp(tmpdir1);
			
				safeFilePath=me->getFilePath();
				me->setFilePath (tmpMapDir+"/"+
					me->getMapName()+ ".xml",
					safeFilePath);
				me->save (savemode);
				me->setFilePath (safeFilePath);
				
				zipDir (tmpMapDir,fn);
			} // save zipped
			else
			{
				// Save unzipped. 
				safeFilePath=me->getFilePath();
				me->setFilePath (fn, safeFilePath);
				me->save (savemode);
				me->setFilePath (safeFilePath);
			} // save zipped 	
		} // filepath available
		else
		{
			// We have  no filepath yet,
			// call fileSaveAs() now, this will call fileSave() 
			// again.
			fileSaveAs(savemode);
		}
    }

	if (saveZipped && !tmpMapDir.isEmpty())
		// Delete tmpDir
		removeDir (QDir(tmpMapDir));

	if (err==success)
	{
		statusBar()->message( 
			tr("Saved  %1").arg(me->getFilePath()), 
			statusbarTime );
		lastMaps.prepend(me->getFilePath() );
		setupLastMapsMenu();
	} else		
		statusBar()->message( 
			tr("Couldn't save ").arg(me->getFilePath()), 
			statusbarTime );
}

void Main::fileSave()
{
	fileSave (CompleteMap);
}

void Main::fileSaveAs(const SaveMode& savemode)
{
	QString fn;

	if (currentMapEditor())
	{
		if (savemode==CompleteMap)
			fn = QFileDialog::getSaveFileName( QString::null, "VYM map (*.vym)", this );
		else		
			fn = QFileDialog::getSaveFileName( QString::null, "VYM part of map (*.vyp)", this );
		if ( !fn.isEmpty() ) 
		{
			// Check for existing file
			if (QFile (fn).exists())
			{
				QMessageBox mb( __VYM,
					tr("The file %1\nexists already. Do you want to").arg(fn),
					QMessageBox::Warning,
					QMessageBox::Yes | QMessageBox::Default,
					QMessageBox::Cancel | QMessageBox::Escape,
					QMessageBox::QMessageBox::NoButton);
				mb.setButtonText( QMessageBox::Yes, tr("Overwrite") );
				mb.setButtonText( QMessageBox::Cancel, tr("Cancel"));
				switch( mb.exec() ) 
				{
					case QMessageBox::Yes:
						// save 
						break;
					case QMessageBox::Cancel:
						// do nothing
						return;
						break;
				}
			} else
			{
				// New file, add extension to filename, if missing
				// This is always .vym or .vyp, depending on savemode
				if (savemode==CompleteMap)
				{
					if (!fn.contains (".vym") && !fn.contains (".xml"))
						fn +=".vym";
				} else		
				{
					if (!fn.contains (".vyp") && !fn.contains (".xml"))
						fn +=".vyp";
				}
			}
	



			// Save now
			currentMapEditor()->setFilePath(fn);
			fileSave(savemode);

			// Set name of tab
			if (savemode==CompleteMap)
				tabWidget->setTabLabel (currentMapEditor(),
					currentMapEditor()->getFileName() );
			return;
		} 
	}
}

void Main::fileSaveAs()
{
	fileSaveAs (CompleteMap);
}

void Main::fileImportKDEBookmarks()
{
	ImportKDEBookmarks im;
	im.transform();
	if (success==fileLoad (im.getTransformedFile(),NewMap) && currentMapEditor() )
		currentMapEditor()->setFilePath ("");
}

void Main::fileImportFirefoxBookmarks()
{
	QFileDialog *fd=new QFileDialog( this);
	fd->setDir (vymBaseDir.homeDirPath()+"/.mozilla/firefox");
	fd->setMode (QFileDialog::ExistingFiles);
	fd->addFilter ("Firefox "+tr("Bookmarks")+" (*.html)");
	fd->setCaption(tr("Import")+" "+"Firefox "+tr("Bookmarks"));
	fd->show();

	if ( fd->exec() == QDialog::Accepted )
	{
		ImportFirefoxBookmarks im;
	    QStringList flist = fd->selectedFiles();
		QStringList::Iterator it = flist.begin();
		while( it != flist.end() ) 
		{
			im.setFile (*it);
			if (im.transform() && 
				success==fileLoad (im.getTransformedFile(),NewMap) && 
				currentMapEditor() )
				currentMapEditor()->setFilePath ("");
			++it;
		}
	}
	delete (fd);
}

void Main::fileImportMM()
{
	ImportMM im;

	QFileDialog *fd=new QFileDialog( this);
	if (!lastFileDir.isEmpty()) 
		fd->setDir (lastFileDir);
	fd->setMode (QFileDialog::ExistingFiles);
	fd->addFilter ("Mind Manager (*.mmap)");
	fd->setCaption(tr("Import")+" "+"Mind Manager");
	fd->show();

	if ( fd->exec() == QDialog::Accepted )
	{
		lastFileDir=fd->dirPath();
	    QStringList flist = fd->selectedFiles();
		QStringList::Iterator it = flist.begin();
		while( it != flist.end() ) 
		{
			im.setFile (*it);
			if (im.transform() && 
				success==fileLoad (im.getTransformedFile(),NewMap) && 
				currentMapEditor() )
				currentMapEditor()->setFilePath ("");

			++it;
		}
	}
	delete (fd);

}

void Main::fileImportDir()
{
	if (currentMapEditor())
		currentMapEditor()->importDir();	
}

void Main::fileExportXML()
{
	if (currentMapEditor())
	{
		QString dir=browseDirectory(tr("Export XML to directory"));
		if (dir !="" && reallyWriteDirectory(dir) )
			currentMapEditor()->exportXML(dir);
	}	
}


void Main::fileExportXHTML()
{
	MapEditor *me=currentMapEditor();
	QString dir;
	if (me)
	{
		ExportXHTMLDialog dia(this);
		dia.setFilePath (me->getFilePath() );
		dia.setMapName (me->getMapName() );
		dia.readSettings();
		
		if (dia.exec()==QDialog::Accepted)
		{
			QString dir=dia.getDir();
			// Check, if warnings should be used before overwriting
			// the output directory
			bool ok;
			if (dia.warnings()) 
				ok=reallyWriteDirectory(dir);
			else
				ok=true;

			if (ok)
			{
				me->exportXML (dia.getDir() );
				dia.doExport(me->getMapName() );
				if (dia.hasChanged())
					me->setChanged();
			}	
		}
	}	
}

void Main::fileExportImage(int item)
{
	MapEditor *me=currentMapEditor();
	if (me)
	{
		QString fn = QFileDialog::getSaveFileName( QString::null, "Image  (*.bmp *.jpg *.pbm *.pgm *.png *.ppm *xbm *.xpm)",
							   this );
		if ( !fn.isEmpty() ) 
			me->exportImage(fn,item);
		else 
			statusBar()->message( tr("Couldn't save %1").arg(fn), statusbarTime );
		
	}
}

void Main::fileExportASCII()
{
	MapEditor *me=currentMapEditor();
	if (me)
	{
		ExportASCII ex;
		ex.setMapCenter(me->getMapCenter());
		ex.addFilter ("TXT (*.txt)");
		ex.setCaption(__VYM " -" +tr("Export as ASCII")+" "+tr("(still experimental)"));
		if (ex.execDialog() ) 
		{
			me->setExportMode(true);
			ex.doExport();
			me->setExportMode(false);
		}
	}
}

void Main::fileExportLaTeX()
{
	MapEditor *me=currentMapEditor();
	if (me)
	{
		ExportLaTeX ex;
		ex.setMapCenter(me->getMapCenter());
		ex.addFilter ("Tex (*.tex)");
		ex.setCaption(__VYM " -" +tr("Export as LaTeX")+" "+tr("(still experimental)"));
		if (ex.execDialog() ) 
		{
			me->setExportMode(true);
			ex.doExport();
			me->setExportMode(false);
		}
	}
}

void Main::fileExportKDEBookmarks()
{
	ExportKDEBookmarks ex;
	MapEditor *me=currentMapEditor();
	if (me)
	{
		ex.setMapCenter (me->getMapCenter() );
		ex.doExport();
	}	
}

void Main::fileExportTaskjuggler()
{
	ExportTaskjuggler ex;
	MapEditor *me=currentMapEditor();
	if (me)
	{
		ex.setMapCenter (me->getMapCenter() );
		ex.setCaption ( __VYM " - "+tr("Export to")+" Taskjuggler"+tr("(still experimental)"));
		ex.addFilter ("Taskjuggler (*.tjp)");
		if (ex.execDialog() ) 
		{
			me->setExportMode(true);
			ex.doExport();
			me->setExportMode(false);
		}
	}	
}

void Main::fileExportOOPresentation()
{
	ExportOOFileDialog *fd=new ExportOOFileDialog( this,__VYM " - "+tr("Export to")+" Open Office");
	// FIXME add extra info in dialog
	//ImagePreview *p =new ImagePreview (fd);
	//fd->setContentsPreviewEnabled( TRUE );
	//fd->setContentsPreview( p, p );
	//fd->setPreviewMode( QFileDialog::Contents );
	fd->setCaption(__VYM " - " +tr("Export to")+" Open Office");
	//fd->setDir (lastImageDir);
	if (fd->foundConfig())
	{
		fd->show();

		if ( fd->exec() == QDialog::Accepted )
		{
			QString fn=fd->selectedFile();
			//lastImageDir=fn.left(fn.findRev ("/"));
			if (currentMapEditor())
				currentMapEditor()->exportOOPresentation(fn,fd->selectedConfig());	
		}
	} else
	{
		QMessageBox::warning(0, 
			tr("Warning"),
			tr("Couldn't find configuration for export to Open Office\n"));
	}
}

void Main::fileCloseMap()
{
	if (currentMapEditor())
	{
		if (currentMapEditor()->hasChanged())
		{
			QMessageBox mb( __VYM,
				tr("The map %1 has been modified but not saved yet. Do you want to").arg(currentMapEditor()->getFileName()),
				QMessageBox::Warning,
				QMessageBox::Yes | QMessageBox::Default,
				QMessageBox::No,
				QMessageBox::Cancel | QMessageBox::Escape );
			mb.setButtonText( QMessageBox::Yes, tr("Save modified map before closing it") );
			mb.setButtonText( QMessageBox::No, tr("Discard changes"));
			switch( mb.exec() ) 
			{
				case QMessageBox::Yes:
					// save and close
					fileSave(CompleteMap);
					break;
				case QMessageBox::No:
				// close  without saving
					break;
				case QMessageBox::Cancel:
					// do nothing
				return;
			}
		} 
		currentMapEditor()->closeMap();
		tabWidget->removePage(currentMapEditor());
		if (tabWidget->count()==0)
			actionFilePrint->setEnabled (false);
	}	
}

void Main::filePrint()
{
	if (currentMapEditor())
		currentMapEditor()->print();
}

void Main::fileExitVYM()
{
	// Check if one or more editors have changed
	MapEditor *me;
	int i;
	for (i=0;i<=tabWidget->count() -1;i++)
	{
		
		me=(MapEditor*)tabWidget->page(i);

		// If something changed, ask what to do
		if (me->isUnsaved())
		{
			tabWidget->setCurrentPage(i);
			QMessageBox mb( __VYM,
				tr("This map is not saved yet. Do you want to"),
				QMessageBox::Warning,
				QMessageBox::Yes | QMessageBox::Default,
				QMessageBox::No,
				QMessageBox::Cancel | QMessageBox::Escape );
			mb.setButtonText( QMessageBox::Yes, tr("Save map") );
			mb.setButtonText( QMessageBox::No, tr("Discard changes") );
			mb.show();
			// Call undocumented function: setActiveWindow is only
			// possible, if widget is visible. This depends on
			// windowmanager...
#if defined(Q_OS_LINUX)
			qt_wait_for_window_manager( this);
#endif			
			mb.setActiveWindow();
			switch( mb.exec() ) {
				case QMessageBox::Yes:
					// save (the changed editors) and exit
					fileSave(CompleteMap);
					break;
				case QMessageBox::No:
					// exit without saving
					break;
				case QMessageBox::Cancel:
					// don't save and don't exit
				return;
			}
		}
	} // loop over all MEs	
    qApp->quit();
}

void Main::editUndo()
{
	if (currentMapEditor())
		currentMapEditor()->undo();
}

void Main::editRedo()	   
{
	if (currentMapEditor())
		currentMapEditor()->redo();
}

void Main::editCopy()
{
	if (currentMapEditor())
		currentMapEditor()->copy();
}

void Main::editPaste()
{
	if (currentMapEditor())
		currentMapEditor()->paste();
}

void Main::editCut()
{
	if (currentMapEditor())
		currentMapEditor()->cut();
}

void Main::editOpenFindWindow()
{
	findWindow->popup();
	findWindow->raise();

	// Call undocumented function: setActiveWindow is only
	// possible, if widget is visible. This depends on
	// windowmanager...
#if defined(Q_OS_LINUX)
	qt_wait_for_window_manager( this);
#endif	
	findWindow->setActiveWindow();
}

void Main::editFind(QString s)
{
	bool cs=false;
	BranchObj *bo=currentMapEditor()->findText(s, cs);
	if (bo)
	{	
		statusBar()->message( "Found: " + bo->getHeading(), statusbarTime );
	} else
	{
		QMessageBox::information( findWindow, tr( "VYM -Information:" ),
							   tr("No matches found for \"%1\"").arg(s));
	}	
}

void Main::editFindChanged()
{	// Notify editor, to abort the current find process
	currentMapEditor()->findReset();
}

void Main::editOpenURL()
{
	// Open new browser
	if (currentMapEditor())
	{	
	    QString url=currentMapEditor()->getURL();
		if (url=="") return;
		QString browser=settings.readEntry("/vym/mainwindow/readerURL" );
		procBrowser = new QProcess( this );

		procBrowser->addArgument( browser);
		procBrowser->addArgument( url);

		if ( !procBrowser->start() ) 
		{
			// try to set path to browser
			QMessageBox::warning(0, 
				tr("Warning"),
				tr("Couldn't find a viewer to open %1.\n").arg(url)+
				tr("Please use Settings->")+tr("Set application to open an URL"));
			settingsURL() ; 
		}	
	}	
}
void Main::editOpenURLTab()
{
	if (currentMapEditor())
	{	
	    QString url=currentMapEditor()->getURL();
		if (url=="") return;
		QString browser=settings.readEntry("/vym/mainwindow/readerURL" );
		if (procBrowser && procBrowser->isRunning())
		{
			if (browser.contains("konqueror"))
			{
				// Try to open new tab in existing konqueror started previously by vym
				QProcess *p=new QProcess (this);
				p->addArgument ("dcop");
				p->addArgument (QString("konqueror-%1").arg(procBrowser->processIdentifier()));
				p->addArgument ("konqueror-mainwindow#1");
				p->addArgument ("newTab");
				p->addArgument (url);
				if ( !p->start() ) 
					// try to set browser
					QMessageBox::warning(0, 
						tr("Warning"),
						tr("Couldn't start %1 to open a new tab in %2.").arg("dcop").arg("konqueror"));
				return;		
			} else if (browser.contains ("firefox") || browser.contains ("mozilla") )
			{
				// Try to open new tab in firefox
				QProcess *p=new QProcess (this);
				p->addArgument (browser);
				p->addArgument ("-remote");
				p->addArgument (QString("openurl(%1,new-tab)").arg(url));
				if ( !p->start() ) 
					// try to set browser
					QMessageBox::warning(0, 
						tr("Warning"),
						tr("Couldn't start %1 to open a new tab").arg(browser));
				return;		
			}
		}
		// Open new browser
		editOpenURL();
	}	
}

void Main::editURL()
{
	if (currentMapEditor())
	    currentMapEditor()->editURL();
}

void Main::editHeading2URL()
{
	if (currentMapEditor())
	    currentMapEditor()->editHeading2URL();
}

void Main::editBugzilla2URL()
{
	if (currentMapEditor())
	    currentMapEditor()->editBugzilla2URL();
}

void Main::editFATE2URL()
{
	if (currentMapEditor())
	    currentMapEditor()->editFATE2URL();
}

void Main::editOpenVymLink()
{
	// Get current path to map
	QString currentVymLink;
	if (currentMapEditor())
	{
		currentVymLink=currentMapEditor()->getVymLink();	
		// compare path with already loaded maps
		int index=-1;
		int i;
		MapEditor *me;
		for (i=0;i<=tabWidget->count() -1;i++)
		{
			me=(MapEditor*)tabWidget->page(i);
			if (currentVymLink==me->getFilePath() )
			{
				index=i;
				break;
			}
		}	
		if (index<0)
		// Load map
		{
			if (!QFile(currentVymLink).exists() )
				QMessageBox::critical( 0, tr( "Critical Error" ),
				   tr("Couldn't open map %1").arg(currentVymLink));
			else
			{
				fileLoad (currentVymLink, NewMap);
				tabWidget->setCurrentPage (tabWidget->count()-1);	
			}
		} else
			// Go to tab containing the map
			tabWidget->setCurrentPage (index);	
	}
}

void Main::editVymLink()
{
	if (currentMapEditor())
		currentMapEditor()->editVymLink();	
}

void Main::editDeleteVymLink()
{
	if (currentMapEditor())
		currentMapEditor()->deleteVymLink();	
}

void Main::editToggleHideExport()
{
	if (currentMapEditor())
		currentMapEditor()->toggleHideExport();	
}

void Main::editMapInfo()
{
	if (currentMapEditor())
		currentMapEditor()->editMapInfo();	
}

void Main::editMoveUp()
{
	if (currentMapEditor())
	    currentMapEditor()->moveBranchUp();
}

void Main::editMoveDown()
{
	if (currentMapEditor())
		currentMapEditor()->moveBranchDown();
}

void Main::editToggleScroll()
{
	if (currentMapEditor())
	{
		currentMapEditor()->toggleScroll();	
	}	
}

void Main::editUnScrollAll()
{
	if (currentMapEditor())
	{
		currentMapEditor()->unScrollAll();	
	}	
}

void Main::editHeading()
{
	if (currentMapEditor())
		currentMapEditor()->editHeading();
}

void Main::editNewBranch()
{
	if (currentMapEditor())
		currentMapEditor()->addNewBranch(0);
}

void Main::editNewBranchHere()
{
	if (currentMapEditor())
		currentMapEditor()->addNewBranchHere();
}

void Main::editNewBranchAbove()
{
	if (currentMapEditor())
		currentMapEditor()->addNewBranch(-1);
}

void Main::editNewBranchBelow()
{
	if (currentMapEditor())
		currentMapEditor()->addNewBranch(1);
}

void Main::editImportAdd()
{
	fileLoad (ImportAdd);
}

void Main::editImportReplace()
{
	fileLoad (ImportReplace);
}

void Main::editSaveBranch()
{
	fileSaveAs (PartOfMap);
}

void Main::editRemoveBranchKeepChilds()
{
	if (currentMapEditor())
		currentMapEditor()->removeBranchKeepChilds();
}

void Main::editRemoveChilds()
{
	if (currentMapEditor())
		currentMapEditor()->removeChilds();
}

void Main::editDeleteSelection()
{
	if (currentMapEditor() && actionSettingsUseDelKey->isOn())
		currentMapEditor()->deleteSelection();
}

void Main::editUpperBranch()
{
	if (currentMapEditor())
		currentMapEditor()->selectUpperBranch();
}

void Main::editLowerBranch()
{
	if (currentMapEditor())
		currentMapEditor()->selectLowerBranch();
}

void Main::editLeftBranch()
{
	if (currentMapEditor())
		currentMapEditor()->selectLeftBranch();
}

void Main::editRightBranch()
{
	if (currentMapEditor())
		currentMapEditor()->selectRightBranch();
}

void Main::editFirstBranch()
{
	if (currentMapEditor())
		currentMapEditor()->selectFirstBranch();
}

void Main::editLastBranch()
{
	if (currentMapEditor())
		currentMapEditor()->selectLastBranch();
}

void Main::editLoadImage()
{
	if (currentMapEditor())
		currentMapEditor()->loadFloatImage();
}

void Main::editSaveImage(int item)
{
	if (currentMapEditor())
		currentMapEditor()->saveFloatImage(item);
}

void Main::editFollowXLink(int item)
{
	if (currentMapEditor())
		currentMapEditor()->followXLink(branchLinksContextMenu->indexOf(item));
}

void Main::editEditXLink(int item)
{
	if (currentMapEditor())
		currentMapEditor()->editXLink(branchLinksContextMenuDup->indexOf(item));
}

void Main::formatSelectColor()
{
	if (currentMapEditor())
	{
		QColor col = QColorDialog::getColor( currentMapEditor()->color(), this );
		if ( !col.isValid() ) return;
		currentMapEditor()->setColor( col );
		colorChanged( col );
	}	
}

void Main::formatPickColor()
{
	if (currentMapEditor())
		colorChanged( currentMapEditor()->pickColor() );
}

void Main::colorChanged(QColor c)
{
    QPixmap pix( 16, 16 );
    pix.fill( c );
    actionFormatColor->setIconSet( pix );
}

void Main::formatColorItem()
{
	if (currentMapEditor())
		currentMapEditor()->colorItem();
}

void Main::formatColorBranch()
{
	if (currentMapEditor())
		currentMapEditor()->colorBranch();
}

void Main::formatLinkStyleLine()
{
	if (currentMapEditor())
		currentMapEditor()->setLinkStyle(StyleLine);
}

void Main::formatLinkStyleParabel()
{
	if (currentMapEditor())
		currentMapEditor()->setLinkStyle(StyleParabel);
}

void Main::formatLinkStylePolyLine()
{
	if (currentMapEditor())
		currentMapEditor()->setLinkStyle(StylePolyLine);
}

void Main::formatLinkStylePolyParabel()
{
	if (currentMapEditor())
		currentMapEditor()->setLinkStyle(StylePolyParabel);
}

void Main::formatSelectBackColor()
{
	if (currentMapEditor())
		currentMapEditor()->selectBackgroundColor();
}

void Main::formatSelectLinkColor()
{
	if (currentMapEditor())
		currentMapEditor()->selectLinkColor();
}

void Main::formatToggleLinkColorHint()
{
	currentMapEditor()->toggleLinkColorHint();
}

void Main::formatFrameNone()
{
	if (currentMapEditor())
		currentMapEditor()->setFrame(NoFrame);
}

void Main::formatFrameRectangle()
{
	if (currentMapEditor())
		currentMapEditor()->setFrame(Rectangle);
}

void Main::formatIncludeImagesVer()
{
	if (currentMapEditor())
		currentMapEditor()->setIncludeImagesVer(actionFormatIncludeImagesVer->isOn());
}

void Main::formatIncludeImagesHor()
{
	if (currentMapEditor())
		currentMapEditor()->setIncludeImagesHor(actionFormatIncludeImagesHor->isOn());
}

void Main::formatHideLinkUnselected()
{
	if (currentMapEditor())
		currentMapEditor()->setHideLinkUnselected(actionFormatHideLinkUnselected->isOn());
}

void Main::viewZoomReset()
{
	if (currentMapEditor())
	{
		QWMatrix m;
		m.reset();
		currentMapEditor()->setWorldMatrix( m );
		currentMapEditor()->setViewCenter();
		currentMapEditor()->adjustCanvasSize();
	}	
}

void Main::viewZoomIn()
{
	if (currentMapEditor())
	{
		QWMatrix m = currentMapEditor()->worldMatrix();
		m.scale( 1.25, 1.25 );
		currentMapEditor()->setWorldMatrix( m );
		currentMapEditor()->setViewCenter();
		currentMapEditor()->adjustCanvasSize();
	}	
}

void Main::viewZoomOut()
{
	if (currentMapEditor())
	{
		QWMatrix m = currentMapEditor()->worldMatrix();
		m.scale( 0.8, 0.8 );
		currentMapEditor()->setWorldMatrix( m );
		currentMapEditor()->setViewCenter();
		currentMapEditor()->adjustCanvasSize();
	}	
}

void Main::modModeColor()
{
}

void Main::modModeLink()
{
}

bool Main::settingsPDF()
{
	// Default browser is set in constructor
	bool ok;
	QString text = QInputDialog::getText(
		"VYM", tr("Set application to open PDF files")+":", QLineEdit::Normal,
		settings.readEntry("/vym/mainwindow/readerPDF"), &ok, this );
	if (ok)
		settings.writeEntry ("/vym/mainwindow/readerPDF",text);
	return ok;
}


bool Main::settingsURL()
{
	// Default browser is set in constructor
	bool ok;
	QString text = QInputDialog::getText(
		"VYM", tr("Set application to open an URL")+":", QLineEdit::Normal,
		settings.readEntry("/vym/mainwindow/readerURL")
		, &ok, this );
	if (ok)
		settings.writeEntry ("/vym/mainwindow/readerURL",text);
	return ok;
}

void Main::settingsToggleDelKey()
{
	if (actionSettingsUseDelKey->isOn())
	{
		actionEditDelete->setAccel (QKeySequence (Key_Delete));
	} else
	{
		actionEditDelete->setAccel (QKeySequence (""));
	}
}

void Main::windowToggleNoteEditor()
{
	if (textEditor->showWithMain() )
		windowHideNoteEditor();
	else	
		windowShowNoteEditor();
}

void Main::windowToggleHistory()
{
	if (currentMapEditor())
		currentMapEditor()->toggleHistoryWindow();
}

void Main::updateNoteFlag()
{
	if (currentMapEditor())
		currentMapEditor()->updateNoteFlag();
}

void Main::windowShowNoteEditor()
{
	textEditor->setShowWithMain(true);
	textEditor->show();
	actionViewToggleNoteEditor->setOn (true);
}

void Main::windowHideNoteEditor()
{
	textEditor->setShowWithMain(false);
	textEditor->hide();
	actionViewToggleNoteEditor->setOn (false);
}

void Main::windowNextEditor()
{
	if (tabWidget->currentPageIndex() < tabWidget->count())
		tabWidget->setCurrentPage (tabWidget->currentPageIndex() +1);
}

void Main::windowPreviousEditor()
{
	if (tabWidget->currentPageIndex() >0)
		tabWidget->setCurrentPage (tabWidget->currentPageIndex() -1);
}

void Main::standardFlagChanged()
{
	currentMapEditor()->toggleStandardFlag(sender()->name());
}

void Main::testFunction()
{
	currentMapEditor()->testFunction();
}

void Main::helpDoc()
{
	QString docpath;
	#if defined(Q_OS_MACX)
		docpath="./vym.app/Contents/vym.pdf";
	#else
		// default path in SUSE LINUX
		docpath="/usr/share/doc/packages/vym/doc/vym.pdf";
	#endif

	if (!QFile (docpath).exists() )
	{
		// relative path for easy testing in tarball
		docpath="doc/vym.pdf";
		if (!QFile (docpath).exists() )
		{
			// relative path for testing while still writing vym.tex
			docpath="doc/tex/vym.pdf";
			if (!QFile (docpath).exists() )
			{
				// Try yet another one for Knoppix
				docpath="/usr/share/doc/packages/vym/vym.pdf";
				if (!QFile (docpath).exists() )
				{
					QMessageBox::critical(0, 
					tr("Critcal error"),
					tr("Couldn't find the documentation\n"
					"vym.pdf in various places."));
					return;
				}	
			}	
		}
	}
	
	Process *pdfProc = new Process();
	pdfProc->clearArguments();
	pdfProc->addArgument( settings.readEntry("/vym/mainwindow/readerPDF"));
	pdfProc->addArgument( docpath);

	if ( !pdfProc->start() ) 
	{
		// error handling
		QMessageBox::warning(0, 
			tr("Warning"),
			tr("Couldn't find a viewer to open %1.\n").arg("vym.pdf")+
			tr("Please use Settings->")+tr("Set application to open PDF files"));
		settingsPDF();	
		return;
	}
}


void Main::helpAbout()
{
	AboutDialog ad;
	ad.setName ("aboutwindow");
	ad.setMinimumSize(500,500);
	ad.resize (QSize (500,500));
	ad.exec();
}

void Main::helpAboutQT()
{
	QMessageBox::aboutQt( this, "Qt Application Example" );
}

