#include <qfile.h>
#include <qtextstream.h>
#include <qmessagebox.h>
#include <qregexp.h>

#include "noteobj.h"

/////////////////////////////////////////////////////////////////
// NoteObj
/////////////////////////////////////////////////////////////////

NoteObj::NoteObj()
{
	clear();
}

NoteObj::NoteObj(const QString &s)
{
	clear();
	note=s;
}

void NoteObj::copy (NoteObj other)
{
	note=other.note;
	fonthint=other.fonthint;
	filenamehint="";
}

void NoteObj::clear()
{
	note="";
	fonthint="undef";
	filenamehint="";
}

void NoteObj::setNote (const QString &s)
{
	note=s;
}

QString NoteObj::getNote()
{
	return note;
}

QString NoteObj::getNoteASCII()
{
	QString r=note;

	// convert all "<br*>" to "\n"
	QRegExp re("<br.*>");
	re.setMinimal(true);
	r.replace (re,"\n");

	// convert all "</p>" to "\n"
	re.setPattern ("</p>");
	r.replace (re,"\n");
	
	// remove all remaining tags 
	re.setPattern ("<.*>");
	r.replace (re,"");

	// If string starts with \n now, remove it.
	// It would be wrong in an OOo export for example
	while (r.at(0)=='\n') r.remove (0,1);
	
	// convert "&", "<" and ">"
	re.setPattern ("&gt;");
	r.replace (re,">");
	re.setPattern ("&lt;");
	r.replace (re,"<");
	re.setPattern ("&amp;");
	r.replace (re,"&");
	re.setPattern ("&quot;");
	r.replace (re,"\"");

	return r;
}

QString NoteObj::getNoteOpenDoc()
{
	// Evil hack to transform QT Richtext into
	// something which can be used in OpenDoc format
	// 
	// TODO create clean XML transformation which also
	// considers fonts, colors, ...

	QString r=note;

	// convert all "<br*>"
	QRegExp re("<br.*>");
	re.setMinimal(true);
	r.replace (re,"<text:line-break/>");

	// convert all "<p>" 
	re.setPattern ("<p>");
	r.replace (re,"<text:line-break/>");
	
	// Remove all other tags, e.g. paragraphs will be added in 
	// templates used during export
	re.setPattern ("</?html.*>");
	r.replace (re,"");
	re.setPattern ("</?head.*>");
	r.replace (re,"");
	re.setPattern ("</?body.*>");
	r.replace (re,"");
	re.setPattern ("</?meta.*>");
	r.replace (re,"");
	re.setPattern ("</?span.*>");
	r.replace (re,"");
	re.setPattern ("</?p.*>");
	r.replace (re,"");

	r="<text:span text:style-name=\"vym-notestyle\">"+r+"</text:span>";
	return r;
}

void NoteObj::setFontHint (const QString &s)
{
	// only for backward compatibility (pre 1.5 )
	fonthint=s;
}

QString NoteObj::getFontHint()
{
	// only for backward compatibility (pre 1.5 )
	return fonthint;
}

void NoteObj::setFilenameHint (const QString &s)
{
	filenamehint=s;
}

QString NoteObj::getFilenameHint()
{
	return filenamehint;
}

bool NoteObj::isEmpty ()
{
	return note.isEmpty();
}

QString NoteObj::saveToDir ()
{
	// QTextEdit may generate fontnames with unquoted &, like
	// in "Lucida B&H". This is invalid in XML and thus would crash
	// the XML parser
	uint pos=0;
	bool inbracket=false;
	bool inquot=false;
	QString n=note;
	while (pos<n.length())
	{
		if (n.mid(pos,1)=="<") inbracket=true;
		if (n.mid(pos,1)==">") inbracket=false;
		if (n.mid(pos,1)=="\"" && inbracket)
		{
			if (!inquot)
				inquot=true;
			else
				inquot=false;
		}
		if (n.mid(pos,1)=="&" && inquot)
		{
			// Now we are inside  <  "  "  >
			n.replace(pos,1,"&amp;");
			pos=pos+3;
		}
		pos++;
	}
	return beginElement ("htmlnote",attribut("fonthint",fonthint)) + "\n"+ n+ "\n" +endElement ("htmlnote");
}

