/*
 * Simple MPEG/DVB parser to achieve network/service information without initial tuning data
 *
 * Copyright (C) 2006, 2007, 2008 Winfried Koehler 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 * Or, point your browser to http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * The author can be reached at: handygewinnspiel AT gmx DOT de
 *
 * The project's page is http://wirbel.htpc-forum.de/w_scan/index2.html
 */

#include <stdio.h>
#include "dump-kaffeine.h"
#include <linux/dvb/frontend.h>


int kaffeine_chnum=1;

void kaffeine_dump_service_parameter_set (FILE *f,
				 const char *service_name,
				 const char *provider_name,
				 fe_type_t type,
				 struct dvb_frontend_parameters *p,
				 char polarity,
				 int video_pid,
				 int pcr_pid,
				 uint16_t *audio_pid,
                                 int audio_num,
				 int teletext_pid,
				 int scrambled,
				 int ac3_pid,
                                 int service_id,
				 int original_network_id,
				 int transport_stream_id,
				 int dump_provider,
				 int ca_select,
				 int vdr_version,
				 int dump_channum,
				 int channel_num)
{
  int i;

  if (kaffeine_chnum == 1) {
    /* write header */
    fprintf (f, "# kaffeine channels.dvb automatically generated by w_scan\n");
    fprintf (f, "# see (http://wirbel.htpc-forum.de/w_scan/index2.html)\n");
    fprintf (f, "# TV(C)/RA(C)|name|vpid|apids|ttpid|sid|tsid|{S/C/T}|freq|sr|pol|fec_H|inv|mod|fec_L|bw|tm|gi|h|num|subpids|category\n");
    }
  fprintf(f, "%s|", ((scrambled==0) && (video_pid >0))?"TV":
                    ((scrambled==0) && (video_pid==0))?"RA":
                    (video_pid)?"TVC":"RAC");
  fprintf(f, "%s|", service_name);
  fprintf(f,"%i|", video_pid);
  fprintf(f,"%i,", audio_pid[0]);
  for (i=1; i < audio_num; i++)  fprintf(f,"%i,",audio_pid[i]);
  if (ac3_pid)                   fprintf (f,"%i(ac3),",ac3_pid);
  fprintf(f,"|");
  fprintf(f, "%d|",teletext_pid);
  fprintf(f, "%d|",service_id);
  fprintf(f, "%d|",transport_stream_id);
  switch (type) {
    case FE_ATSC: /* ATSC  */
      fprintf(f, "Atsc|");
      break;
    case FE_QAM:  /* DVB-C */
      fprintf(f, "Cable|");
      break;
    case FE_OFDM: /* DVB-T */
      fprintf(f, "Terrestrial|");
      break;
    default: break;
    }
  fprintf(f, "%i|", p->frequency / 1000);            /* 6 digits      */
  fprintf(f, "%i|", p->u.qam.symbol_rate / 1000);    /* 4 or 5 digits */
  fprintf(f, "%s|", "v");                            /* dummy for polarisation */
  switch (type) {
    case FE_ATSC: /* ATSC, fall-through */
    case FE_QAM:  /* DVB-C */
      fprintf(f, "-1|"); /* FEC_AUTO -> simply ignored inside VDR */               
      break;
    case FE_OFDM: /* DVB-T */
      switch (p->u.ofdm.code_rate_HP) {
        case FEC_NONE:fprintf(f, "0|");  break;
        case FEC_1_2: fprintf(f, "12|"); break;
        case FEC_2_3: fprintf(f, "23|"); break;
        case FEC_3_4: fprintf(f, "34|"); break;
        case FEC_4_5: fprintf(f, "45|"); break;
        case FEC_5_6: fprintf(f, "56|"); break;
        case FEC_6_7: fprintf(f, "67|"); break;
        case FEC_7_8: fprintf(f, "78|"); break;
        case FEC_8_9: fprintf(f, "89|"); break;
        default: fprintf(f, "-1|"); /* FEC_AUTO */
        }
      break;
    default: break;
    }
  switch (p->inversion) {
    case INVERSION_OFF: fprintf(f, "0|");  break;
    case INVERSION_ON : fprintf(f, "1|");  break;
    default:            fprintf(f, "-1|"); /* INVERSION_AUTO */
    }
  switch (type) { /* modulation */
    case FE_ATSC: /* ATSC */
      switch (p->u.vsb.modulation) {
        case QAM_64:  fprintf(f, "64|" ); break;
        case QAM_256: fprintf(f, "256|"); break;
        case VSB_8:   fprintf(f, "108|"); break;
        case VSB_16:  fprintf(f, "116|"); break;
        default: fprintf(f, "-1|");
        }
      fprintf(f, "-1|"); /* FEC_LP    */
      fprintf(f, "-1|"); /* Bandwidth */
      fprintf(f, "-1|"); /* transmission mode */
      fprintf(f, "-1|"); /* guard interval */
      fprintf(f, "-1|"); /* hierarchy */
      break;
    case FE_QAM:  /* DVB-C */
      switch (p->u.qam.modulation) {
        case QAM_16:  fprintf(f, "16|" ); break;
        case QAM_32:  fprintf(f, "32|" ); break;
        case QAM_64:  fprintf(f, "64|" ); break;
        case QAM_128: fprintf(f, "128|"); break;
        case QAM_256: fprintf(f, "256|"); break;
        default: fprintf(f, "-1|"); /* QAM_AUTO */
        }
      fprintf(f, "-1|"); /* FEC_LP    */
      fprintf(f, "-1|"); /* Bandwidth */
      fprintf(f, "-1|"); /* transmission mode */
      fprintf(f, "-1|"); /* guard interval */
      fprintf(f, "-1|"); /* hierarchy */
      break;
    case FE_OFDM: /* DVB-T */
      switch (p->u.ofdm.constellation) {
        case QPSK:    fprintf(f, "8|" );  break;
        case QAM_16:  fprintf(f, "16|" ); break;
        case QAM_32:  fprintf(f, "32|" ); break;
        case QAM_64:  fprintf(f, "64|" ); break;
        case QAM_128: fprintf(f, "128|"); break;
        case QAM_256: fprintf(f, "256|"); break;
        default: fprintf(f, "-1|"); /* QAM_AUTO */
        }
      switch (p->u.ofdm.code_rate_LP) {
        case FEC_NONE:fprintf(f, "0|");  break;
        case FEC_1_2: fprintf(f, "12|"); break;
        case FEC_2_3: fprintf(f, "23|"); break;
        case FEC_3_4: fprintf(f, "34|"); break;
        case FEC_4_5: fprintf(f, "45|"); break;
        case FEC_5_6: fprintf(f, "56|"); break;
        case FEC_6_7: fprintf(f, "67|"); break;
        case FEC_7_8: fprintf(f, "78|"); break;
        case FEC_8_9: fprintf(f, "89|"); break;
        default: fprintf(f, "-1|"); /* FEC_AUTO */
        }
      switch (p->u.ofdm.bandwidth) {
        case BANDWIDTH_8_MHZ: fprintf(f, "8|"); break;
        case BANDWIDTH_7_MHZ: fprintf(f, "7|"); break;
        case BANDWIDTH_6_MHZ: fprintf(f, "6|"); break;
        default: fprintf(f, "-1|"); /* BANDWIDTH_AUTO */
        }
      switch (p->u.ofdm.transmission_mode) {
        case TRANSMISSION_MODE_8K: fprintf(f, "8|"); break;
        case TRANSMISSION_MODE_2K: fprintf(f, "2|"); break;
        default: fprintf(f, "-1|"); /* TRANSMISSION_MODE_AUTO */
        }
      switch (p->u.ofdm.guard_interval) {
        case GUARD_INTERVAL_1_32: fprintf(f, "32|"); break;
        case GUARD_INTERVAL_1_16: fprintf(f, "16|"); break;
        case GUARD_INTERVAL_1_8:  fprintf(f, "8|");  break;
        case GUARD_INTERVAL_1_4:  fprintf(f, "4|");  break;
        default: fprintf(f, "-1|"); /* GUARD_INTERVAL_AUTO */
        }
      switch (p->u.ofdm.hierarchy_information) {
        case HIERARCHY_NONE: fprintf(f, "0|"); break;
        case HIERARCHY_1:    fprintf(f, "1|"); break;
        case HIERARCHY_2:    fprintf(f, "2|"); break;
        case HIERARCHY_4:    fprintf(f, "4|"); break;
        default: fprintf(f, "-1|"); /* HIERARCHY_AUTO */
        }
      break;
    default: break;
    }
  fprintf(f, "%d|",kaffeine_chnum++); /* channel number, ascending              */
  fprintf(f, "%s|","");               /* list of subpids? Dont know up to now.. */
  fprintf(f, "%s|\n","");             /* category? Dont know up to now..        */
}

