
/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "bookmark.h"

@interface Sites: NSObject 
{
    NSMutableArray* _sites;
}

- initWithBook: (Sites*) sites;
- initWithFile: (NSString*) file;
- writeFile: (NSString*) file;
- addSite: (Bookmark*) bookmark;
- (NSMutableArray*) arrayOfSites;
- (int) count;
@end

@interface SitesCombo: Sites 
{
    id _observer;
}
- (id) comboBox: (NSComboBox*) aComboBox objectValueForItemAtIndex: (int) index;
- (int) numberOfItemsInComboBox: (NSComboBox*) aComboBox;
- (void) addObserver: (id) obs;
- (void) controlTextDidChange: (NSNotification *)aNotification;
@end
