/*-----------------------------------------------------------------------------
 *  FILE: Applet.hh
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Applet class which controls the program.
 *
 *-----------------------------------------------------------------------------
 */

#ifndef _APPLET_GF_05092005
#define _APPLET_GF_05092005

#include <memory>
#include <list>
#include <sigc++/connection.h>
#include <gtkmm/eventbox.h>
#include <gtkmm/window.h>
#include <gtkmm/tooltips.h>
#include <gtkmm/image.h>
#include <glibmm/ustring.h>
#include <gconfmm/client.h>
#include <gconfmm/entry.h>
#include <libgnomeuimm/about.h>
#include <panel-applet.h>
#include "Wallpapers.hh"
#include "SearchDialog.hh"
#include "PreferencesDialog.hh"

//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Applet class which controls the program.

@author Gareth Foster
@date 05/09/2005
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class Applet : public Gtk::EventBox
{
	friend void DisplayForward(BonoboUIComponent *, void * _pApplet, const gchar *);
	friend void DisplaySearch(BonoboUIComponent	*, void * _pApplet, const gchar *);
	friend void DisplayDelete(BonoboUIComponent *, void * _pApplet, const gchar *);
	friend void DisplayPreferences(BonoboUIComponent *, void * _pApplet, const gchar *);
	friend void DisplayHelp(BonoboUIComponent *, void * _pApplet, const gchar *);
	friend void DisplayAbout(BonoboUIComponent *, void * _pApplet, const gchar *);

	public:
		// public methods
		Applet(PanelApplet * _pPanelApplet);
		virtual ~Applet();

		Gtk::Container & GetContainer();
		int GetSize() const;
		bool Horizontal() const;

		void RenderThumbnail(Glib::ustring _szFile);
		void SetThumbnailOnPanel();
		void RenderAndSetThumbnail();

		Glib::RefPtr<Gdk::Pixbuf> GetThumbnail();

	private:
		// private methods
		void OnForwardActivated();
		void OnSearchActivated();
		void OnDeleteActivated();
		void OnPreferencesActivated();
		void OnHelpActivated();
		void OnAboutActivated();
		void OnDropDragDataReceived(const Glib::RefPtr<Gdk::DragContext> & _context, int _nX, int _nY, const Gtk::SelectionData	& _selectionData, guint , guint _nTime);
		bool OnClicked(GdkEventButton * const & _refpGdkEventButton);
		void CreateTooltip(guint _nCnxn, Gnome::Conf::Entry _GconfEntry);

	private:
		// private members
		std::auto_ptr<Gnome::UI::About>		m_pAboutBox;
		
		Gtk::EventBox						m_GtkEventBox;
		Gtk::Image::Image					m_GtkImage;
		Gtk::Tooltips						m_GtkTooltips;

		Glib::RefPtr<Gdk::Pixbuf>			m_pGdkIcon;
		Glib::RefPtr<Gdk::Pixbuf>			m_pThumbnail;
		Glib::RefPtr<Gnome::Conf::Client>	m_pGconfClient;

		PanelApplet *						m_pPanelApplet;
		PreferencesDialog *					m_pPreferencesDialog;
		SearchDialog *						m_pSearchDialog;

		guint								m_nCnxnRenderThumb;
		guint								m_nCnxnUpdateTooltip;

		Wallpapers							m_Wallpapers;
};// end class Applet

#endif	// end _APPLET_GF_05092005
