/*-----------------------------------------------------------------------------
 *  FILE: Applet.hh
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Applet class which controls the program.
 *
 *-----------------------------------------------------------------------------
 */

#include <config.h>
#include <iostream>
#include <libintl.h>
#include <libgnomemm/main.h>
#include <libgnomeuimm/init.h>
#include <panel-applet.h>
#include <glib/gi18n.h>
#include "config.h"
#include "Applet.hh"

/** @defgroup WPTray WPTray
 * WPTray contains classes used in the Wallpaper Tray program.
 */

//------------------------------------------------------------------------
/**
<wp_tray_factory>
@brief Produces Applet instances.

@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
gboolean wp_tray_factory
(
	PanelApplet *				_pPanelApplet,
	const gchar *				_strId,
	void *						_pData
)
{
	// construct applet
	Applet * p_Applet = manage(new Applet(_pPanelApplet));
	p_Applet->show();
  
	gtk_container_add(GTK_CONTAINER(_pPanelApplet), GTK_WIDGET(p_Applet->gobj()));
	gtk_widget_show(GTK_WIDGET(_pPanelApplet));
  
	return true;
}// end wp_tray_factory

//------------------------------------------------------------------------
/**
<wp_tray_factory>
@brief Program entry point.

@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
int main
(
	int							_argc,
	char *						_argv[]
)
{
	Gnome::Main main(PACKAGE, VERSION, Gnome::UI::module_info_get(), _argc, _argv);
  
	try
	{
		// i18n
		bindtextdomain(GETTEXT_PACKAGE, GNOMELOCALEDIR);
		bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");

		textdomain(GETTEXT_PACKAGE);

		panel_applet_factory_main	(
				"OAFIID:wp_tray_Factory",
				PANEL_TYPE_APPLET,
				&wp_tray_factory,
				0
			);
	}
	catch(const Glib::Error &ex)
	{
		std::cerr << ex.what() << std::endl;
	}
	return 0;
}// end main
