# -*- coding: UTF-8 -*-
# vim: expandtab sw=4 ts=4 sts=4:
'''
Wammu - Phone manager
Some static data like bitmaps, category mappings etc.
Many of them might be moved to python-gammu later
'''
__author__ = 'Michal Čihař'
__email__ = 'michal@cihar.com'
__license__ = '''
Copyright (c) 2003 - 2007 Michal Čihař

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License version 2 as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
'''

import sys
from gammu.Data import Connections, MemoryValueTypes, CalendarTypes, CalendarValueTypes, TodoPriorities, TodoValueTypes, InternationalPrefixes


# When support for sound will be implemented, here should be sounds
PredefinedSounds = [
        (_('Chimes high'),''),
        (_('Chimes low'),''),
        (_('Ding'),''),
        (_('TaDa'),''),
        (_('Notify'),''),
        (_('Drum'),''),
        (_('Claps'),''),
        (_('Fanfare'),''),
        (_('Chord high'),''),
        (_('Chord low'),''),
        ]

# Wanted somebody who will draw nicer icons :-)

Note = [
    '16 16 2 1',
    'x c Black',
    '  c None',
    '      xx        ',
    '      xxx  xxx  ',
    '      xxxxxxxxx ',
    '      xx  xx  xx',
    '      xx        ',
    '      xx        ',
    '      xx        ',
    '      xx        ',
    '  xxxxxx        ',
    ' xxxxxxx        ',
    'xxxxxxxx        ',
    'xxxxxxxx        ',
    'x  xxxxx        ',
    'x   xxxx        ',
    ' x  xxx         ',
    '  xxxx          ']

UnknownPredefined = [
    '16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '    x      x    ',
    '   x  xxxx  x   ',
    '   x x    x x   ',
    '    x     x x   ',
    '          x x   ',
    '         x x    ',
    '        x x     ',
    '       x x      ',
    '       x x      ',
    '       xx       ',
    '                ',
    '       xx       ',
    '      xxxx      ',
    '      x xx      ',
    '       xx       ']

PredefinedAnimations = [
    (_("I'm ironic, flirty"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   x    x   x ',
    ' x    x  x    x ',
    '  x    xx    x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am glad"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am skeptic"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   xxxxx      x',
    ' x       x    x ',
    ' x        x   x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am sad"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    ' x   x    x   x ',
    ' x  x      x  x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("WOW"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    'x    x    x    x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am crying"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x     x    x   x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am winking"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x       xx   x ',
    'x  xxxx  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   xxxxxx   x ',
    ' x            x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am laughing"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x   x      x   x',
    ' x   xxxxxx   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am indifferent"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x            x ',
    ' x   xxxxxx   x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am in love"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxx xx xx ',
    '   xx    x  x  x',
    '  x       x   x ',
    ' x         x x  ',
    ' x  xx   xx x x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("I am confused"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx xx  ',
    '   xx      x  x ',
    '  x           x ',
    ' x           x  ',
    ' x  xx   xx    x',
    'x   x x  x x x x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x   xxxxx    x ',
    ' x            x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("Tongue hanging out"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x         x  x ',
    ' x    xxxxx x x ',
    '  x     xx   x  ',
    '   xx     x   x ',
    '     xxxxxxxxx  ']),
    (_("I am angry"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x x        x x ',
    ' x  xx   xxx  x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x     xxxx     x',
    ' x   x    x   x ',
    ' x  x      x  x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("Wearing glases"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    '     xxxxxx     ',
    '   xx      xx   ',
    '  x          x  ',
    ' x            x ',
    'xxxxxxxxxxxxxxxx',
    'x   xxx  xxx   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x              x',
    'x              x',
    ' x  x      x  x ',
    ' x   xxxxxx   x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    (_("Devil"),
    ['16 16 2 1',
    'x c Black',
    '  c None',
    'x    xxxxxx    x',
    'xxxxx      xxxxx',
    ' xx          xx ',
    ' x            x ',
    ' x  xx   xx   x ',
    'x   x x  x x   x',
    'x    xx   xx   x',
    'x              x',
    'x              x',
    'x   xxxxxxxx   x',
    'x   x x  x x   x',
    ' x   x    x   x ',
    ' x    xxxx    x ',
    '  x          x  ',
    '   xx      xx   ',
    '     xxxxxx     ']),
    ]

# First is used as default
Models = [
    'auto',
    'at',
    'alcatel',
    'nauto',
    'obex',
    'seobex',
    ]

Conn_Generic = [
    'at19200',
    'at115200',
    'obex',
    ]
Conn_Cable = [
    'at19200',
    'at115200',
    'fbusdlr3',
    'fbus',
    'mbus',
    'fbuspl2303',
    'phonetblue',
    'fbusblue',
    ]
Conn_IrDA_Win = [
    'irdaphonet',
    'irdaat',
    ]
Conn_IrDA_Other = [
    'irdaphonet',
    'at19200',
    ]
Conn_BlueRF = [
    'at19200',
    ]
Conn_Bluetooth = [
    'bluephonet',
    'bluefbus',
    'bluerfgnapbus',
    'blueat',
    'bluerfphonet',
    'bluerffbus',
    'bluerfat',
    ]
if sys.platform == 'win32':
    Devices = [
        '',
        'com1:',
        'com2:',
        'com3:',
        'com4:',
        'com5:',
        'com6:',
        ]
    AllDevices = [
        (Conn_IrDA_Win, '', None),
        (Conn_Cable, 'com%d:', (1,6)),
        ]
# FIXME: support more platforms?
else:
    Devices = [
        '/dev/ttyS0',
        '/dev/ttyS1',
        '/dev/ttyUSB0',
        '/dev/ttyUSB1',
        '/dev/ttyACM0',
        '/dev/ttyACM1',
        '/dev/ircomm0',
        '/dev/rfcomm0',
        '/dev/usb/tts/0',
        ]
    AllDevices = [
        (Conn_Cable, '/dev/ttyS%d', (0, 3)),
        (Conn_Cable, '/dev/ttyUSB%d', (0, 3)),
        (Conn_Cable, '/dev/ttyACM%d', (0, 3)),
        (Conn_BlueRF, '/dev/rfrcomm%d', (0, 1)),
        (Conn_IrDA_Other, '/dev/ircomm%d', (0, 1)),
        (Conn_Cable, '/dev/usb/tts/%d', (0, 3)),
        ]

ContactMemoryTypes = ['ME', 'SM']

SMSIDs = {
    'Text':                 [
        'Text',
        'ConcatenatedTextLong',
        'ConcatenatedAutoTextLong',
        'ConcatenatedTextLong16bit',
        'ConcatenatedAutoTextLong16bit',
        'NokiaVCARD21Long',
        'NokiaVCALENDAR10Long'
        ],
    'Sound':                [
        'NokiaProfileLong',
        'NokiaRingtone',
        'NokiaRingtoneLong',
        'EMSSound10',
        'EMSSound12',
        'EMSSonyEricssonSound',
        'EMSSound10Long',
        'EMSSound12Long',
        'EMSSonyEricssonSoundLong',
        ],
    'Animation':            [
        'NokiaProfileLong',
        'EMSAnimation',
        'AlcatelMonoAnimationLong',
        'NokiaScreenSaverLong',
        ],
    'File':                 [
        'SiemensFile',
        ],
    'Bitmap':               [
        'NokiaProfileLong',
        'NokiaPictureImageLong',
        'NokiaOperatorLogo',
        'NokiaOperatorLogoLong',
        'NokiaCallerLogo',
        'EMSFixedBitmap',
        'EMSVariableBitmap',
        'EMSVariableBitmapLong',
        'AlcatelMonoBitmapLong',
        'AlcatelSMSTemplateName',
        ],
    'PredefinedAnimation':  [
        'EMSPredefinedAnimation',
        ],
    'PredefinedSound':      [
        'EMSPredefinedSound',
        ],
    }

TextFormats = [
    [(_('Alignment'), _('None')),
        ('Left', _('Left'), '<div align="left">%s</div>'),
        ('Right', _('Right'), '<div align="right">%s</div>'),
        ('Center', _('Center'), '<div align="center">%s</div>'),
        ],
    [(_('Text Size'), _('Normal')),
        ('Large', _('Large'), '<font size="+2">%s</font>'),
        ('Small', _('Small'), '<font size="-2">%s</font>'),
        ],
    ['', ('Bold', _('Bold'), '<b>%s</b>')],
    ['', ('Italic', _('Italic'), '<i>%s</i>')],
    ['', ('Underlined', _('Underlined'), '<u>%s</u>')],
    ['', ('Strikethrough', _('Strikethrough'), '<strike>%s</strike>')],
]

# dump from Gammu Phone Database
ManufacturerMap = {
    'Alcatel': 1,
    'Nokia': 2,
    'Siemens': 3,
    'Sony Ericsson': 4,
    'Sagem': 5,
    'Motorola': 6,
    'Falcom': 7,
    'Samsung': 8,
    'LG': 9,
    'Sharp': 10,
    'Mitsubishi': 11,
    'PalmOne': 12,
}
GarbleMap = {
    0: 'atdot',
    1: 'nospam',
    2: 'none',
    3: 'hide',
}
