// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: CommunicationManager.cpp
// 
//---------------------------------------------------------------------------

#include "Event.h"
#include "CommunicationManager.h"
#include "SimulationObject.h"
#include <sstream>
using std::istringstream;

CommunicationManager::CommunicationManager( PhysicalCommunicationLayer *physicalLayer,
					    TimeWarpSimulationManager * ) :
  myPhysicalCommunicationLayer(physicalLayer){
}

CommunicationManager::~CommunicationManager(){

}

void
CommunicationManager::finalize(){
  myPhysicalCommunicationLayer->physicalFinalize();
}

void
CommunicationManager::registerMessageType( const string &messageType,
					   CommunicatingEntity *entity ){
  // store info in the list of receivers hash map
  listOfReceivers.insert( messageType, entity );
}

void   
CommunicationManager::configure( SimulationConfiguration &configuration ){
  initializePhysicalCommunicationLayer( configuration );
  initializeCommunicationManager();
}
