#ifndef CONFIGURER_H
#define CONFIGURER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <clutils/StringHashMap.h>
#include <map>

class SimulationConfiguration;
class SimulationManager;
class Configurable;
class Application;

/**
   This class implements an interface that allows confiuration of a series
   of choices.  In general, factory classes will implement this class.
*/

class Configurer {
public:
  class Choice;

  class ChoiceHashMap : public StringHashMap<const Choice *> {
  public:
    ChoiceHashMap(){}
    ~ChoiceHashMap(){}
  };

  class Choice {
  public:
    Choice( string optionName, 
	    string optionDescription, 
	    string value,
	    ChoiceHashMap &additionalArguments ) :
      myOptionName( optionName ),
      myValue( value ),
      myOptionDescription( optionDescription ),
      myAdditionalArguments( additionalArguments ){}

    const string getOptionName() const {
      return myOptionName;
    }
    
    const string getOptionDescription() const {
      return myOptionDescription;
    }

    const string getValue() const {
      return myValue;
    }

    ChoiceHashMap &getAdditionalArguments() const {
      return myAdditionalArguments;
    }

  private:
    const string myOptionName;
    const string myValue;
    const string myOptionDescription;
    ChoiceHashMap &myAdditionalArguments;
  };

  /** Allocate one of my objects based on the configuration.  This method
      is overloaded by all ancestors.  @param configurationMap Set of
      configuration options.  
      
      @param myConfiguration The configuration that will determine what
      type of child to instantiate.

      @param parent The parent that is allocating this child.  Can be NULL.
      
  */
  virtual Configurable *allocate( SimulationConfiguration &myConfiguration,
				  Configurable *parent ) const = 0;


protected:

//   /**
//      This is a factory method.  That is, we pass in a choice, and we get
//      back an object.
//   */
//   virtual Configurable *allocate( const Choice * ) = 0;

  Configurer(){}
  virtual ~Configurer(){}
};

#endif
