#ifndef WARPED_FILE_MANAGER_H
#define WARPED_FILE_MANAGER_H

// Copyright (c) 2004 Clifton Labs, Inc.
// All Rights Reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

#include <fstream>
using std::fstream;
using std::ios;
#include <string>
using std::string;

namespace warped{

class FileManager {
public:
  static FileManager &instance();
  virtual fstream &open( const string &fileName, ios::openmode ) = 0;

protected:
  FileManager();
  virtual ~FileManager() = 0;

private:
  static FileManager *initSingleton();
};

}
#endif
