--  2001 Peter Thiemann
module Submit where

import Auxiliary
import Char
import Directory
import Fields
import List hiding (head)
import Maybe
import Monad
import Random
import Prelude hiding (head)
import HTMLMonad
import CGI
import RawCGI
import Item
import Report2
import ForeignReport

data MainAction = Submit | Revise | Withdraw
  deriving (Eq, Read, Show)

entryPage :: (?storeDirectory :: String, ?venuePath :: String) => IO ()
entryPage = 
  runWithHook [] translator $
  do submissionEnabled <- io $ catch (readFile enabledFile >> return True)
                                     (const (return False))
     venueQuery "Reviewing Engine" $
       table_T $ do
         when submissionEnabled $
	   tr_T (td_S (submit0 submission (fieldVALUE "Start new submission")
              ## attr_SS "align" "center"))
	 tr_S (td_S (submit0 rwsub
	 	 (fieldVALUE "Revise/withdraw submission") ## attr_SS "align" "center"))
	 tr_S (td_S (submit0 pcAccess (fieldVALUE "PC access") ## attr_SS "align" "center"))
	 tr_S (td_S (submit0 reviewerlogin (fieldVALUE "External Reviewer access") ## attr_SS "align" "center"))

rwsub =
  venueQuery "Revise/Withdraw Paper" $
  table_T $
  do emailF <- tr_T $ question "Email" (inputField (fieldSIZE 60))
     keyF   <- tr_T $ question "Password" (passwordInputField (fieldSIZE 20))
     submit (F2 emailF keyF) dispatch (fieldVALUE "Revise/withdraw paper")

dispatch :: (?storeDirectory :: String, ?venuePath :: String) =>
	F2 (InputField EmailAddress) (InputField NonEmpty) VALID -> CGI ()
dispatch (F2 emailF keyF) =
  revision emailF keyF

submission =
  venueQuery "Paper Submission" $
  table_T $
  let standardField :: (Reason a, Read a) => WithHTML x CGI (InputField a INVALID)
      standardField = inputField (fieldSIZE 60) in
  do authorF      <- tr_T $ question "Authors"     	standardField
     titleF       <- tr_T $ question "Title of paper"	standardField
     affiliationF <- tr_T $ question "Affiliation" 	standardField
     emailF       <- tr_T $ question "Email"       	standardField
     tr_T $ (td_S empty ## td_S (text_S "(corresponding author only)"))
     _            <- tr_T ( td_S (text_S "Abstract" ## attr_SS "colspan" "2")) 
     abstractF    <- tr_T ( td_S (makeTextarea "" (attr_SS "rows" "10" ## attr_SS "cols" "75")
     			      ## attr_SS "colspan" "2"))
     paperF       <- tr_T $ question "Filename of paper" (fileInputField (fieldSIZE 40))
     tr_T (td_S (text_S "Acceptable file formats:") ## (td_S (text_S ".ps, .ps.gz and .pdf" )))
     tr_T $ td_S (attr_SS "align" "center"
          ## submit (F6 authorF titleF affiliationF emailF abstractF paperF)
	            (processSubmission Nothing)
		    (fieldVALUE "Submit paper"))

--question :: Field input => String -> input -> [Element]
question str inf =
  td_T (text str) >> td_S inf

--answer :: Show a => String -> InputField a x -> [Element]
answer str inf =
  td_T (b_S (text str)) >> td_T (text (show (value inf)))

processSubmission maybePassword
  (F6 authorF titleF affiliationF emailF abstractF paperF) = 
  let author = unNonEmpty (value authorF)
      title  = unNonEmpty (value titleF)
      affiliation = unNonEmpty (value affiliationF)
      paper = value paperF
      email = unEmailAddress (value emailF)
      extension = getFileSuffix (fileReferenceExternalName paper) 
      contentType = fileReferenceContentType paper
  in
--  if allOK then
  do password <- case maybePassword of
		   Just pw -> return pw
		   Nothing -> io inventPassword
     let fileName = password ++ extension
	 storeFile = ?storeDirectory ++ fileName
     io (readFile (fileReferenceName paper) >>= writeFile storeFile)
     ref <- makeRef fileName (text "view paper")
     io (addItem password author title affiliation email
		 (value abstractF)
		 extension)
     htell $
       standardPage "Paper Submission Acknowledgement" $ 
       (table_T
         (  tr_S (td_S (b_S $ text_S "Your password") ## td_S (text password))
	 ## tr_S ( answer "Authors" authorF)
    	 ## tr_S ( answer "Title of paper"   titleF)
	 ## tr_S ( answer "Affiliation" affiliationF)
	 ## tr_S ( answer "Email" emailF)
	 ## tr_S (td_S (attr_SS "colspan" "2" ## b_S (text_S "Abstract")))
	 ## tr_S (td_S (text (value abstractF) ## attr_SS "colspan" "2"))
	 ## tr_S (td_S (b_S (text_S "File format")) ## td_S (analyseContentType contentType))
	 ## tr_S (td_S (b_S (text_S "View downloaded file"))
	     ## td_S ref))
       ## hr_T empty
       ## text_T "Please save this page for future reference. "
       ##  text_T "Using the password, you can revise and/or withdraw your paper and your submission information until the deadline is expired."
       ##  text_T "Double check that your e-mail address is correct because it is the only way that we can reach you.")

analyseContentType contentType =
  if contentType `elem` ["application/postscript", "application/pdf"] then
     text contentType
  else
     attr_TS "bgcolor" "red" ## text contentType ## text_T " might be a problem"

revision emailF keyF = 
  let password = unNonEmpty (value keyF)
      email = unEmailAddress (value emailF)
  in
  do item <- io (extractSubmission password)
     ref <- makeRef (itemPassword item ++ itemExtension item) (text_T "view here")
     case item of
       DelItem _ ->
         htell $ standardPage "Error: invalid email/password" (text_S "No such paper.")
       _ ->
         let standardField val = inputField (fieldSIZE 60 ## fieldVALUE val)
	 in venueQuery  "Revision/Withdrawal of Submission" $
         do text_T "Previously submitted version: "
	    ref
	    br_T empty
	    table_T $
	      do authorF <- tr_T $ question "Authors" (standardField (NonEmpty $ itemAuthor item))
		 titleF  <- tr_T $ question "Title of paper" (standardField (NonEmpty $ itemTitle item))
		 affiliationF <- tr_T $ question "Affiliation" (standardField (NonEmpty $ itemAffiliation item))
		 emailF  <- tr_T $ question "Email" (standardField (EmailAddress (itemEmail item)))
		 tr_T $ (td_S empty ## td_S (text_S "(corresponding author only)"))
		 tr_T (td_S (text_S "Abstract" ## attr_SS "colspan" "2"))
		 abstractF <- tr_T (td_S (makeTextarea (itemAbstract item) (attr_SS "rows" "10" ## attr_SS "cols" "75") ## attr_SS "colspan" "2"))
		 paperF <- tr_T $ question "Filename of paper" (fileInputField (fieldSIZE 40))
		 tr_T (td_S (submit (F6 authorF titleF affiliationF emailF abstractF paperF)
		                (processSubmission (Just password))
				(fieldVALUE "Resubmit paper") ## attr "align" "center")
		  ## td_T (submit0 (withdraw item) (fieldVALUE "Withdraw paper") ## attr "align" "center"))


withdraw item =
  do let password = itemPassword item
     io (delItem password)
     let fullName = ?storeDirectory ++ password ++ itemExtension item
     io (writeFile fullName "")
     htell $ standardPage "Withdrawal complete" 
     	    (text_S "Your submission has been removed from the system.")

notImplemented =
  htell $ standardPage "Not yet implemented..." empty

getFileSuffix name 
 | ".ps"    `isSuffixOf` name = ".ps"
 | ".ps.gz" `isSuffixOf` name = ".ps.gz" 
 | ".pdf"   `isSuffixOf` name = ".pdf"
 | otherwise                  = ""
 
