module Main where

import List
import CGI
import CGITypes
import Prelude hiding (div)

main :: IO ()
main =
  run mainCGI

toppings =
    [(0, 0.45, "Onions", "/sliced_onions.gif")
    ,(1, 1.25, "Pepper", "/pepper_small.gif")
    ,(2, 0.25, "Extra Cheese", "/pizza_cheese.gif")
    ,(3, 1.00, "Mushrooms", "/sliced_mushrooms.gif")
    ,(4, 0.75, "Ham", "/baked-ham.gif")
    ]

nrToppings = 
  length toppings

mainCGI =
  selectionPage [] [0..nrToppings - 1]

selectionPage selected available =
  standardQuery "Giovannis CyberPizza" $ do
    displayPizza selected
    hr_S $ empty
    displaySelection selected available
    hr_S $ empty
    amount <- displayBill selected available
    hr_S $ empty
    displayPayment amount

displayPizza selected =
  do p_S $ text_S "Dear friend! I'm Giovanni! That's your yummy pizza:" 
     img_S $ do
       attr_SS "src" "/pizza.gif"
       attr_SS "style" "position:absolute; top:0px; right:0px"
     mapM_ (displayTopping 0) selected
     mapM_ (displayTopping 1) selected
     mapM_ (displayTopping 2) selected
  where
    displayTopping off sel =
      let (nr, price, name, imgLoc) = toppings !! sel
	  circ = 2 * pi
	  arc = circ / (fromIntegral (nrToppings * 3))
	  arc' = arc * fromIntegral (sel + off * nrToppings)
	  x = show $ 160 - 100 * sin arc'
	  y = show $ 170 + 100 * cos arc'
	  style = "position:absolute; top:" ++ y ++ "px; right:" ++ x ++ "px"
      in img_T $ do
	attr_SD "src" imgLoc
	attr_SD "style" style

displaySelection selected available =
  do p_T $ text_S "Giovanni! Slap some more on my pizza!"
     table_T $ tbody_S $
       mapM_ 
	 ( \ sel ->
	   let (nr, price, name, imgLoc) = toppings !! sel
	   in tr_T $ do 
	     td_S $ myButton F0 (addTopping sel selected available) "Please Add"
	     imgH <- externalImage (URL imgLoc) name
	     td_S $ makeImg imgH empty
	     td_S $ text $ " for only " ++ show price ++ " bucks!")
	 available

displayBill selected available =
  do p_T $ text_S "And here is your bill ..." 
     prices <- table_T $ tbody_S $ do
       tr_S $ do 
	 td_S $ text_S "Your Pizza"
	 td_S $ text_S "$ 5.00"
       mapM 
	 ( \ sel ->
	   let (nr, price, name, imgLoc) = toppings !! sel
	   in tr_T $ do
	     td_S $ text $ "with " ++ name
	     td_S $ text $ "$ " ++ show price
	     td_S $ myButton F0 (deleteTopping sel selected available) "Ooops!"
	     return price)
	 selected
     let amount = sum prices + 5.00
     p_T $ text $ 
       "Altogether, this is only " ++ (show amount) ++ " bucks! Incredible!"
     return amount

displayPayment amount =
  table_T $ tbody_S $ tr_S $ do
    td_S $ text_S "My Credit Card is a " 
    mpyF <- td_T $ selectSingle displayCard Nothing [0..2] empty
    td_S $ text_S "Card No"
    ccnrF <- td_T (inputField (fieldSIZE 16))
    td_S (text "Expires")
    ccexF <- td_T (inputField (fieldSIZE  5))
    td_S $ myButton (F3 mpyF ccnrF ccexF) (endAction amount) "Pay'n'Munch"

addTopping sel selected available F0 =
  selectionPage (sort $ sel : selected) (available \\ [sel])

deleteTopping sel selected available F0 =
  selectionPage (selected \\ [sel]) (sort $ sel : available)

endAction amount (F3 mpyF ccnrF ccexF) =
  let ccnr = unCreditCardNumber (value ccnrF)
      expMonth = cceMonth (value ccexF)
  in
  standardQuery "Confirm Credit Payment" $
  do p_T $ text $ "Received credit card payment of $" ++ show amount 
     p_T $ text_S "Thanks for ordering at Giovanni's!"

myButton handles continuation text =
  submit 
    handles 
    continuation 
    ((fieldVALUE text) ## attr "style" "background: white")

displayCard 0 = "MasterCard"
displayCard 1 = "Visa"
displayCard 2 = "American Express"
