--  2001-2003 Peter Thiemann
{-|
  One stop shop for the WASH\/CGI library. All high-level scripts should 
  get along with importing just this module. Low-level scripts may have to 
  import "RawCGI".
  -} 
module CGI (
	-- * Basics
	CGI
	, ask, tell, io, run, runWithOptions
	, once, forever, callWithCurrentHistory, htell, askOffline
	-- * Links and Images
	, Image, internalImage, externalImage, makeImg, makeRef, makePopupRef, makeA
	, backLink, hlink, popuplink, restart
	-- * Page Templates
	, H.standardPage, H.htmlHeader, H.html, H.cssPage, H.cssHeader
	-- * Forms and Widgets
	, HTMLField
	-- ** Form Creation
	, makeForm, standardQuery
	-- ** Form Submission
	, submit, submit0, defaultSubmit, resetField, activeInputField, activate
	, submitLink, submitLink0, defaultSubmitLink
	, submitx, DTree, dtleaf, dtnode
	-- ** Textual Input 
	, inputField, textInputField, checkedTextInputField, passwordInputField, makeTextarea
	-- ** Checkbox
	, checkboxInputField
	-- ** Button
	, makeButton, RadioGroup, radioGroup, radioButton, radioError
	-- ** Image
	, imageField
	-- ** Selection Box
	, selectMultiple, selectSingle, selectBounded
	-- ** File
	, fileInputField, checkedFileInputField
	-- ** Abstract Selection
	, as_rows, as_cols, table_io, getText, unAR
	, selectionGroup, selectionButton, selectionDisplay
	, choiceGroup, choiceButton, choiceDisplay
	-- ** Handle Manipulation
	, InputField, VALID, INVALID, value, InputHandle, HasValue
	, F0 (F0), F1 (F1), F2 (F2), F3 (F3), F4 (F4), F5 (F5), F6 (F6), F7 (F7), F8 (F8)
	, FL (FL), FA (FA)
	-- ** Handle Concatenation
	, concatFields, concatFieldsWith
	-- ** Attribute Shortcuts
	, fieldSIZE, fieldMAXLENGTH, fieldVALUE
	-- * Advanced
	-- ** Installing Translators
	, runWithHook, docTranslator, lastTranslator
	-- ** Outputable Stuff
	, CGIOutput, Status(..), Location(..), FreeForm(..), FileReference (..)
	-- ** Predefined Types for Input Fields
	, Text(..), NonEmpty(..), AllDigits(..), Phone(..)
	, EmailAddress(..), CreditCardNumber(..), CreditCardExp(..)
	, Password(..), Optional(..)
	-- ** Lowlevel Stuff
	, CGIOption (..), CGIOptions, URL (..)
	-- ** Servlets
	, makeServlet, makeServletWithHook
	-- * HTML and Style
	, module HTMLWrapper
	, module Style
	-- * Experimental Stuff
	, FrameSet, FrameLayout(..), FrameSpacing(..), makeFrame, makeFrameset, framesetPage
	)
where

import qualified Prelude
import AbstractSelector
  	( as_rows, as_cols, table_io, getText, unAR
	, selectionGroup, selectionButton, selectionDisplay
	, choiceGroup, choiceButton, choiceDisplay
	)
import CGITypes
	( FileReference(..), CGIOption(..), CGIOptions, URL(..)
	)
import CGIMonad (CGI)
import CGIInternals 
	( io, once, forever, callWithCurrentHistory, ask, askOffline
	, run, runWithOptions, runWithHook, makeRef, makeA, makePopupRef, popuplink
	, InputField, VALID, INVALID
	, makeForm, makeImg, Image, internalImage, externalImage
	, HTMLField, resetField, activeInputField
	, inputField, textInputField, checkedTextInputField, passwordInputField
	, checkboxInputField, fileInputField, checkedFileInputField, imageField
	, RadioGroup, radioGroup, radioButton, radioError, makeButton
	, makeTextarea
	, selectMultiple, selectSingle, selectBounded
	, fieldSIZE, fieldMAXLENGTH, fieldVALUE
	, tell, htell, backLink, hlink, restart
	, concatFields, concatFieldsWith
	, standardQuery
	, docTranslator, lastTranslator
	, makeServlet, makeServletWithHook
	)
import Submit98 
	( value, InputHandle, HasValue
	, F0 (F0), F1 (F1), F2 (F2), F3 (F3), F4 (F4), F5 (F5), F6 (F6), F7 (F7), F8 (F8)
	, FL (FL), FA (FA)
	, submit, submit0, defaultSubmit, DTree, submitx, dtleaf, dtnode
	, submitLink, submitLink0, defaultSubmitLink
	, activate
	)
import CGIOutput
	( CGIOutput
	)
import CGITypes
	( Status(..), Location(..), FreeForm(..)
	)
import Fields
import Style 
import HTMLWrapper
  hiding (input, form, select, option, textarea, 
          cssHeader, cssPage, html, htmlHeader, standardPage)
import qualified HTMLWrapper as H

import Frames 
  (FrameSet, FrameLayout(..), FrameSpacing(..), makeFrame, makeFrameset, framesetPage)
